/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class ElementMove {
    private final UniqueAbapElementName element;
    private final String newPackagePath;

    public ElementMove(UniqueAbapElementName element, String newPackagePath) {
        this.element = element;
        newPackagePath = FileSystemUtils.normalizeSeparators((String)newPackagePath);
        if (!((String)newPackagePath).endsWith(UniformPathUtils.SEPARATOR)) {
            newPackagePath = (String)newPackagePath + UniformPathUtils.SEPARATOR;
        }
        this.newPackagePath = newPackagePath;
    }

    public UniqueAbapElementName getElement() {
        return this.element;
    }

    public String buildDestinationPath(String sourcePath) throws GitBridgeException {
        ParsedAbapElementPath parsedSourcePath = AbapGitImporterUtils.buildParsedAbapElementPath(sourcePath);
        this.checkElementPath(parsedSourcePath);
        return this.newPackagePath + parsedSourcePath.getElementPath();
    }

    private void checkElementPath(ParsedAbapElementPath path) throws GitBridgeException {
        EAbapObjectType moveElementType;
        UniqueAbapElementName pathElement = path.getElementName();
        if (pathElement.equals((Object)this.element)) {
            return;
        }
        EAbapObjectType pathElementType = pathElement.getObjectType();
        if (pathElementType == (moveElementType = this.element.getObjectType())) {
            if (pathElementType == EAbapObjectType.FUGR && path.getFunctionGroup().equals(this.element.getObjectName())) {
                return;
            }
            if ((pathElementType == EAbapObjectType.CLAS || pathElementType == EAbapObjectType.INTF) && path.getClassName().equals(this.element.getObjectName())) {
                return;
            }
        }
        throw new GitBridgeException(String.valueOf(path) + " does not point to an ABAP element with name " + String.valueOf(this.element));
    }
}

