/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.code_inspector;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.ZipToGitImporter;
import com.teamscale.index.gitbridge.ZipToGitImporterUtils;
import com.teamscale.index.gitbridge.abap.AbapExportXmlTableReaderBase;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorData;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.EMethodIncludeFields;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.abap.codeinspector.CodeInspectorUtils;
import org.conqat.engine.abap.codeinspector.ECodeInspectorResultFields;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.string.StringUtils;

public class CodeInspectorGitImporter {
    private static final Pattern SCI_RESULTS_FILE_PATTERN = Pattern.compile("ci_results.*\\.xml");
    private static final Pattern METHODS_INCLUDE_FILE_PATTERN = Pattern.compile("method_includes.*\\.xml");
    private static final Pattern PRIVATE_SECTION_PATTERN = Pattern.compile("PRIVATE\\s+SECTION\\s*.", 2);
    private static final Pattern PROTECTED_SECTION_PATTERN = Pattern.compile("PROTECTED\\s+SECTION\\s*.", 2);
    private final ZipFile zipFile;
    private static final Logger LOGGER = LogManager.getLogger();
    private final SetMap<UniqueAbapElementName, CodeInspectorData> elementIssuesMap = new SetMap();
    private final Map<String, Integer> methodIncludeOffsetMap = new HashMap<String, Integer>();
    private final AbapClassSectionStartLineCache privateSectionStartOffsetCache = new AbapClassSectionStartLineCache(this, PRIVATE_SECTION_PATTERN);
    private final AbapClassSectionStartLineCache protectedSectionStartOffsetCache = new AbapClassSectionStartLineCache(this, PROTECTED_SECTION_PATTERN);
    private final ZipToGitImporter zipImporter;
    private boolean containsCodeInspectorResults = false;

    public CodeInspectorGitImporter(ZipToGitImporter zipImporter, ZipFile zipFile) {
        this.zipImporter = zipImporter;
        this.zipFile = zipFile;
        this.readMethodIncludeFilesAndFillMap();
        this.readCodeInspectorResultFilesAndFillMap();
    }

    public boolean containsCodeInspectorResults() {
        return this.containsCodeInspectorResults;
    }

    private void readMethodIncludeFilesAndFillMap() {
        Set<String> xmlFileEntries = ZipToGitImporterUtils.findMatchingFilesInExport(METHODS_INCLUDE_FILE_PATTERN, this.zipFile);
        ZipToGitImporterUtils.feedEachXmlFileToProcessor(this.zipFile, xmlFileEntries, new MethodIncludesProcessor(this), "method includes");
    }

    private void readCodeInspectorResultFilesAndFillMap() {
        Set<String> xmlFileEntries = ZipToGitImporterUtils.findMatchingFilesInExport(SCI_RESULTS_FILE_PATTERN, this.zipFile);
        ZipToGitImporterUtils.feedEachXmlFileToProcessor(this.zipFile, xmlFileEntries, new CodeInspectorResultsProcessor(this), "SAP Code Inspector results");
        int sciFilesCount = xmlFileEntries.size();
        if (sciFilesCount > 0) {
            this.containsCodeInspectorResults = true;
        }
    }

    public boolean updateCodeInspectorResultsFiles(List<String> abapElementPaths) throws GitBridgeException {
        if (!this.containsCodeInspectorResults) {
            return false;
        }
        ArrayList<String> sciFileNames = new ArrayList<String>();
        for (String abapElementPath : abapElementPaths) {
            String sciFileName = this.updateCodeInspectorResultsFile(abapElementPath);
            if (sciFileName == null) continue;
            sciFileNames.add(sciFileName);
        }
        return this.zipImporter.add(sciFileNames);
    }

    private String updateCodeInspectorResultsFile(String abapElementPath) {
        List<CodeInspectorData> issues = this.getCodeInspectorIssues(abapElementPath);
        String sciFileName = CodeInspectorGitUtils.buildCodeInspectorFileName(abapElementPath);
        File sciFile = new File(this.zipImporter.getWorkTree(), sciFileName);
        try {
            FileSystemUtils.deleteFile((File)sciFile);
        }
        catch (IOException e) {
            LOGGER.error("Deletion of Code Inspector results file " + String.valueOf(sciFile) + " failed.", (Throwable)e);
            return null;
        }
        try {
            FileSystemUtils.writeFile((File)sciFile, (String)JsonUtils.serializeToJSON(issues), (Charset)AbapUtils.ABAP_ENCODING);
        }
        catch (IOException e) {
            LOGGER.error("Writing Code Inspector results file " + String.valueOf(sciFile) + " failed.", (Throwable)e);
        }
        return sciFileName;
    }

    private List<CodeInspectorData> getCodeInspectorIssues(String abapElementPath) {
        UniqueAbapElementName abapElement = AbapUtils.createElementNameFromPath((String)abapElementPath);
        HashSet<CodeInspectorData> issues = (HashSet<CodeInspectorData>)this.elementIssuesMap.getCollection((Object)abapElement);
        if (issues == null) {
            issues = new HashSet<CodeInspectorData>();
        }
        if (CodeInspectorGitImporter.containsFailedExecutionOfExtendedCheck((Set<CodeInspectorData>)issues)) {
            issues.addAll(this.readExistingExtendedCheckIssues(abapElementPath));
        }
        for (CodeInspectorData sciIssue : issues) {
            this.adjustLineIfClassSectionIssue(sciIssue, abapElementPath);
        }
        return CollectionUtils.sort(issues, Comparator.comparing(d -> d.getStartLine()).thenComparing(d -> d.getFindingTypeId()).thenComparing(d -> d.getMessage()));
    }

    private void adjustLineIfClassSectionIssue(CodeInspectorData issue, String abapElementPath) {
        if (!CodeInspectorUtils.CLASS_INCLUDE_PATTERN.matcher(issue.getsObjectName()).matches()) {
            return;
        }
        int sectionStartLine = 0;
        try {
            if (AbapUtils.isPrivateSectionInclude((String)issue.getsObjectName())) {
                sectionStartLine = this.privateSectionStartOffsetCache.findStartLineOfSection(abapElementPath);
            } else if (AbapUtils.isProtectedSectionInclude((String)issue.getsObjectName())) {
                sectionStartLine = this.protectedSectionStartOffsetCache.findStartLineOfSection(abapElementPath);
            }
        }
        catch (GitBridgeException e) {
            LOGGER.warn("Could not adjust line of SCI finding in " + abapElementPath + ":" + issue.getStartLine() + " because file content was not readable. Leaving this finding unadjusted.");
            return;
        }
        if (sectionStartLine == -1) {
            LOGGER.warn("Could not adjust line of SCI finding in " + abapElementPath + ":" + issue.getStartLine() + ". Could not find start line of private/protected section. Leaving this finding unadjusted.");
        } else if (sectionStartLine > 0) {
            issue.addElementOffset(sectionStartLine - 1);
        }
    }

    private static boolean containsFailedExecutionOfExtendedCheck(Set<CodeInspectorData> issues) {
        return issues.stream().anyMatch(issue -> issue.isFailedExecutionOfExtendedCheck());
    }

    private Set<CodeInspectorData> readExistingExtendedCheckIssues(String abapElementPath) {
        File existingSciFile = new File(this.zipImporter.getWorkTree(), CodeInspectorGitUtils.buildCodeInspectorFileName(abapElementPath));
        if (!existingSciFile.isFile()) {
            return Collections.emptySet();
        }
        try {
            String json = FileSystemUtils.readFileUTF8((File)existingSciFile);
            HashSet<CodeInspectorData> issues = new HashSet<CodeInspectorData>(Arrays.asList((CodeInspectorData[])JsonUtils.deserializeFromJson((String)json, CodeInspectorData[].class)));
            return CollectionUtils.filterToSet(issues, issue -> issue.getTestType().isExtendedCheck());
        }
        catch (IOException e) {
            LOGGER.error("Could not read Code Inspector results file " + String.valueOf(existingSciFile), (Throwable)e);
            return Collections.emptySet();
        }
        catch (ConQATException e) {
            LOGGER.error("Could not deserialize Code Inspector results json from " + String.valueOf(existingSciFile), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private class AbapClassSectionStartLineCache {
        private final Pattern sectionPattern;
        private final Map<String, Integer> cache;
        final /* synthetic */ CodeInspectorGitImporter this$0;

        private AbapClassSectionStartLineCache(CodeInspectorGitImporter codeInspectorGitImporter, Pattern sectionPattern) {
            CodeInspectorGitImporter codeInspectorGitImporter2 = codeInspectorGitImporter;
            Objects.requireNonNull(codeInspectorGitImporter2);
            this.this$0 = codeInspectorGitImporter2;
            this.cache = new HashMap<String, Integer>();
            this.sectionPattern = sectionPattern;
        }

        private int findStartLineOfSection(String abapElementPath) throws GitBridgeException {
            Integer cachedOffset = this.cache.get(abapElementPath);
            if (cachedOffset != null) {
                return cachedOffset;
            }
            String abapFileContent = this.this$0.zipImporter.readContent(abapElementPath, AbapUtils.ABAP_ENCODING);
            int privateSectionStartLine = AbapClassSectionStartLineCache.countLinebreaksBeforePatternMatch(abapFileContent, this.sectionPattern);
            this.cache.put(abapElementPath, privateSectionStartLine);
            return privateSectionStartLine;
        }

        private static int countLinebreaksBeforePatternMatch(String abapFileContent, Pattern pattern) {
            Matcher matcher = pattern.matcher(abapFileContent);
            if (!matcher.find()) {
                return -1;
            }
            return StringUtils.countLines((String)abapFileContent.substring(0, matcher.start()), (boolean)true);
        }
    }

    private class MethodIncludesProcessor
    implements ZipToGitImporterUtils.IXmlTableProcessor {
        final /* synthetic */ CodeInspectorGitImporter this$0;

        private MethodIncludesProcessor(CodeInspectorGitImporter codeInspectorGitImporter) {
            CodeInspectorGitImporter codeInspectorGitImporter2 = codeInspectorGitImporter;
            Objects.requireNonNull(codeInspectorGitImporter2);
            this.this$0 = codeInspectorGitImporter2;
        }

        @Override
        public void processXml(String content) throws GitBridgeException {
            new MethodIncludesReader(this.this$0, content);
        }
    }

    private class CodeInspectorResultsProcessor
    implements ZipToGitImporterUtils.IXmlTableProcessor {
        final /* synthetic */ CodeInspectorGitImporter this$0;

        private CodeInspectorResultsProcessor(CodeInspectorGitImporter codeInspectorGitImporter) {
            CodeInspectorGitImporter codeInspectorGitImporter2 = codeInspectorGitImporter;
            Objects.requireNonNull(codeInspectorGitImporter2);
            this.this$0 = codeInspectorGitImporter2;
        }

        @Override
        public void processXml(String content) throws GitBridgeException {
            new CodeInspectorResultsReader(this.this$0, content);
        }
    }

    private class MethodIncludesReader
    extends AbapExportXmlTableReaderBase<EMethodIncludeFields> {
        final /* synthetic */ CodeInspectorGitImporter this$0;

        public MethodIncludesReader(CodeInspectorGitImporter codeInspectorGitImporter, String content) throws GitBridgeException {
            CodeInspectorGitImporter codeInspectorGitImporter2 = codeInspectorGitImporter;
            Objects.requireNonNull(codeInspectorGitImporter2);
            this.this$0 = codeInspectorGitImporter2;
            super(EMethodIncludeFields.class);
            this.readRecords(content);
        }

        @Override
        protected EMethodIncludeFields getRecordElement() {
            return EMethodIncludeFields.ITEM;
        }

        @Override
        protected void processRecord() {
            String includeName = this.getChildText(EMethodIncludeFields.INCNAME);
            int offset = Integer.parseInt(this.getChildText(EMethodIncludeFields.OFFSET));
            String startLineText = this.getChildText(EMethodIncludeFields.START_LINE);
            int startLine = 0;
            if (!StringUtils.isEmpty((String)startLineText)) {
                startLine = Integer.parseInt(startLineText);
            }
            this.this$0.methodIncludeOffsetMap.put(includeName, offset + startLine - 1);
        }
    }

    private class CodeInspectorResultsReader
    extends AbapExportXmlTableReaderBase<ECodeInspectorResultFields> {
        final /* synthetic */ CodeInspectorGitImporter this$0;

        public CodeInspectorResultsReader(CodeInspectorGitImporter codeInspectorGitImporter, String content) throws GitBridgeException {
            CodeInspectorGitImporter codeInspectorGitImporter2 = codeInspectorGitImporter;
            Objects.requireNonNull(codeInspectorGitImporter2);
            this.this$0 = codeInspectorGitImporter2;
            super(ECodeInspectorResultFields.class);
            this.readRecords(content);
        }

        @Override
        protected ECodeInspectorResultFields getRecordElement() {
            return ECodeInspectorResultFields.item;
        }

        @Override
        protected void processRecord() {
            Integer offset;
            String sobjType;
            String objName;
            String sobjName = this.getChildText(ECodeInspectorResultFields.SOBJNAME);
            String objType = this.getChildText(ECodeInspectorResultFields.OBJTYPE);
            UniqueAbapElementName abapElement = CodeInspectorUtils.buildAbapElementNameForCodeInspectorResult((String)objType, (String)(objName = this.getChildText(ECodeInspectorResultFields.OBJNAME)), (String)(sobjType = this.getChildText(ECodeInspectorResultFields.SOBJTYPE)), (String)sobjName);
            if (abapElement == null) {
                return;
            }
            int errcnt = Integer.parseInt(this.getChildText(ECodeInspectorResultFields.ERRCNT));
            int conseccnt = Integer.parseInt(this.getChildText(ECodeInspectorResultFields.CONSECCNT));
            int line = Integer.parseInt(this.getChildText(ECodeInspectorResultFields.LINE));
            int col = Integer.parseInt(this.getChildText(ECodeInspectorResultFields.COL));
            CodeInspectorData data = new CodeInspectorData(this.getChildText(ECodeInspectorResultFields.INSPECID), this.getChildText(ECodeInspectorResultFields.INSPECVERS), this.getChildText(ECodeInspectorResultFields.CIUSER), objType, objName, this.getChildText(ECodeInspectorResultFields.TEST), errcnt, conseccnt, sobjName, sobjType, line, col, this.getChildText(ECodeInspectorResultFields.KIND), this.getChildText(ECodeInspectorResultFields.CODE), this.getChildText(ECodeInspectorResultFields.PARAM1), this.getChildText(ECodeInspectorResultFields.PARAM2), this.getChildText(ECodeInspectorResultFields.PARAM3), this.getChildText(ECodeInspectorResultFields.PARAM4), this.getChildText(ECodeInspectorResultFields.TEXT));
            if (abapElement.getObjectType() == EAbapObjectType.CLAS && (offset = this.this$0.methodIncludeOffsetMap.get(sobjName)) != null && offset > 0) {
                data.addElementOffset(offset);
            }
            this.this$0.elementIssuesMap.add((Object)abapElement, (Object)data);
        }
    }
}

