/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issue_reference;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.issue_reference.CodeToReferenceMappingSynchronizerBase;
import com.teamscale.index.resource.issue_reference.EIssueReferenceType;
import com.teamscale.index.resource.issue_reference.IssueReference;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class CodeToIssueReferenceMappingSynchronizer
extends CodeToReferenceMappingSynchronizerBase {
    public static final String ISSUE_ID_IN_COMMENT_PATTERN_PARAMETER = "issue-id-in-comment-pattern";
    @StepParameter(value="issue-id-in-comment-pattern")
    private static String issueIdInCommentPattern;

    public void execute() throws ConQATException {
        Pattern issueIdPattern = Pattern.compile(issueIdInCommentPattern);
        PairList<String, ArrayList<IssueReference>> uniformPathsWithIssueReferences = this.getUniformPathsIssueReferences(issueIdPattern);
        this.storeIssueReferences(uniformPathsWithIssueReferences);
        this.removeValuesFromIssueReferenceIndex();
    }

    @Override
    protected EIssueReferenceType getIssueReferenceType() {
        return EIssueReferenceType.ISSUE;
    }

    @Override
    protected void createIssueReferenceForIssueReferenceIdInComment(String issueReferenceId, String uniformPath, Map<String, List<OffsetBasedRegion>> regionsByReferenceId, Comment comment, List<ShallowEntity> entities, List<ShallowEntity> nonPreprocessedEntities) {
        this.createIssueReference(issueReferenceId, uniformPath, regionsByReferenceId, comment.getToken().getOffset());
    }
}

