/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.IPostTriggerAction;
import com.teamscale.core.analysis.trigger.IPreAnnouncingAnalysisStep;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.WorkItemChangeAggregationGrouper;
import com.teamscale.index.issues.updater.IssueTrackerContentUpdaterBase;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemChangesIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.index.TempWorkItemIndex;
import com.teamscale.index.requirements_tracing.index.WorkItemChange;
import com.teamscale.index.requirements_tracing.index.WorkItemChangeCache;
import com.teamscale.index.requirements_tracing.index.WorkItemChangeCacheFactory;
import com.teamscale.index.requirements_tracing.index.WorkItemDeletion;
import com.teamscale.index.requirements_tracing.index.WorkItemUpdate;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class IssueTrackerSynchronizerBase<T extends TeamscaleIssue>
extends ChangeRetrieverAnalysisStep
implements IPreAnnouncingAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String PROJECT_PARAMETER = "project";
    public static final String CUSTOM_FIELD_PARAMETER = "custom-field";
    public static final String INITIAL_TIMESTAMP_PARAMETER = "initial-timestamp";
    public static final String IMPORT_ONLY_ITEMS_CHANGED_AFTER_PARAMETER = "import-only-items-changed-after";
    public static final String CONNECTOR_ID_PARAMETER = "connector-id";
    public static final String POLLING_INTERVAL_SECONDS_PARAMETER = "polling-interval-seconds";
    public static final long INITIAL_TIMESTAMP_VALUE = 0L;
    private static final String CHANGE_AGGREGATION_GROUPER_PREFIX = "changeAggregationGrouper-";
    public static final String CHANGE_AGGREGATION_ENABLED_PARAMETER = "changeAggregationGrouper-enabled";
    public static final String MAXIMUM_AGGREGATION_SPAN_PARAMETER = "changeAggregationGrouper-maximumAggregationSpan";
    public static final String MAXIMUM_SESSION_LENGTH_PARAMETER = "changeAggregationGrouper-maximumSessionLength";
    @StepParameter(value="connector-id")
    protected String connectorId;
    @StepParameter(value="polling-interval-seconds")
    protected long pollingIntervalSeconds;
    @StepParameter(value="custom-field", optional=true)
    protected final PairList<String, Boolean> customFields = new PairList();
    @StepParameter(value="project", optional=true)
    protected final Set<String> projects = new HashSet<String>();
    @StepParameter(value="initial-timestamp", optional=true)
    private long initialTimestamp = 0L;
    @StepParameter(value="import-only-items-changed-after", optional=true)
    private long importOnlyItemsChangedAfter = 0L;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;
    @StepParameterObject(namePrefix="changeAggregationGrouper-")
    private final WorkItemChangeAggregationGrouper changeAggregationGrouper = new WorkItemChangeAggregationGrouper();
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex externalCredentialsIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private TempWorkItemIndex tempWorkItemIndex;
    @IndexAccess.Dynamic(value=EIndexAccessMode.READ_WRITE)
    private SpecItemChangesIndex changesIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectConnectorStatusIndex connectorStatusIndex;
    private WorkItemChangeCacheFactory changeCacheFactory;
    private String url;
    private String username;
    private String password;
    private Instant currentImportStart;
    private long originalLastChangeTimestamp = 0L;

    private @Nullable ExternalCredentials getExternalCredentials() throws BugTrackerException {
        ExternalCredentials externalCredentials;
        try {
            externalCredentials = this.externalCredentialsIndex.getExternalCredentials(this.accountIdentifier);
        }
        catch (StorageException e) {
            throw new BugTrackerException("Account '" + this.accountIdentifier + "' could not be retrieved.", e);
        }
        return externalCredentials;
    }

    protected final Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> executeChangeRetriever() throws Exception {
        String branchName = SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName(this.connectorId);
        this.loadLastChangeTimestamp(branchName);
        CommitDescriptor parent = this.getParent(branchName);
        if (this.getSchedulingCommit() == null) {
            ParentedCommitDescriptor schedulingHint = new ParentedCommitDescriptor(new CommitDescriptor(branchName, this.originalLastChangeTimestamp + 1L), IssueTrackerSynchronizerBase.asCommitList(parent));
            return List.of(new IPostTriggerAction.RescheduleWith(List.of(schedulingHint)));
        }
        if (this.getSchedulingCommit().getTimestamp() > this.originalLastChangeTimestamp) {
            try {
                this.storeConnectorInitStatus();
                this.initialize();
                ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction> postTriggerActions = new ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction>(this.retrieveAndProcessUpdatedItems(branchName, parent));
                postTriggerActions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.IgnoreOutputDelta());
                return postTriggerActions;
            }
            catch (BugTrackerException e) {
                String errorMessage = "Error updating issues: " + e.getMessage();
                if (e.getCause() != null) {
                    errorMessage = errorMessage + ". Caused by: " + e.getCause().getMessage();
                }
                LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log(errorMessage);
                this.storeConnectorDownStatus(e);
                return Collections.emptyList();
            }
        }
        ArrayList<WorkItemChange> workItemChanges = this.tempWorkItemIndex.getChangesForCommit(this.getSchedulingCommit());
        List<RepositoryChangeEntry> changes = this.buildRepositoryChangeEntries(workItemChanges);
        this.changesIndex.addChangedFiles(changes);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> retrieveAndProcessUpdatedItems(String branchName, CommitDescriptor parent) throws BugTrackerException, StorageException {
        this.changeCacheFactory = this.tempWorkItemIndex.getWorkItemChangeCacheFactory();
        try {
            WorkItemUpdateResult updateResult = this.retrieveUpdatedItems(this.originalLastChangeTimestamp, this.initialTimestamp, this.importOnlyItemsChangedAfter);
            if (updateResult.isEmpty()) {
                List<IPostTriggerAction.IChangeRetrieverPostTriggerAction> list = Collections.emptyList();
                return list;
            }
            LOGGER.atDebug().log("Updating {} items", (Object)updateResult.cache.getChanges().size());
            Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> collection = this.processUpdatedItems(branchName, parent, updateResult);
            return collection;
        }
        finally {
            this.setConnectorStatus();
            this.changeCacheFactory.clearCaches();
        }
    }

    private boolean shouldUpdateIndexDirectly() {
        return Arrays.stream(IStorageIndex.getIndexAnnotation(this.getWorkItemIndex().getClass()).options()).noneMatch(arg_0 -> EStorageOption.BRANCHED.equals(arg_0));
    }

    private List<RepositoryChangeEntry> buildRepositoryChangeEntries(List<WorkItemChange> workItemChanges) throws StorageException {
        ArrayList<RepositoryChangeEntry> changes = new ArrayList<RepositoryChangeEntry>();
        for (WorkItemChange workItemChange : workItemChanges) {
            RepositoryChangeEntry changeEntry = this.buildRepositoryChangeEntry(workItemChange);
            if (changeEntry == null) continue;
            changes.add(changeEntry);
        }
        return changes;
    }

    private @Nullable RepositoryChangeEntry buildRepositoryChangeEntry(WorkItemChange workItemChange) throws StorageException {
        UniformPath path;
        ERepositoryChangeType changeType;
        String revision;
        switch (workItemChange.getChangeType()) {
            case UPDATE: {
                TeamscaleIssue updatedItem = workItemChange.getUpdatedItem();
                revision = String.valueOf(updatedItem.getUpdated());
                changeType = this.determineRepositoryChangeType(updatedItem);
                path = updatedItem.getUniformPath();
                break;
            }
            case DELETION: {
                revision = String.valueOf(workItemChange.getDeletionTimestamp());
                changeType = ERepositoryChangeType.DELETE;
                T previousIssue = this.getWorkItemIndex().getIssue(workItemChange.getWorkItemId());
                if (previousIssue == null) {
                    LOGGER.atWarn().log("Cannot delete not present issue {} at {}", (Object)workItemChange.getWorkItemId(), (Object)this.getSchedulingCommit());
                    return null;
                }
                path = previousIssue.getUniformPath();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected value: " + String.valueOf((Object)workItemChange.getChangeType()));
            }
        }
        return new RepositoryChangeEntry(path, revision, changeType, this.getSchedulingCommit(), EChangeEntryOrigin.ISSUE_UPDATE);
    }

    private static @NonNull List<CommitDescriptor> asCommitList(@Nullable CommitDescriptor commit) {
        if (commit == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(commit);
    }

    private @NonNull ERepositoryChangeType determineRepositoryChangeType(TeamscaleIssue item) throws StorageException {
        ERepositoryChangeType changeType = ERepositoryChangeType.ADD;
        if (this.getWorkItemIndex().getIssue(item.getId()) != null) {
            changeType = ERepositoryChangeType.EDIT;
        }
        return changeType;
    }

    private Collection<IPostTriggerAction.IChangeRetrieverPostTriggerAction> processUpdatedItems(String branchName, CommitDescriptor parent, WorkItemUpdateResult updateResult) throws StorageException {
        NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> itemsPerCommit = updateResult.getChanges();
        if (itemsPerCommit.isEmpty()) {
            return Collections.emptyList();
        }
        itemsPerCommit = this.changeAggregationGrouper.performAggregation(itemsPerCommit, this.resultBuilder());
        ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction> actions = new ArrayList<IPostTriggerAction.IChangeRetrieverPostTriggerAction>();
        if (this.shouldUpdateIndexDirectly()) {
            this.updateWorkItemIndex(itemsPerCommit);
        } else {
            List<ParentedCommitDescriptor> schedulingHints = this.updateTempWorkItemIndex(branchName, parent, itemsPerCommit);
            if (!schedulingHints.isEmpty()) {
                actions.add((IPostTriggerAction.IChangeRetrieverPostTriggerAction)new IPostTriggerAction.RescheduleWith(schedulingHints));
            }
        }
        if (!itemsPerCommit.isEmpty()) {
            this.tempWorkItemIndex.setLastChange((Long)itemsPerCommit.lastKey());
        }
        return actions;
    }

    private List<ParentedCommitDescriptor> updateTempWorkItemIndex(String branchName, CommitDescriptor parent, SortedMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> itemsPerCommit) throws StorageException {
        this.handleUpdatesBeforeLastChangeTimestamp(itemsPerCommit);
        if (itemsPerCommit.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ParentedCommitDescriptor> schedulingHints = new ArrayList<ParentedCommitDescriptor>();
        for (Map.Entry<Long, SupplierWithException<List<WorkItemChange>, StorageException>> commitWithChanges : itemsPerCommit.entrySet()) {
            long timestamp = commitWithChanges.getKey();
            ParentedCommitDescriptor commit = new ParentedCommitDescriptor(new CommitDescriptor(branchName, timestamp), IssueTrackerSynchronizerBase.asCommitList(parent));
            schedulingHints.add(commit);
            this.tempWorkItemIndex.storeChangesForCommit(commit.getCommit(), (Collection)commitWithChanges.getValue().get());
            parent = commit.getCommit();
        }
        return schedulingHints;
    }

    private void updateWorkItemIndex(SortedMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> itemsPerCommit) throws StorageException {
        Iterator<Map.Entry<Long, SupplierWithException<List<WorkItemChange>, StorageException>>> itemUpdatesIterator = itemsPerCommit.entrySet().iterator();
        while (itemUpdatesIterator.hasNext()) {
            HashMap itemsToStore = new HashMap();
            HashSet<TeamscaleIssueId> itemsToDelete = new HashSet<TeamscaleIssueId>();
            PairList historyEntries = new PairList();
            HashMap<Long, List<TeamscaleIssueId>> historyDeletions = new HashMap<Long, List<TeamscaleIssueId>>();
            this.fillWithNextChangeBatch(itemUpdatesIterator, itemsToStore, itemsToDelete, historyEntries, historyDeletions);
            this.getWorkItemIndex().setIssues(itemsToStore.values());
            this.getWorkItemIndex().removeIssues(itemsToDelete);
            this.getIssueHistoryIndex().store(historyEntries);
            for (Map.Entry entry : historyDeletions.entrySet()) {
                this.getIssueHistoryIndex().remove((Collection)entry.getValue(), (Long)entry.getKey());
            }
        }
        this.getWorkItemIndex().setLastChange(this.connectorId, itemsPerCommit.lastKey());
    }

    private void fillWithNextChangeBatch(Iterator<Map.Entry<Long, SupplierWithException<List<WorkItemChange>, StorageException>>> itemUpdatesIterator, Map<TeamscaleIssueId, T> itemsToStore, Set<TeamscaleIssueId> itemsToDelete, PairList<Long, T> historyEntries, Map<Long, List<TeamscaleIssueId>> historyDeletions) throws StorageException {
        int changeCount = 0;
        int maxChangeCount = 100000;
        while (itemUpdatesIterator.hasNext() && changeCount < maxChangeCount) {
            Map.Entry<Long, SupplierWithException<List<WorkItemChange>, StorageException>> entry = itemUpdatesIterator.next();
            long timestamp = entry.getKey();
            List changes = (List)entry.getValue().get();
            changeCount += changes.size();
            IssueTrackerContentUpdaterBase.GroupedWorkItemChanges groupedWorkItemChanges = IssueTrackerContentUpdaterBase.groupChangesIntoUpdatesAndDeletions(changes);
            for (TeamscaleIssue updatedItem : groupedWorkItemChanges.updatedItems()) {
                LOGGER.atTrace().log("Updated item {} at timestamp: {}", (Object)updatedItem.getId(), (Object)timestamp);
                itemsToDelete.remove(updatedItem.getId());
                itemsToStore.put(updatedItem.getId(), updatedItem);
                historyEntries.add((Object)timestamp, (Object)updatedItem);
            }
            for (TeamscaleIssueId deletedItemId : groupedWorkItemChanges.deletedItemIds()) {
                LOGGER.atTrace().log("Deleted item {} at timestamp: {}", (Object)deletedItemId.getInternalId(), (Object)timestamp);
                itemsToStore.remove(deletedItemId);
                itemsToDelete.add(deletedItemId);
                historyDeletions.computeIfAbsent(timestamp, ignored -> new ArrayList()).add(deletedItemId);
            }
        }
    }

    private void handleUpdatesBeforeLastChangeTimestamp(SortedMap<Long, ?> itemsPerCommit) {
        long minimumTimestamp = Math.max(this.originalLastChangeTimestamp + 1L, this.initialTimestamp);
        SortedMap<Long, ?> changesBeforeLastChangeTimestamp = itemsPerCommit.headMap(minimumTimestamp);
        if (!changesBeforeLastChangeTimestamp.isEmpty()) {
            LOGGER.atWarn().log("Got changes that happened before the minimum timestamp ({}). To avoid rollbacks, they will be ignored: {}", (Object)minimumTimestamp, changesBeforeLastChangeTimestamp.keySet());
            changesBeforeLastChangeTimestamp.clear();
        }
    }

    private CommitDescriptor getParent(String branchName) {
        if (this.originalLastChangeTimestamp == 0L) {
            return null;
        }
        return new CommitDescriptor(branchName, this.originalLastChangeTimestamp);
    }

    private void loadLastChangeTimestamp(String branchName) throws StorageException {
        OptionalLong lastChange = this.tempWorkItemIndex.getLastChange();
        if (lastChange.isEmpty()) {
            this.originalLastChangeTimestamp = 0L;
        } else if (lastChange.getAsLong() < 0L) {
            long rollbackTimestamp = -lastChange.getAsLong();
            OptionalLong lastChangeBeforeRollback = this.commitDescriptorIndex.getCommitsForBranch(branchName).stream().mapToLong(ParentedCommitDescriptor::getTimestamp).filter(t -> t <= rollbackTimestamp).max();
            if (lastChangeBeforeRollback.isPresent()) {
                this.originalLastChangeTimestamp = lastChangeBeforeRollback.getAsLong();
                this.tempWorkItemIndex.setLastChange(this.originalLastChangeTimestamp);
            }
        } else {
            this.originalLastChangeTimestamp = lastChange.getAsLong();
        }
    }

    protected abstract IIssueHistoryIndex<T> getIssueHistoryIndex();

    protected abstract IssueIndexBase<T> getWorkItemIndex();

    protected void initialize() throws BugTrackerException {
        this.initializeFieldsFromExternalAccount();
        this.currentImportStart = DateTimeUtils.now();
        this.init();
    }

    protected void initializeFieldsFromExternalAccount() throws BugTrackerException {
        ExternalCredentials externalCredentials = this.getExternalCredentials();
        if (externalCredentials == null) {
            throw new BugTrackerException("No external account found.");
        }
        if (StringUtils.isEmpty((String)externalCredentials.uri)) {
            throw new BugTrackerException("URL must not be empty in account " + this.accountIdentifier);
        }
        this.url = externalCredentials.uri;
        this.username = externalCredentials.username;
        this.password = externalCredentials.password;
    }

    protected Instant getCurrentImportStart() {
        return this.currentImportStart;
    }

    protected abstract void init() throws BugTrackerException;

    protected abstract WorkItemUpdateResult retrieveUpdatedItems(long var1, long var3, long var5) throws BugTrackerException, StorageException;

    protected final WorkItemUpdateResult.Builder<T> resultBuilder() {
        return IssueTrackerSynchronizerBase.createBuilder(this.changeCacheFactory.createCache());
    }

    @VisibleForTesting
    public static <T extends TeamscaleIssue> WorkItemUpdateResult.Builder<T> createBuilder(WorkItemChangeCache cache) {
        return new WorkItemUpdateResult.Builder(cache);
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getUrl() {
        return this.url;
    }

    protected Set<TeamscaleIssueId> filterToUnknownIssues(List<TeamscaleIssueId> issueIds) throws StorageException {
        return CollectionUtils.differenceSet(issueIds, (Collection[])new Collection[]{this.getWorkItemIndex().getContainedKeys(issueIds)});
    }

    protected Set<String> filterToUnknownIssuesByExternalId(Collection<String> externalIssueIds) throws StorageException {
        List<TeamscaleIssueId> tsIssues = externalIssueIds.stream().map(id -> new TeamscaleIssueId(this.connectorId, id)).collect(Collectors.toList());
        return this.filterToUnknownIssues(tsIssues).stream().map(TeamscaleIssueId::getExternalId).collect(Collectors.toSet());
    }

    protected void addFieldTypeMapping(String name, EKeyedObjectType type) {
        this.addFieldTypeMappings(Map.of(name, type));
    }

    protected void addFieldTypeMappings(Map<String, EKeyedObjectType> fieldTypeMapping) {
        this.getIssueHistoryIndex().getDescriber().addFieldTypeMappings(fieldTypeMapping);
    }

    private void setConnectorStatus() throws StorageException {
        UnmodifiableList errorsAndWarnings = TeamscaleLogAppender.getErrorsAndWarnings();
        if (!errorsAndWarnings.isEmpty()) {
            this.storeConnectorWarningStatus(this.getConnectorId(), ((LogEvent)errorsAndWarnings.getFirst()).getMessage().getFormattedMessage());
        } else {
            this.storeConnectorUpStatus();
        }
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    private void storeConnectorDownStatus(Exception e) throws StorageException {
        this.storeConnectorDownStatus(this.getConnectorId(), "Error fetching new revisions: " + e.getMessage());
    }

    private void storeConnectorDownStatus(String connectionIdentifier, String errorMessage) throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(connectionIdentifier, ProjectConnectorStatus.EConnectorStatus.ERROR, errorMessage);
    }

    private void storeConnectorUpStatus() throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(this.getConnectorId(), ProjectConnectorStatus.EConnectorStatus.HEALTHY, null);
    }

    private void storeConnectorInitStatus() throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(this.getConnectorId(), ProjectConnectorStatus.EConnectorStatus.INIT, "Analysis not finished.");
    }

    private void storeConnectorWarningStatus(String connectionIdentifier, String warningMessage) throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(connectionIdentifier, ProjectConnectorStatus.EConnectorStatus.WARNING, warningMessage);
    }

    public static final class WorkItemUpdateResult {
        private final WorkItemChangeCache cache;

        private WorkItemUpdateResult(WorkItemChangeCache cache) {
            this.cache = cache;
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> getChanges() throws StorageException {
            return this.cache.getChanges();
        }

        public static final class Builder<T extends TeamscaleIssue> {
            private final WorkItemChangeCache cache;

            private Builder(WorkItemChangeCache cache) {
                this.cache = cache;
            }

            public Builder<T> addDeletions(Collection<TeamscaleIssueId> deletedIds, long deletionTimestamp) throws StorageException {
                List<WorkItemDeletion> deletions = deletedIds.stream().map(id -> new WorkItemDeletion((TeamscaleIssueId)id, deletionTimestamp)).toList();
                this.cache.addChanges(Map.of(deletionTimestamp, deletions));
                return this;
            }

            public Builder<T> addDeletions(Map<TeamscaleIssueId, Long> deletedWithTimestamp) throws StorageException {
                HashMap deletionsByTimestamp = new HashMap();
                deletedWithTimestamp.forEach((id, timestamp) -> deletionsByTimestamp.computeIfAbsent(timestamp, ignored -> new ArrayList()).add(new WorkItemDeletion((TeamscaleIssueId)id, (long)timestamp)));
                this.cache.addChanges(deletionsByTimestamp);
                return this;
            }

            public Builder<T> addItem(T item) throws StorageException {
                return this.addItems(List.of(item));
            }

            public Builder<T> addItems(Collection<? extends T> items) throws StorageException {
                Map<Long, List<WorkItemUpdate>> changesByTimestamp = items.stream().map(WorkItemUpdate::new).collect(Collectors.groupingBy(update -> update.getUpdatedItem().getUpdated()));
                this.cache.addChanges(changesByTimestamp);
                return this;
            }

            public Builder<T> addItemsWithAuthor(PairList<? extends T, String> itemsWithAuthor) throws StorageException {
                Map<Long, List<WorkItemUpdate>> changesByTimestamp = itemsWithAuthor.stream().map(item -> new WorkItemUpdate((TeamscaleIssue)item.getFirst(), (String)item.getSecond())).collect(Collectors.groupingBy(update -> update.getUpdatedItem().getUpdated()));
                this.cache.addChanges(changesByTimestamp);
                return this;
            }

            public Builder<T> addItems(PairList<Long, ? extends T> itemsWithTimestamp) throws StorageException {
                Map changesByTimestamp = itemsWithTimestamp.groupedByFirst(Collectors.mapping(WorkItemUpdate::new, Collectors.toList()));
                this.cache.addChanges(changesByTimestamp);
                return this;
            }

            public Builder<T> addItemsWithTimestampAndAuthor(PairList<Long, ? extends Pair<? extends T, String>> itemsWithTimestampAndAuthor) throws StorageException {
                Map changesByTimestamp = itemsWithTimestampAndAuthor.groupedByFirst(Collectors.mapping(itemAndAuthor -> new WorkItemUpdate((TeamscaleIssue)itemAndAuthor.getFirst(), (String)itemAndAuthor.getSecond()), Collectors.toList()));
                this.cache.addChanges(changesByTimestamp);
                return this;
            }

            Builder<T> addChanges(long timestamp, Collection<WorkItemChange> changes) throws StorageException {
                this.cache.addChanges(Map.of(timestamp, changes));
                return this;
            }

            public WorkItemUpdateResult build() {
                this.cache.freeze();
                return new WorkItemUpdateResult(this.cache);
            }
        }
    }
}

