/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.utils.TeamscaleIssueIdDeserializer;
import com.teamscale.index.utils.TeamscaleIssueIdSerializer;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.UniformPathToValueIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviationList;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="issues-paths", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={byte[].class})
public class PathIssueIndex
implements IProjectIndex,
IDeltaTranslatingIndex<Delta> {
    public static final String INDEX_NAME = "issues-paths";
    private static final String ISSUE_TO_PATH_MAPPING_PREFIX = "#0#";
    private static final String PATH_TO_ISSUE_MAPPING_PREFIX = "#1#";
    private final ValueIndex<List<UniformPath>> issueToPathDelegate;
    private final UniformPathToValueIndex<List<TeamscaleIssueId>> pathToIssueDelegate;

    public PathIssueIndex(IStore store) {
        if (!(store instanceof StoreWithAbbreviationSupport)) {
            throw new IllegalArgumentException("Provided store '%s' does not have string abbreviation support".formatted(store));
        }
        StoreWithAbbreviationSupport abbreviatedStore = (StoreWithAbbreviationSupport)store;
        IStorageAbbreviator abbreviator = abbreviatedStore.getStringAbbreviator().getDelegate();
        ISerializer uniformPathListSerializer = ISerializer.of(UniformPathCompatibilityUtil::asUniformPathStrings, UniformPathCompatibilityUtil::convertCollection).andThen(ISerializer.of(paths -> abbreviator.abbreviateAll((Collection)paths).toByteArray(), value -> abbreviator.unabbreviateAll((Collection)StorageAbbreviationList.of((byte[])value))));
        this.issueToPathDelegate = ValueIndex.of((IStore)new DelegatingPartitionStore(store, ISSUE_TO_PATH_MAPPING_PREFIX), (ISerializer)uniformPathListSerializer);
        this.pathToIssueDelegate = UniformPathToValueIndex.of((IStore)new DelegatingPartitionStore(store, PATH_TO_ISSUE_MAPPING_PREFIX), (UniformPathSerializer)UniformPathSerializer.select((IStore)store, (boolean)false, (boolean)false), (ISerializer)new IssueIdSerializerWithAbbreviation(abbreviatedStore.getStringAbbreviator()));
    }

    public void updateMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        this.updateIssueToPathsMappings(addedPaths, editedAndDeletedPaths, movedPaths);
        this.updatePathToIssuesMappings(addedPaths, editedAndDeletedPaths, movedPaths);
    }

    public void updatePathToIssuesMappings(Map<UniformPath, @NonNull List<TeamscaleIssueId>> updatedPathToIssuesMapping) throws StorageException {
        Map<UniformPath, @NonNull List<TeamscaleIssueId>> existingPathToIssuesMapping = this.getPathToIssuesMapping(updatedPathToIssuesMapping.keySet());
        HashMap<UniformPath, @NonNull HashSet<TeamscaleIssueId>> updatedAffectedIssuesByPath = new HashMap<UniformPath, HashSet<TeamscaleIssueId>>();
        for (Map.Entry<UniformPath, List<TeamscaleIssueId>> affectedIssuesForPath : updatedPathToIssuesMapping.entrySet()) {
            UniformPath uniformPath = affectedIssuesForPath.getKey();
            HashSet affectedIssues = new HashSet(affectedIssuesForPath.getValue());
            if (existingPathToIssuesMapping.containsKey(uniformPath)) {
                affectedIssues.addAll(existingPathToIssuesMapping.get(uniformPath));
            }
            updatedAffectedIssuesByPath.put(uniformPath, affectedIssues);
        }
        this.storePathToIssuesMapping(updatedAffectedIssuesByPath);
    }

    public void updateIssueToPathsMappings(Map<TeamscaleIssueId, @NonNull List<UniformPath>> updatedIssueToPathsMapping) throws StorageException {
        Map<TeamscaleIssueId, @NonNull List<UniformPath>> existingIssueToPathsMapping = this.getIssueToPathsMapping(updatedIssueToPathsMapping.keySet());
        HashMap<TeamscaleIssueId, @NonNull HashSet<UniformPath>> updatedPathsByIssue = new HashMap<TeamscaleIssueId, HashSet<UniformPath>>();
        for (Map.Entry<TeamscaleIssueId, List<UniformPath>> affectedPathsForIssue : updatedIssueToPathsMapping.entrySet()) {
            TeamscaleIssueId issueId = affectedPathsForIssue.getKey();
            List<UniformPath> updatedAffectedPaths = affectedPathsForIssue.getValue();
            HashSet<UniformPath> mergedAffectedPaths = new HashSet<UniformPath>(updatedAffectedPaths);
            if (existingIssueToPathsMapping.containsKey(issueId)) {
                mergedAffectedPaths.addAll((Collection<UniformPath>)existingIssueToPathsMapping.get(issueId));
            }
            updatedPathsByIssue.put(issueId, mergedAffectedPaths);
        }
        this.storeIssueToPathsMapping(updatedPathsByIssue);
    }

    public Map<UniformPath, @NonNull List<TeamscaleIssueId>> getPathToIssuesMapping(Collection<UniformPath> uniformPaths) throws StorageException {
        return this.pathToIssueDelegate.getExistingValues(uniformPaths);
    }

    public Map<TeamscaleIssueId, @NonNull List<UniformPath>> getIssueToPathsMappingsForUniformPaths(Collection<UniformPath> uniformPaths) throws StorageException {
        Map<UniformPath, @NonNull List<TeamscaleIssueId>> pathToIssuesMapping = this.getPathToIssuesMapping(uniformPaths);
        Set<TeamscaleIssueId> issueIds = pathToIssuesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return this.getIssueToPathsMapping(issueIds);
    }

    public SetMap<UniformPath, TeamscaleIssueId> getPathToIssueMappingForAffectedIssues(Set<UniformPath> uniformPaths, Collection<TeamscaleIssueId> issueIds) throws StorageException {
        Map<UniformPath, @NonNull List<TeamscaleIssueId>> allAffectedIssuesByPath = this.getPathToIssuesMapping(uniformPaths);
        SetMap affectedIssuesByPath = new SetMap();
        for (Map.Entry<UniformPath, List<TeamscaleIssueId>> allAffectedIssuesByPathEntry : allAffectedIssuesByPath.entrySet()) {
            UniformPath uniformPath = allAffectedIssuesByPathEntry.getKey();
            HashSet allAffectedIssueIds = new HashSet(allAffectedIssuesByPathEntry.getValue());
            for (TeamscaleIssueId affectedIssueId : issueIds) {
                if (!allAffectedIssueIds.contains(affectedIssueId)) continue;
                affectedIssuesByPath.add((Object)uniformPath, (Object)affectedIssueId);
            }
        }
        return affectedIssuesByPath;
    }

    public @Nullable List<UniformPath> getReferencedPaths(TeamscaleIssueId issueId) throws StorageException {
        return (List)this.issueToPathDelegate.getValue(issueId.toString());
    }

    public @NonNull Delta resolveDelta(KeyDelta delta) throws StorageException {
        if (!delta.getDeletedKeys().isEmpty()) {
            throw new IllegalStateException("Expected delta without deleted entries");
        }
        HashSet<UniformPath> changedPaths = new HashSet<UniformPath>();
        HashSet<TeamscaleIssueId> changedIssues = new HashSet<TeamscaleIssueId>();
        for (StorageKey addedOrChangedKey : delta.getAddedOrChangedKeys()) {
            DelegatingPartitionStore pathToIssueStore;
            DelegatingPartitionStore issueToPathStore;
            byte[] key = addedOrChangedKey.getKey();
            IStore iStore = this.issueToPathDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (issueToPathStore = (DelegatingPartitionStore)iStore).isFromThisPartition(key)) {
                changedIssues.add(TeamscaleIssueId.fromInternalId((String)StringUtils.bytesToString((byte[])issueToPathStore.getOriginalKey(key))));
                continue;
            }
            iStore = this.pathToIssueDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (pathToIssueStore = (DelegatingPartitionStore)iStore).isFromThisPartition(key)) {
                changedPaths.add((UniformPath)this.pathToIssueDelegate.getKeySerializer().deserialize((Object)pathToIssueStore.getOriginalKey(key)));
                continue;
            }
            throw new IllegalArgumentException("Unexpected key: " + String.valueOf(addedOrChangedKey));
        }
        return new Delta(changedPaths, changedIssues);
    }

    private void updateIssueToPathsMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        UnmodifiableMap<UniformPath, @NonNull List<TeamscaleIssueId>> pathsToIssuesMappingsForMovesAndDeletes = this.getStoredPathToIssuesMappingForMoves(movedPaths.stream().map(movedPath -> movedPath.oldPath).collect(Collectors.toSet()));
        Map<TeamscaleIssueId, @NonNull HashSet<UniformPath>> issueToPathsMappings = this.preloadExistingIssueToPathsMappings(addedPaths, editedAndDeletedPaths, movedPaths, pathsToIssuesMappingsForMovesAndDeletes);
        PathIssueIndex.processAddedEditedDeletedPathsForIssueToPathsMappings(issueToPathsMappings, addedPaths, editedAndDeletedPaths);
        PathIssueIndex.processMovedPathsForIssueToPathsMappings(movedPaths, pathsToIssuesMappingsForMovesAndDeletes, issueToPathsMappings);
        this.storeIssueToPathsMapping(issueToPathsMappings);
    }

    private UnmodifiableMap<UniformPath, @NonNull List<TeamscaleIssueId>> getStoredPathToIssuesMappingForMoves(Set<UniformPath> deletedPaths) throws StorageException {
        return CollectionUtils.asUnmodifiable(this.getPathToIssuesMapping(deletedPaths));
    }

    private Map<TeamscaleIssueId, @NonNull HashSet<UniformPath>> preloadExistingIssueToPathsMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths, UnmodifiableMap<UniformPath, @NonNull List<TeamscaleIssueId>> pathToIssuesMappingsForMovesAndDeletes) throws StorageException {
        Stream newlyAddedIssueIdsFromAddedPaths = addedPaths.stream().flatMap(editedPath -> editedPath.referencedIssues.stream());
        Stream newlyAddedIssueIdsFromEditedPaths = editedAndDeletedPaths.stream().flatMap(editedPath -> editedPath.referencedIssues.stream());
        Stream newlyAddedIssueIdsFromMovedPaths = movedPaths.stream().filter(movedPath -> movedPath.addedIssues != null).flatMap(movedPath -> movedPath.addedIssues.stream());
        Stream issueIdsReferencedByOldAndDeletedPaths = pathToIssuesMappingsForMovesAndDeletes.values().stream().flatMap(Collection::stream);
        Set<TeamscaleIssueId> issueIdsReferencedByEditedAndMovedPaths = Stream.of(newlyAddedIssueIdsFromAddedPaths, newlyAddedIssueIdsFromEditedPaths, newlyAddedIssueIdsFromMovedPaths, issueIdsReferencedByOldAndDeletedPaths).flatMap(Function.identity()).collect(Collectors.toSet());
        Map<TeamscaleIssueId, @NonNull List<UniformPath>> storedIssueToPathsMappings = this.getIssueToPathsMapping(issueIdsReferencedByEditedAndMovedPaths);
        HashMap<TeamscaleIssueId, @NonNull HashSet<UniformPath>> issueToPaths = new HashMap<TeamscaleIssueId, HashSet<UniformPath>>();
        storedIssueToPathsMappings.forEach((issueId, paths) -> issueToPaths.put((TeamscaleIssueId)issueId, new HashSet(paths)));
        return issueToPaths;
    }

    private static void processAddedEditedDeletedPathsForIssueToPathsMappings(Map<TeamscaleIssueId, @NonNull HashSet<UniformPath>> issueToPathsMappings, List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths) {
        ArrayList<PathToIssuesMapping> addedAndEditedPaths = new ArrayList<PathToIssuesMapping>(addedPaths);
        addedAndEditedPaths.addAll(editedAndDeletedPaths);
        for (PathToIssuesMapping pathToIssuesMapping : addedAndEditedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(pathToIssuesMapping);
            for (TeamscaleIssueId addedIssueId : pathToIssuesMapping.referencedIssues) {
                if (!issueToPathsMappings.containsKey(addedIssueId)) {
                    issueToPathsMappings.put(addedIssueId, new HashSet());
                }
                issueToPathsMappings.get(addedIssueId).add(pathToIssuesMapping.uniformPath);
            }
        }
    }

    private static void processMovedPathsForIssueToPathsMappings(List<PathMove> movedPaths, UnmodifiableMap<UniformPath, @NonNull List<TeamscaleIssueId>> pathsToIssuesMappingsForMovesAndDeletes, Map<TeamscaleIssueId, @NonNull HashSet<UniformPath>> issueToPathsMappings) {
        for (PathMove movedPath : movedPaths) {
            HashSet<TeamscaleIssueId> affectedIssueIds = new HashSet<TeamscaleIssueId>();
            List affectedIssueIdsFromExistingPathToIssueMappings = (List)pathsToIssuesMappingsForMovesAndDeletes.get((Object)movedPath.oldPath);
            if (affectedIssueIdsFromExistingPathToIssueMappings != null) {
                affectedIssueIds.addAll(affectedIssueIdsFromExistingPathToIssueMappings);
            }
            if (movedPath.addedIssues != null) {
                affectedIssueIds.addAll(movedPath.addedIssues);
            }
            if (affectedIssueIds.isEmpty()) continue;
            for (TeamscaleIssueId affectedIssueId : affectedIssueIds) {
                HashSet<UniformPath> updatedPaths = new HashSet<UniformPath>();
                updatedPaths.add(movedPath.newPath);
                if (issueToPathsMappings.containsKey(affectedIssueId)) {
                    updatedPaths.addAll((Collection)issueToPathsMappings.get(affectedIssueId));
                }
                issueToPathsMappings.put(affectedIssueId, updatedPaths);
            }
        }
    }

    private void updatePathToIssuesMappings(List<PathToIssuesMapping> addedPaths, List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        HashMap<UniformPath, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping = new HashMap<UniformPath, HashSet<TeamscaleIssueId>>();
        PathIssueIndex.processAddedPathForPathToIssuesMapping(addedPaths, pathToIssuesMapping);
        Map<UniformPath, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings = this.preloadExistingPathToIssuesMapping(editedAndDeletedPaths, movedPaths);
        PathIssueIndex.processEditedAndDeletedPathsForPathToIssuesMapping(editedAndDeletedPaths, storedPathToIssueMappings, pathToIssuesMapping);
        PathIssueIndex.processMovedPathsForPathToIssuesMapping(movedPaths, storedPathToIssueMappings, pathToIssuesMapping);
        this.storePathToIssuesMapping(pathToIssuesMapping);
    }

    private static void processAddedPathForPathToIssuesMapping(List<PathToIssuesMapping> addedPaths, Map<UniformPath, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathToIssuesMapping pathAddition : addedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(pathAddition);
            pathToIssuesMapping.put(pathAddition.uniformPath, new HashSet<TeamscaleIssueId>(pathAddition.referencedIssues));
        }
    }

    private Map<UniformPath, @NonNull List<TeamscaleIssueId>> preloadExistingPathToIssuesMapping(List<PathToIssuesMapping> editedAndDeletedPaths, List<PathMove> movedPaths) throws StorageException {
        List<UniformPath> editedAndMovedPath = Stream.concat(editedAndDeletedPaths.stream().map(PathToIssuesMapping::uniformPath), movedPaths.stream().map(PathMove::oldPath)).toList();
        return this.getPathToIssuesMapping(editedAndMovedPath);
    }

    private static void processEditedAndDeletedPathsForPathToIssuesMapping(List<PathToIssuesMapping> editedAndDeletedPaths, Map<UniformPath, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings, Map<UniformPath, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathToIssuesMapping editedPath : editedAndDeletedPaths) {
            PathIssueIndex.assertAffectedIssuesNotEmpty(editedPath);
            HashSet oldAndNewIssueIds = CollectionUtils.unionSet((Collection)storedPathToIssueMappings.get(editedPath.uniformPath), (Collection[])new Collection[]{editedPath.referencedIssues});
            pathToIssuesMapping.put(editedPath.uniformPath, oldAndNewIssueIds);
        }
    }

    private static void processMovedPathsForPathToIssuesMapping(List<PathMove> movedPaths, Map<UniformPath, @NonNull List<TeamscaleIssueId>> storedPathToIssueMappings, Map<UniformPath, @NonNull HashSet<TeamscaleIssueId>> pathToIssuesMapping) {
        for (PathMove movedPath : movedPaths) {
            HashSet<TeamscaleIssueId> referencedIssueIds = new HashSet<TeamscaleIssueId>();
            if (storedPathToIssueMappings.containsKey(movedPath.oldPath)) {
                referencedIssueIds.addAll((Collection)storedPathToIssueMappings.get(movedPath.oldPath));
            }
            if (movedPath.addedIssues != null) {
                referencedIssueIds.addAll(movedPath.addedIssues);
            }
            pathToIssuesMapping.put(movedPath.newPath, referencedIssueIds);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Map<TeamscaleIssueId, @NonNull List<UniformPath>> getIssueToPathsMapping(Collection<TeamscaleIssueId> issueIds) throws StorageException {
        @NonNull Map pathsByStringIssues = this.issueToPathDelegate.getValuesByKeys(issueIds.stream().map(TeamscaleIssueId::toString).toList());
        HashMap<TeamscaleIssueId, @NonNull List<UniformPath>> pathByIssues = new HashMap<TeamscaleIssueId, List<UniformPath>>();
        for (Map.Entry pathByStringIssue : pathsByStringIssues.entrySet()) {
            pathByIssues.put(TeamscaleIssueId.fromInternalId((String)((String)pathByStringIssue.getKey())), (List)pathByStringIssue.getValue());
        }
        return pathByIssues;
    }

    private static void assertAffectedIssuesNotEmpty(PathToIssuesMapping uniformPath) {
        CCSMAssert.isNotEmpty(uniformPath.referencedIssues, (String)"expected at least one affected issue, but the affected issues of the added path '%s' where empty.".formatted(uniformPath.uniformPath));
    }

    private void storePathToIssuesMapping(Map<UniformPath, @NonNull HashSet<TeamscaleIssueId>> affectedIssuesByPath) throws StorageException {
        PairList mappingToStore = new PairList();
        for (Map.Entry<UniformPath, HashSet<TeamscaleIssueId>> affectedIssueByPath : affectedIssuesByPath.entrySet()) {
            mappingToStore.add((Object)affectedIssueByPath.getKey(), affectedIssueByPath.getValue().stream().toList());
        }
        this.pathToIssueDelegate.setValues(mappingToStore);
    }

    private void storeIssueToPathsMapping(Map<TeamscaleIssueId, @NonNull HashSet<UniformPath>> affectedPathsByIssue) throws StorageException {
        PairList mappingToStore = new PairList();
        for (Map.Entry<TeamscaleIssueId, HashSet<UniformPath>> affectedPathByIssue : affectedPathsByIssue.entrySet()) {
            mappingToStore.add((Object)affectedPathByIssue.getKey().toString(), affectedPathByIssue.getValue().stream().toList());
        }
        this.issueToPathDelegate.setValues(mappingToStore);
    }

    private record IssueIdSerializerWithAbbreviation(StorageStringAbbreviator stringAbbreviator) implements ISerializer<List<TeamscaleIssueId>, byte[]>
    {
        public byte @NonNull [] serialize(@NonNull List<TeamscaleIssueId> issueIds) throws StorageException {
            TeamscaleIssueIdSerializer issueIdSerializer = new TeamscaleIssueIdSerializer(this.stringAbbreviator, issueIds);
            ByteArrayOutputStream serializedIssueIds = new ByteArrayOutputStream();
            for (TeamscaleIssueId issueId : issueIds) {
                serializedIssueIds.writeBytes(issueIdSerializer.serialize(issueId));
            }
            return serializedIssueIds.toByteArray();
        }

        public @NonNull List<TeamscaleIssueId> deserialize(byte @NonNull [] serializedIssueIds) throws StorageException {
            int offset;
            TeamscaleIssueIdDeserializer issueIdDeserializer = new TeamscaleIssueIdDeserializer(this.stringAbbreviator);
            for (offset = 0; offset < serializedIssueIds.length; offset += TeamscaleIssueIdDeserializer.getEntryLength(serializedIssueIds, offset)) {
                issueIdDeserializer.extractStringIdsToLoadIntoUnAbbreviationMap(serializedIssueIds, offset);
            }
            ArrayList<TeamscaleIssueId> deserializedIssueIds = new ArrayList<TeamscaleIssueId>();
            for (offset = 0; offset < serializedIssueIds.length; offset += TeamscaleIssueIdDeserializer.getEntryLength(serializedIssueIds, offset)) {
                TeamscaleIssueId issueId = (TeamscaleIssueId)issueIdDeserializer.deserialize(serializedIssueIds, offset);
                deserializedIssueIds.add(issueId);
            }
            return deserializedIssueIds;
        }
    }

    @IndexValueClass
    public record Delta(Set<UniformPath> changedPaths, Set<TeamscaleIssueId> changedIssues) implements IIndexDelta
    {
        public static Delta empty() {
            return new Delta(Collections.emptySet(), Collections.emptySet());
        }

        public int size() {
            return this.changedPaths.size() + this.changedIssues.size();
        }

        public List<? extends IIndexDelta> split(int maxDeltaSize) {
            UnmodifiableIterator iter;
            if (this.size() < maxDeltaSize) {
                return List.of(this);
            }
            ArrayList<Delta> result = new ArrayList<Delta>();
            if (!this.changedPaths.isEmpty()) {
                iter = Iterators.partition(this.changedPaths.iterator(), (int)maxDeltaSize);
                while (iter.hasNext()) {
                    result.add(new Delta(new HashSet<UniformPath>((Collection)iter.next()), Collections.emptySet()));
                }
            }
            if (!this.changedIssues.isEmpty()) {
                iter = Iterators.partition(this.changedIssues.iterator(), (int)maxDeltaSize);
                while (iter.hasNext()) {
                    result.add(new Delta(Collections.emptySet(), new HashSet<TeamscaleIssueId>((Collection)iter.next())));
                }
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IIndexDelta combine(IIndexDelta delta) {
            Set<UniformPath> paths;
            Set<UniformPath> set;
            if (!(delta instanceof Delta)) throw new IllegalArgumentException("Unexpected delta type: " + String.valueOf(delta.getClass()));
            Delta delta2 = (Delta)delta;
            try {
                paths = set = delta2.changedPaths();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Set<UniformPath> issues = set = delta2.changedIssues();
            HashSet<UniformPath> changedPaths = new HashSet<UniformPath>(this.changedPaths);
            HashSet<TeamscaleIssueId> changedIssues = new HashSet<TeamscaleIssueId>(this.changedIssues);
            changedPaths.addAll(paths);
            changedIssues.addAll(issues);
            return new Delta(changedPaths, changedIssues);
        }

        public IndexDelta<String> asLogDelta() {
            return new IndexDelta(Stream.concat(this.changedPaths.stream().map(UniformPath::toString), this.changedIssues.stream().map(TeamscaleIssueId::getInternalId)).toList(), Collections.emptyList());
        }
    }

    public record PathToIssuesMapping(UniformPath uniformPath, @NonNull List<TeamscaleIssueId> referencedIssues) {
    }

    public record PathMove(UniformPath oldPath, UniformPath newPath, @Nullable List<TeamscaleIssueId> addedIssues) {
    }
}

