/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class PathIssueSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=ElementHistoryIndex.class)
    private KeyDelta elementHistoryDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex elementHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PathIssueIndex pathIssueIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<PathIssueIndex> parentIssuesPathIndices;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    RepositoryCommitIssueMappingIndex repositoryCommitIssueMappingIndex;

    public void execute() throws ConQATException {
        List<TeamscaleIssueId> issueIds = this.getIssueIdsForSchedulingCommit();
        this.updatePathIssueMappings(issueIds);
    }

    private List<TeamscaleIssueId> getIssueIdsForSchedulingCommit() throws StorageException {
        if (this.isMergeCommit()) {
            return Collections.emptyList();
        }
        List<TeamscaleIssueId> issuesForCommit = this.repositoryCommitIssueMappingIndex.getIssuesForCommit(this.getSchedulingCommit());
        if (issuesForCommit == null) {
            return Collections.emptyList();
        }
        return issuesForCommit;
    }

    private boolean isMergeCommit() {
        return this.getParentedSchedulingCommit().isMergeCommit();
    }

    private void updatePathIssueMappings(@Nullable List<TeamscaleIssueId> issuesReferencedInSchedulingCommit) throws StorageException {
        List<UniformPath> codeUniformPaths = this.getAffectedCodePaths();
        if (this.isMergeCommit()) {
            this.copyMappingsToMergeTarget(codeUniformPaths);
        }
        if (codeUniformPaths.isEmpty()) {
            return;
        }
        Map<UniformPath, ElementHistoryEntry> historyEntriesByPaths = this.elementHistoryIndex.getHistoryEntriesByUniformPaths(codeUniformPaths);
        ArrayList<TeamscaleIssueId> issueIds = null;
        if (issuesReferencedInSchedulingCommit != null && !issuesReferencedInSchedulingCommit.isEmpty()) {
            issueIds = new ArrayList<TeamscaleIssueId>(issuesReferencedInSchedulingCommit);
        }
        ArrayList<PathIssueIndex.PathToIssuesMapping> addedPaths = new ArrayList<PathIssueIndex.PathToIssuesMapping>();
        ArrayList<PathIssueIndex.PathToIssuesMapping> updatedAndDeletedPaths = new ArrayList<PathIssueIndex.PathToIssuesMapping>();
        ArrayList<PathIssueIndex.PathMove> movedPaths = new ArrayList<PathIssueIndex.PathMove>();
        for (UniformPath uniformPath : codeUniformPaths) {
            PathIssueSynchronizer.computePathUpdatesAndDeletes(uniformPath, historyEntriesByPaths, issueIds, addedPaths, updatedAndDeletedPaths, movedPaths);
        }
        this.pathIssueIndex.updateMappings(addedPaths, updatedAndDeletedPaths, movedPaths);
    }

    private List<UniformPath> getAffectedCodePaths() {
        return this.elementHistoryDelta.getAllKeysAsStrings().stream().map(UniformPathCompatibilityUtil::convert).filter(UniformPath::isCodePath).toList();
    }

    private static void computePathUpdatesAndDeletes(UniformPath uniformPath, Map<UniformPath, ElementHistoryEntry> historyEntriesByPaths, @Nullable List<TeamscaleIssueId> issueIds, List<PathIssueIndex.PathToIssuesMapping> addedPaths, List<PathIssueIndex.PathToIssuesMapping> updatedAndDeletedPaths, List<PathIssueIndex.PathMove> movedPaths) {
        ElementHistoryEntry historyEntry = historyEntriesByPaths.get(uniformPath);
        EElementHistoryChangeType changeType = historyEntry.getChangeType();
        switch (changeType) {
            case ADD: 
            case COPY: {
                if (issueIds == null) break;
                addedPaths.add(new PathIssueIndex.PathToIssuesMapping(uniformPath, issueIds));
                break;
            }
            case EDIT: 
            case DELETE: {
                if (issueIds == null) break;
                updatedAndDeletedPaths.add(new PathIssueIndex.PathToIssuesMapping(uniformPath, issueIds));
                break;
            }
            case MOVE: {
                String originPath = historyEntry.getOriginPath();
                if (originPath == null) {
                    LOGGER.error("Expected an origin path for uniform path {} for history entry with EElementHistoryChangeType.MOVE, but was null.", (Object)uniformPath);
                    return;
                }
                movedPaths.add(new PathIssueIndex.PathMove(UniformPathCompatibilityUtil.convert((String)originPath), uniformPath, issueIds));
                break;
            }
        }
    }

    private void copyMappingsToMergeTarget(List<UniformPath> uniformPaths) throws StorageException {
        for (int i = 1; i < this.parentIssuesPathIndices.size(); ++i) {
            PathIssueIndex affectedIssueByPathIndexSourceBranch = this.parentIssuesPathIndices.get(i);
            Map<UniformPath, @NonNull List<TeamscaleIssueId>> sourceBranchIssuesByPath = affectedIssueByPathIndexSourceBranch.getPathToIssuesMapping(uniformPaths);
            this.pathIssueIndex.updatePathToIssuesMappings(sourceBranchIssuesByPath);
            Map<TeamscaleIssueId, @NonNull List<UniformPath>> sourceBranchPathsByIssue = affectedIssueByPathIndexSourceBranch.getIssueToPathsMappingsForUniformPaths(uniformPaths);
            this.pathIssueIndex.updateIssueToPathsMappings(sourceBranchPathsByIssue);
        }
    }
}

