/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.requirements_tracing.index.WorkItemChange;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

class WorkItemChangeAggregationGrouper {
    public static final String ENABLED_PARAMETER = "enabled";
    public static final String MAXIMUM_AGGREGATION_SPAN_PARAMETER = "maximumAggregationSpan";
    public static final String MAXIMUM_SESSION_LENGTH_PARAMETER = "maximumSessionLength";
    @StepParameter(value="enabled", optional=true)
    private boolean enabled;
    @StepParameter(value="maximumAggregationSpan", optional=true)
    private int maximumAggregationSpan;
    @StepParameter(value="maximumSessionLength", optional=true)
    private int maximumSessionLength;

    public WorkItemChangeAggregationGrouper() {
        this(false, 0, 0);
    }

    @VisibleForTesting
    public WorkItemChangeAggregationGrouper(boolean enabled, int maximumAggregationSpan, int maximumSessionLength) {
        this.enabled = enabled;
        this.maximumAggregationSpan = maximumAggregationSpan;
        this.maximumSessionLength = maximumSessionLength;
    }

    public NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> performAggregation(NavigableMap<Long, SupplierWithException<List<WorkItemChange>, StorageException>> changes, IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<?> resultBuilder) throws StorageException {
        if (!this.enabled) {
            return changes;
        }
        HashMap<String, ChangeSession> openSessionsByAuthor = new HashMap<String, ChangeSession>();
        HashMap<TeamscaleIssueId, String> owningAuthor = new HashMap<TeamscaleIssueId, String>();
        for (Map.Entry changeEntry : changes.entrySet()) {
            Instant changeTimestamp = Instant.ofEpochMilli((Long)changeEntry.getKey());
            for (WorkItemChange change : (List)((SupplierWithException)changeEntry.getValue()).get()) {
                String previousAuthor;
                String author = change.getAuthor().orElse("");
                ChangeSession currentSession = openSessionsByAuthor.computeIfAbsent(author, ignored -> new ChangeSession(this, author, changeTimestamp));
                if (!currentSession.isStillActive(changeTimestamp)) {
                    currentSession.commit(resultBuilder, owningAuthor);
                    currentSession = new ChangeSession(this, author, changeTimestamp);
                    openSessionsByAuthor.put(author, currentSession);
                }
                if ((previousAuthor = owningAuthor.put(change.getWorkItemId(), author)) != null && !Objects.equals(previousAuthor, author)) {
                    ChangeSession openSession = (ChangeSession)openSessionsByAuthor.remove(previousAuthor);
                    openSession.commit(resultBuilder, owningAuthor);
                }
                currentSession.addChange(changeTimestamp, change);
            }
        }
        for (ChangeSession openSession : openSessionsByAuthor.values()) {
            openSession.commit(resultBuilder, owningAuthor);
        }
        return resultBuilder.build().getChanges();
    }

    private class ChangeSession {
        private final String author;
        private final Instant startTimestamp;
        private final Map<TeamscaleIssueId, WorkItemChange> openChanges;
        private Instant lastChangeTimestamp;
        final /* synthetic */ WorkItemChangeAggregationGrouper this$0;

        private ChangeSession(WorkItemChangeAggregationGrouper workItemChangeAggregationGrouper, String author, Instant startTimestamp) {
            WorkItemChangeAggregationGrouper workItemChangeAggregationGrouper2 = workItemChangeAggregationGrouper;
            Objects.requireNonNull(workItemChangeAggregationGrouper2);
            this.this$0 = workItemChangeAggregationGrouper2;
            this.openChanges = new LinkedHashMap<TeamscaleIssueId, WorkItemChange>();
            this.author = author;
            this.startTimestamp = startTimestamp;
            this.lastChangeTimestamp = startTimestamp;
        }

        public boolean isStillActive(Instant timestamp) {
            return !StringUtils.isEmpty((String)this.author) && Duration.between(this.lastChangeTimestamp, timestamp).toSeconds() <= (long)this.this$0.maximumAggregationSpan && Duration.between(this.startTimestamp, timestamp).toSeconds() <= (long)this.this$0.maximumSessionLength;
        }

        public void addChange(Instant changeTimestamp, WorkItemChange change) {
            this.openChanges.put(change.getWorkItemId(), change);
            this.lastChangeTimestamp = changeTimestamp;
        }

        public void commit(IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<?> resultBuilder, Map<TeamscaleIssueId, String> owningAuthor) throws StorageException {
            resultBuilder.addChanges(this.lastChangeTimestamp.toEpochMilli(), this.openChanges.values());
            for (TeamscaleIssueId ownedIssue : this.openChanges.keySet()) {
                owningAuthor.remove(ownedIssue, this.author);
            }
            this.openChanges.clear();
        }
    }
}

