/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.index.issues.IIssueHistoryIndex;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueUnmanagedKeysHistoryIndex;
import com.teamscale.index.issues.WorkItemUnmanagedKeysHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemUnmanagedKeysHistoryIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class WorkItemHistoryIndexAggregation<T extends TeamscaleIssue>
implements IKeyedObjectIndex<T> {
    private final IIssueHistoryIndex<T> workItemHistoryIndex;
    private final WorkItemUnmanagedKeysHistoryIndex<T, ?> workItemUnmanagedKeysHistoryIndex;
    private final long timestamp;
    private final Set<String> unmanagedKeys = new HashSet<String>();

    @VisibleForTesting
    WorkItemHistoryIndexAggregation(IIssueHistoryIndex<T> workItemHistoryIndex, WorkItemUnmanagedKeysHistoryIndex<T, ?> workItemUnmanagedKeysHistoryIndex, long timestamp) {
        this.workItemHistoryIndex = workItemHistoryIndex;
        this.workItemUnmanagedKeysHistoryIndex = workItemUnmanagedKeysHistoryIndex;
        this.timestamp = timestamp;
        this.unmanagedKeys.addAll(workItemHistoryIndex.getDescriber().getUnmanagedKeys());
    }

    public static WorkItemHistoryIndexAggregation<SpecItem> forSpecItems(ProjectStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forSpecItems(projectStorageSystem, HistoryAccessOption.readCommit((CommitDescriptor)commit));
    }

    public static WorkItemHistoryIndexAggregation<SpecItem> forSpecItems(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        return WorkItemHistoryIndexAggregation.of(projectStorageSystem, SpecItemHistoryIndex.class, SpecItemUnmanagedKeysHistoryIndex.class, historyAccessOption);
    }

    public static WorkItemHistoryIndexAggregation<TeamscaleIssue> forIssues(ProjectStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forIssues(projectStorageSystem, HistoryAccessOption.readCommit((CommitDescriptor)commit));
    }

    public static WorkItemHistoryIndexAggregation<TeamscaleIssue> forIssues(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        return WorkItemHistoryIndexAggregation.of(projectStorageSystem, IssueHistoryIndex.class, IssueUnmanagedKeysHistoryIndex.class, historyAccessOption);
    }

    private static <T extends TeamscaleIssue> WorkItemHistoryIndexAggregation<T> of(ProjectStorageSystem projectStorageSystem, Class<? extends IIssueHistoryIndex<T>> historyIndexType, Class<? extends WorkItemUnmanagedKeysHistoryIndex<T, ?>> unmanagedKeysHistoryIndexType, HistoryAccessOption historyAccessOption) throws StorageException {
        IIssueHistoryIndex historyIndex = (IIssueHistoryIndex)projectStorageSystem.openProjectIndex(historyIndexType, null);
        WorkItemUnmanagedKeysHistoryIndex unmanagedKeysHistoryIndex = (WorkItemUnmanagedKeysHistoryIndex)projectStorageSystem.openProjectIndex(unmanagedKeysHistoryIndexType, historyAccessOption);
        return new WorkItemHistoryIndexAggregation<T>(historyIndex, unmanagedKeysHistoryIndex, historyAccessOption.getTimestampOrNow());
    }

    public IKeyedObjectDescriber<T> getDescriber() {
        return this.workItemHistoryIndex.getDescriber();
    }

    public List<T> getByIds(Collection<String> ids) throws StorageException {
        return this.augmentUnmanagedKeys(this.workItemHistoryIndex.getByIds(ids, this.timestamp));
    }

    public List<T> getByIssueIds(Collection<TeamscaleIssueId> ids) throws StorageException {
        return this.augmentUnmanagedKeys(this.workItemHistoryIndex.getByIssueIds(ids, this.timestamp));
    }

    public T getById(String id) throws StorageException {
        return (T)((TeamscaleIssue)this.augmentUnmanagedKeys(Collections.singletonList(this.workItemHistoryIndex.getById(id, this.timestamp))).getFirst());
    }

    public @Nullable T getById(TeamscaleIssueId id) throws StorageException {
        return this.getById(id.getInternalId());
    }

    private List<T> augmentUnmanagedKeys(List<T> items) throws StorageException {
        List<TeamscaleIssue> existingItems = items.stream().filter(Objects::nonNull).toList();
        List unmanagedKeyData = this.workItemUnmanagedKeysHistoryIndex.getByIds(existingItems.stream().map(TeamscaleIssue::getIdAsString).toList());
        CollectionUtils.forEach(existingItems, (Iterable)unmanagedKeyData, (item, data) -> {
            if (data == null) {
                for (String unmanagedKey : this.unmanagedKeys) {
                    item.setCustomField(unmanagedKey, this.workItemUnmanagedKeysHistoryIndex.getDefaultValue(unmanagedKey));
                }
            } else {
                data.values().forEach((arg_0, arg_1) -> ((TeamscaleIssue)item).setCustomField(arg_0, arg_1));
            }
        });
        return items;
    }

    public Set<String> getAllIds() throws StorageException {
        return new HashSet<String>(this.workItemHistoryIndex.getAllIds(this.timestamp));
    }

    public PairList<String, EKeyedObjectType> getKnownColumns() throws StorageException {
        PairList knownColumns = new PairList();
        this.unmanagedKeys.forEach(key -> knownColumns.add(key, (Object)this.getDescriber().getType(key)));
        knownColumns.addAll(this.workItemHistoryIndex.getKnownColumns());
        return knownColumns;
    }

    public EKeyedObjectType getColumnType(String columnName) throws StorageException {
        if (this.unmanagedKeys.contains(columnName)) {
            return this.workItemUnmanagedKeysHistoryIndex.getColumnType(columnName);
        }
        return this.workItemHistoryIndex.getColumnType(columnName);
    }

    public List<String> getKnownValues(String key) throws StorageException {
        if (this.unmanagedKeys.contains(key)) {
            return this.workItemUnmanagedKeysHistoryIndex.getKnownValues(key);
        }
        return this.workItemHistoryIndex.getKnownValues(key);
    }

    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns) throws StorageException {
        return this.query(valueColumns, exactValueColumns, this.timestamp);
    }

    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns, long timestamp) throws StorageException {
        ColumnExtractor columnExtractor = new ColumnExtractor(valueColumns, exactValueColumns, this.unmanagedKeys);
        if (columnExtractor.unmanagedKeysValuesColumns.isEmpty() && columnExtractor.unmanagedKeysExactValueColumns.isEmpty()) {
            return this.workItemHistoryIndex.query(valueColumns, exactValueColumns, timestamp);
        }
        Map<String, Long> allWorkItemIdsAndLastUpdatedTimestamps = this.workItemHistoryIndex.getAllIdsAndTimestamps(timestamp);
        if (columnExtractor.historyValueColumns.isEmpty() && columnExtractor.historyExactValueColumns.isEmpty()) {
            return this.workItemUnmanagedKeysHistoryIndex.query(valueColumns, exactValueColumns, timestamp, allWorkItemIdsAndLastUpdatedTimestamps);
        }
        List historyResults = this.workItemHistoryIndex.query(columnExtractor.historyValueColumns, columnExtractor.historyExactValueColumns, timestamp);
        List<TimedShallowObjectState> unmanagedKeysResults = this.workItemUnmanagedKeysHistoryIndex.query(columnExtractor.unmanagedKeysValuesColumns, columnExtractor.unmanagedKeysExactValueColumns, timestamp, allWorkItemIdsAndLastUpdatedTimestamps);
        Map<String, Integer> valueColumnToIndexMapping = WorkItemHistoryIndexAggregation.createColumnToIndexMapping(valueColumns, (List<String>)exactValueColumns.getFirstList());
        return WorkItemHistoryIndexAggregation.mergeResults(historyResults, unmanagedKeysResults, columnExtractor, valueColumnToIndexMapping);
    }

    private static List<TimedShallowObjectState> mergeResults(List<TimedShallowObjectState> historyResults, List<TimedShallowObjectState> unmanagedKeysResults, ColumnExtractor columnExtractor, Map<String, Integer> valueColumnToIndexMapping) {
        HashMap idToObjectState = new HashMap();
        Integer numberOfColumns = columnExtractor.historyValueColumns.size() + columnExtractor.historyExactValueColumns.size() + columnExtractor.unmanagedKeysValuesColumns.size() + columnExtractor.unmanagedKeysExactValueColumns.size();
        historyResults.forEach(result -> WorkItemHistoryIndexAggregation.updateValues(idToObjectState, result, valueColumnToIndexMapping, columnExtractor.historyValueColumns, columnExtractor.historyExactValueColumns, numberOfColumns));
        unmanagedKeysResults.forEach(result -> WorkItemHistoryIndexAggregation.updateValues(idToObjectState, result, valueColumnToIndexMapping, columnExtractor.unmanagedKeysValuesColumns, columnExtractor.unmanagedKeysExactValueColumns, numberOfColumns));
        return CollectionUtils.map(idToObjectState.entrySet(), Map.Entry::getValue);
    }

    private static Map<String, Integer> createColumnToIndexMapping(List<String> valueColumns, List<String> exactValueColumns) {
        int i;
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (i = 0; i < valueColumns.size(); ++i) {
            mapping.put(valueColumns.get(i), i);
        }
        for (i = 0; i < exactValueColumns.size(); ++i) {
            mapping.put(exactValueColumns.get(i), valueColumns.size() + i);
        }
        return mapping;
    }

    private static void updateValues(Map<String, TimedShallowObjectState> idToObjectState, TimedShallowObjectState objectState, Map<String, Integer> valueColumnToIndexMapping, List<String> valueColumns, PairList<String, String> exactValueColumns, Integer numberOfColumns) {
        Integer valueColumnIndex;
        int i;
        SortedMap[] valuesOverTime = objectState.getValuesOverTime();
        String id = objectState.getId();
        TimedShallowObjectState object = idToObjectState.computeIfAbsent(id, newId -> new TimedShallowObjectState(newId, numberOfColumns.intValue()));
        for (i = 0; i < valueColumns.size(); ++i) {
            valueColumnIndex = valueColumnToIndexMapping.get(valueColumns.get(i));
            object.insertValues(valueColumnIndex.intValue(), (Map)valuesOverTime[i]);
        }
        for (i = 0; i < exactValueColumns.size(); ++i) {
            valueColumnIndex = valueColumnToIndexMapping.get(exactValueColumns.getFirst(i));
            object.insertValues(valueColumnIndex.intValue(), (Map)valuesOverTime[valueColumns.size() + i]);
        }
    }

    private static class ColumnExtractor {
        private final List<String> historyValueColumns;
        private final List<String> unmanagedKeysValuesColumns;
        private final PairList<String, String> historyExactValueColumns;
        private final PairList<String, String> unmanagedKeysExactValueColumns;

        private ColumnExtractor(List<String> valueColumns, PairList<String, String> exactValueColumns, Set<String> unmanagedKeys) {
            this.historyValueColumns = CollectionUtils.filter(valueColumns, Predicate.not(unmanagedKeys::contains));
            this.unmanagedKeysValuesColumns = CollectionUtils.filter(valueColumns, unmanagedKeys::contains);
            this.historyExactValueColumns = new PairList();
            this.unmanagedKeysExactValueColumns = new PairList();
            for (int i = 0; i < exactValueColumns.size(); ++i) {
                String keyName = (String)exactValueColumns.getFirst(i);
                String exactValue = (String)exactValueColumns.getSecond(i);
                if (unmanagedKeys.contains(keyName)) {
                    this.unmanagedKeysExactValueColumns.add((Object)keyName, (Object)exactValue);
                    continue;
                }
                this.historyExactValueColumns.add((Object)keyName, (Object)exactValue);
            }
        }
    }
}

