/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.wia.TeamscaleIssue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.keyed.BranchedKeyedObjectIndexBase;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.KeyedObjectDescriberBase;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

public abstract class WorkItemUnmanagedKeysHistoryIndex<ISSUE_TYPE extends TeamscaleIssue, UPDATE_TYPE>
extends BranchedKeyedObjectIndexBase<UnmanagedKeyUpdate>
implements IProjectIndex {
    protected WorkItemUnmanagedKeysHistoryIndex(IStore store, IKeyedObjectDescriber<ISSUE_TYPE> describer) {
        super(store, (IKeyedObjectDescriber)new UnmanagedKeyUpdateDescriber(describer));
    }

    protected abstract Map<String, String> convertUpdates(@Nullable UPDATE_TYPE var1);

    protected abstract String getDefaultValue(String var1);

    @TestOnly
    public void clear() throws StorageException {
        StorageUtils.clearStore((IStore)this.store);
    }

    public void updateEntries(Map<String, UPDATE_TYPE> updatedEntries, long timestamp, Set<String> removedIds) throws StorageException {
        ArrayList<UnmanagedKeyUpdate> updates = new ArrayList<UnmanagedKeyUpdate>();
        for (Map.Entry<String, UPDATE_TYPE> updateEntry : updatedEntries.entrySet()) {
            String id2 = updateEntry.getKey();
            if (removedIds.contains(id2)) continue;
            updates.add(new UnmanagedKeyUpdate(id2, this.convertUpdates(updateEntry.getValue())));
        }
        removedIds.forEach(id -> updates.add(new UnmanagedKeyUpdate((String)id, Collections.emptyMap())));
        this.store(timestamp, updates);
    }

    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns, long timestamp, Map<String, Long> allWorkItemIdsAndTimestamps) throws StorageException {
        List result = this.query(valueColumns, exactValueColumns, timestamp);
        result = CollectionUtils.filter((Collection)result, objectState -> allWorkItemIdsAndTimestamps.containsKey(objectState.getId()));
        Map<String, TimedShallowObjectState> idToObjectState = this.mergeResultsAndIdsWithNoEntry(result, allWorkItemIdsAndTimestamps, valueColumns, exactValueColumns, timestamp);
        return CollectionUtils.map(idToObjectState.entrySet(), Map.Entry::getValue);
    }

    private Map<String, TimedShallowObjectState> mergeResultsAndIdsWithNoEntry(List<TimedShallowObjectState> results, Map<String, Long> allWorkItemIdsAndTimestamps, List<String> valueColumns, PairList<String, String> exactValueColumns, Long timestamp) throws StorageException {
        int i;
        Set<String> idsNotInResult = WorkItemUnmanagedKeysHistoryIndex.getIdsNotInResult(results, allWorkItemIdsAndTimestamps.keySet());
        int numberOfColumns = valueColumns.size() + exactValueColumns.size();
        HashMap<String, TimedShallowObjectState> idToObjectState = new HashMap<String, TimedShallowObjectState>();
        results.forEach(result -> idToObjectState.put(result.getId(), (TimedShallowObjectState)result));
        for (i = 0; i < valueColumns.size(); ++i) {
            List<String> idsToBeUpdated = WorkItemUnmanagedKeysHistoryIndex.getIdsWithoutEntry(results, idsNotInResult, i);
            WorkItemUnmanagedKeysHistoryIndex.updateWithDefaultValues(idToObjectState, idsToBeUpdated, i, numberOfColumns, allWorkItemIdsAndTimestamps, String.valueOf(this.getDefaultValue(valueColumns.get(i))));
        }
        for (i = 0; i < exactValueColumns.size(); ++i) {
            String defaultValue;
            String columnName = (String)exactValueColumns.getFirst(i);
            String exactValue = (String)exactValueColumns.getSecond(i);
            if (!exactValue.equals(defaultValue = String.valueOf(this.getDefaultValue(columnName)))) continue;
            List<String> idsWithNoEntry = this.getIdsWithoutEntry(idsNotInResult, columnName, timestamp);
            WorkItemUnmanagedKeysHistoryIndex.updateWithDefaultValues(idToObjectState, idsWithNoEntry, valueColumns.size() + i, numberOfColumns, allWorkItemIdsAndTimestamps, defaultValue);
        }
        return idToObjectState;
    }

    private static Set<String> getIdsNotInResult(List<TimedShallowObjectState> result, Set<String> allWorkItemIds) {
        Set idsInResult = CollectionUtils.mapToSet(result, TimedShallowObjectState::getId);
        return CollectionUtils.differenceSet(allWorkItemIds, (Collection[])new Collection[]{idsInResult});
    }

    private static void updateWithDefaultValues(Map<String, TimedShallowObjectState> idToObjectState, List<String> idsToBeUpdated, int columnIndex, int numberOfColumns, Map<String, Long> allWorkItemIdsAndTimestamps, String defaultValue) {
        for (String idToBeUpdated : idsToBeUpdated) {
            idToObjectState.computeIfPresent(idToBeUpdated, (id, objectState) -> {
                objectState.insert(columnIndex, ((Long)allWorkItemIdsAndTimestamps.get(id)).longValue(), defaultValue);
                return objectState;
            });
            idToObjectState.computeIfAbsent(idToBeUpdated, id -> {
                TimedShallowObjectState objectState = new TimedShallowObjectState(id, numberOfColumns);
                objectState.insert(columnIndex, ((Long)allWorkItemIdsAndTimestamps.get(id)).longValue(), defaultValue);
                return objectState;
            });
        }
    }

    private static List<String> getIdsWithoutEntry(List<TimedShallowObjectState> result, Set<String> idsNotInResult, int columnIndex) {
        List idsWithNoEntry = CollectionUtils.filterAndMap(result, objectState -> objectState.getValuesOverTime()[columnIndex] == null, TimedShallowObjectState::getId);
        idsWithNoEntry.addAll(idsNotInResult);
        return idsWithNoEntry;
    }

    private List<String> getIdsWithoutEntry(Set<String> allWorkItemIds, String key, Long timestamp) throws StorageException {
        return CollectionUtils.filterWithException(allWorkItemIds, id -> this.getColumnValue((String)id, key, timestamp) == null);
    }

    private String getColumnValue(String id, String key, long timestamp) throws StorageException {
        NewestValueExtractor collector = new NewestValueExtractor(id, key);
        this.store.scan(this.createColumnKey(key, 0L, id), this.createColumnKey(key, WorkItemUnmanagedKeysHistoryIndex.incrementTimestamp((long)timestamp), id), (IKeyValueCallback)collector);
        return collector.getNewestValue();
    }

    private static class UnmanagedKeyUpdateDescriber
    implements IKeyedObjectDescriber<UnmanagedKeyUpdate> {
        private final IKeyedObjectDescriber<? extends TeamscaleIssue> issueDelegate;

        public UnmanagedKeyUpdateDescriber(IKeyedObjectDescriber<? extends TeamscaleIssue> issueDelegate) {
            this.issueDelegate = issueDelegate;
        }

        public String getId(UnmanagedKeyUpdate unmanagedKeyUpdate) {
            return unmanagedKeyUpdate.elementId();
        }

        public String ensureIsAbsoluteId(String objectId, String relativeId) {
            return relativeId;
        }

        public List<String> getKeys(UnmanagedKeyUpdate unmanagedKeyUpdate) {
            return new ArrayList<String>(unmanagedKeyUpdate.values().keySet());
        }

        public List<String> getUnmanagedKeys() {
            return List.of();
        }

        public Function<UnmanagedKeyUpdate, String> getValueAccessor(String key) {
            return element -> element.values().get(key);
        }

        public Comparator<UnmanagedKeyUpdate> getValueComparator(String key) {
            return Comparator.comparing(element -> element.values().get(key), Comparator.nullsFirst(KeyedObjectDescriberBase.getComparator((EKeyedObjectType)this.getType(key))));
        }

        public EKeyedObjectType getType(String key) {
            return this.issueDelegate.getType(key);
        }

        public void addFieldTypeMappings(Map<String, EKeyedObjectType> fieldTypes) {
            throw new UnsupportedOperationException("not supported");
        }

        public byte[] serialize(UnmanagedKeyUpdate unmanagedKeyUpdate) throws StorageException {
            return StorageUtils.serialize((Serializable)unmanagedKeyUpdate);
        }

        public UnmanagedKeyUpdate deserialize(byte[] value) throws StorageException {
            return (UnmanagedKeyUpdate)StorageUtils.deserialize((byte[])value);
        }
    }

    @IndexValueClass
    public record UnmanagedKeyUpdate(String elementId, Map<String, String> values) implements Serializable
    {
    }

    @ThreadSafe
    private static final class NewestValueExtractor
    implements IKeyValueCallback {
        private long newestTimestamp = 0L;
        private byte[] newestValue = null;
        private final int keySize;
        private final byte[] id;

        private NewestValueExtractor(String id, String key) {
            this.keySize = StringUtils.stringToBytes((String)key).length;
            this.id = StringUtils.stringToBytes((String)id);
        }

        public synchronized void callback(byte[] key, byte[] value) {
            int timestampStartIndex = COLUMN_PREFIX.length + SEPARATOR.length + this.keySize;
            byte[] timestampPart = Arrays.copyOfRange(key, timestampStartIndex, timestampStartIndex + 8);
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])timestampPart);
            byte[] idPart = Arrays.copyOfRange(key, timestampStartIndex + 8 + SEPARATOR.length, key.length);
            if (timestamp > this.newestTimestamp && Arrays.equals(idPart, this.id)) {
                this.newestTimestamp = timestamp;
                this.newestValue = value;
            }
        }

        public String getNewestValue() {
            if (this.newestValue == null || Arrays.equals(REMOVED_VALUE, this.newestValue)) {
                return null;
            }
            return StringUtils.bytesToString((byte[])this.newestValue);
        }
    }
}

