/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.codebeamer;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.rest.HttpRequestRetryStepParameters;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.codebeamer.client.ICodebeamerClient;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItem;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemSearchResult;
import com.teamscale.index.issues.codebeamer.client.model.User;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import retrofit2.Response;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public abstract class CodebeamerSynchronizerBase<T extends TeamscaleIssue>
extends IssueTrackerSynchronizerBase<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateTimeFormatter CBQL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String SERVER_TIME_ZONE_PARAMETER_NAME = "server-time-zone";
    @StepParameter(value="Tracker Names", optional=true)
    protected List<String> trackerNames = new ArrayList<String>();
    @StepParameter(value="Project Names", optional=true)
    protected List<String> projectNames = new ArrayList<String>();
    @StepParameter(value="item-types-representing-test-cases", optional=true)
    private final Set<String> itemTypesRepresentingTestCases = new HashSet<String>();
    @StepParameter(value="Tracker Types", optional=true)
    protected final PairList<String, String> includedTrackerTypes = new PairList();
    @StepParameter(value="Tracker Item Categories", optional=true)
    protected final Set<String> includedTrackerItemCategories = new HashSet<String>();
    @StepParameterObject
    private final HttpRequestRetryStepParameters retryPolicy = new HttpRequestRetryStepParameters();
    @StepParameter(value="server-time-zone", optional=true)
    private String codeBeamerTimeZone = DateTimeUtils.getZone().getId();
    protected ICodebeamerClient codebeamerClient;
    private ZoneId userTimeZone;

    @Override
    protected void init() throws BugTrackerException {
        this.codebeamerClient = (ICodebeamerClient)Retrofit.builder((String)this.getUrl()).withBasicNTLMAuthentication(this.getUsername(), this.getPassword()).withInteractionLogger(LogManager.getLogger(((Object)((Object)this)).getClass())).withRetryPolicy(this.retryPolicy.createRetryPolicy()).create(ICodebeamerClient.class);
    }

    protected ZoneId getCodeBeamerServerTimeZone() {
        return ZoneId.of(this.codeBeamerTimeZone);
    }

    private ZoneId getUserTimeZone() {
        if (this.userTimeZone == null) {
            this.userTimeZone = this.fetchUserTimeZone().orElseGet(this::getCodeBeamerServerTimeZone);
        }
        return this.userTimeZone;
    }

    private Optional<ZoneId> fetchUserTimeZone() {
        try {
            Response response = this.codebeamerClient.getUser(this.getUsername()).execute();
            return Optional.of(response).filter(Response::isSuccessful).map(Response::body).map(User::getTimeZone).map(timezone -> {
                try {
                    return ZoneId.of(timezone);
                }
                catch (DateTimeException e) {
                    LOGGER.warn("Unable to resolve ZoneId: {}", timezone, (Object)e);
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Could not fetch user \"%s\" from codebeamer.".formatted(this.getUsername()), (Throwable)e);
            return Optional.empty();
        }
    }

    protected List<TrackerItem> retrieveUpdatedTrackerItems(long lastScanTimestamp) throws BugTrackerException, StorageException {
        String query = this.makeCbqlQuery(this.projectNames, this.trackerNames, this.includedTrackerTypes.extractFirstList(), this.includedTrackerItemCategories, lastScanTimestamp);
        return this.getTrackerItems(query);
    }

    private List<TrackerItem> getTrackerItems(String query) throws BugTrackerException {
        int total;
        ArrayList<TrackerItem> items = new ArrayList<TrackerItem>();
        int page = 1;
        do {
            try {
                TrackerItemSearchResult result = this.codebeamerClient.getTrackerItemsByQueryString(query, page, 500);
                total = result.total();
                items.addAll(result.items());
            }
            catch (ServiceCallException e) {
                throw new BugTrackerException("Could not fetch items from codebeamer.", e);
            }
            ++page;
        } while (items.size() < total);
        return items;
    }

    protected abstract T createIssue(TrackerItem var1, String var2, Map<String, String> var3, long var4, Map<String, String> var6);

    private String makeCbqlQuery(List<String> projectNames, List<String> trackerNames, List<String> trackerTypes, Set<String> trackerItemCategory, long lastScanTimestamp) {
        StringJoiner queryElements = new StringJoiner(" AND ");
        if (!projectNames.isEmpty()) {
            queryElements.add(CodebeamerSynchronizerBase.createInQuery("project.name", projectNames));
        }
        if (!trackerNames.isEmpty()) {
            queryElements.add(CodebeamerSynchronizerBase.createInQuery("tracker.name", trackerNames));
        }
        if (!trackerTypes.isEmpty()) {
            queryElements.add(CodebeamerSynchronizerBase.createInQuery("type", trackerTypes));
        }
        if (!trackerItemCategory.isEmpty()) {
            queryElements.add(CodebeamerSynchronizerBase.createInQuery("category", trackerItemCategory));
        }
        queryElements.add("modifiedAt > " + this.formatTime(lastScanTimestamp));
        return queryElements.toString();
    }

    private static String createInQuery(String field, Collection<String> values) {
        return field + " IN (" + values.stream().map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(",")) + ")";
    }

    private String formatTime(long lastScanTimestamp) {
        return StringUtils.surroundWithSingleQuotes((String)Instant.ofEpochMilli(lastScanTimestamp).atZone(this.getUserTimeZone()).format(CBQL_DATE_TIME_FORMATTER));
    }

    protected boolean isTestItem(TeamscaleIssueTypeInfo type) {
        return this.itemTypesRepresentingTestCases.contains(type.getType()) || this.itemTypesRepresentingTestCases.contains(type.getTypeAbbreviation());
    }
}

