/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.core.rest.client.Retrofit;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import okhttp3.Headers;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.Nullable;
import retrofit2.Call;

public final class PaginatedServiceCallStreamSource<T>
implements IStreamSource<T, ServiceCallException> {
    private final Function<String, Call<? extends Iterable<T>>> nextRequestFactory;
    private @Nullable Call<? extends Iterable<T>> nextRequest;
    private Iterator<T> lastResult;

    public PaginatedServiceCallStreamSource(Call<? extends Iterable<T>> initialRequest, Function<String, Call<? extends Iterable<T>>> nextRequestFactory) {
        this.nextRequestFactory = nextRequestFactory;
        this.nextRequest = Objects.requireNonNull(initialRequest, "initialRequest");
        this.lastResult = Collections.emptyIterator();
    }

    public boolean tryAdvance(Consumer<? super T> action) throws ServiceCallException {
        while (!this.lastResult.hasNext()) {
            if (this.nextRequest == null) {
                return false;
            }
            Pair response = Retrofit.executeServiceCallAndGetHeaders(this.nextRequest);
            this.nextRequest = HttpPaginationUtils.extractNextLinkFromHeaders((Headers)((Headers)response.getFirst())).map(this.nextRequestFactory).orElse(null);
            this.lastResult = ((Optional)response.getSecond()).map(Iterable::iterator).orElseGet(Collections::emptyIterator);
        }
        action.accept(this.lastResult.next());
        return true;
    }

    public Class<ServiceCallException> exceptionType() {
        return ServiceCallException.class;
    }
}

