/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.synchronization;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.parser.JiraIssueParser;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionOptions;
import com.teamscale.index.issues.model.IExternalToolIssueCustomFieldValidationResult;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class JiraConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int NOT_SET = -1;
    private final String url;
    private final String username;
    private String password;
    private final @Nullable EJiraInstanceType jiraInstanceType;
    private final List<String> cookieStringList = new ArrayList<String>();
    private final Set<String> projects = new HashSet<String>();
    private final Set<String> issueTypes = new HashSet<String>();
    private final Map<String, Boolean> customFields = new HashMap<String, Boolean>();
    private final List<ExternalToolIssueCustomField> resolvedCustomJiraFields = new ArrayList<ExternalToolIssueCustomField>();
    private final Map<String, EKeyedObjectType> resolvedFieldTypes = new HashMap<String, EKeyedObjectType>();
    private int configurationId = -1;

    public JiraConnectionConfiguration(String url, String username, String password, JiraConnectionOptions jiraConnectionOptions) {
        this.url = StringUtils.ensureEndsWith((String)url, (String)"/");
        this.username = username;
        this.password = password;
        this.jiraInstanceType = jiraConnectionOptions.instanceType();
        this.cookieStringList.addAll(jiraConnectionOptions.cookieStringList());
        this.projects.addAll(jiraConnectionOptions.projects());
        this.issueTypes.addAll(jiraConnectionOptions.issueTypes());
        this.customFields.putAll(jiraConnectionOptions.customFields());
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getCookies() {
        return this.cookieStringList;
    }

    public Set<String> getProjects() {
        return this.projects;
    }

    public Set<String> getIssueTypes() {
        return this.issueTypes;
    }

    @VisibleForTesting
    Map<String, Boolean> getCustomFields() {
        return this.customFields;
    }

    public long getConfigurationHash() {
        return XXHashUtils.xxhash64((String)this.buildConfigurationCacheInput());
    }

    @VisibleForTesting
    String buildConfigurationCacheInput() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.url).append("|").append(this.username).append("|");
        JiraConnectionConfiguration.appendCollection(this.cookieStringList, builder);
        JiraConnectionConfiguration.appendCollection(this.projects, builder);
        JiraConnectionConfiguration.appendCollection(this.issueTypes, builder);
        this.customFields.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> builder.append((String)entry.getKey()).append("=").append(entry.getValue()).append("+"));
        if (!this.customFields.isEmpty()) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void appendCollection(Collection<String> strings, StringBuilder builder) {
        strings.stream().sorted().forEach(s -> builder.append((String)s).append("+"));
        if (!strings.isEmpty()) {
            builder.setLength(builder.length() - 1);
        }
        builder.append("|");
    }

    public void fillMissingDataFromJira(JiraClient jiraClient) throws BugTrackerException, ServiceCallException {
        this.convertCustomFields(jiraClient);
        HashSet<String> fieldIds = new HashSet<String>(JiraIssueParser.FIELDS);
        fieldIds.addAll(ExternalToolIssueCustomField.getNames(this.resolvedCustomJiraFields));
        this.resolvedFieldTypes.putAll(jiraClient.getFieldTypes(fieldIds));
    }

    @VisibleForTesting
    public void convertCustomFields(@NonNull JiraClient jiraClient) throws BugTrackerException {
        List<IExternalToolIssueCustomFieldValidationResult> validationResults = JiraConnectorUtils.validateCustomJiraFields((PairList<String, Boolean>)new PairList(this.customFields), jiraClient);
        for (IExternalToolIssueCustomFieldValidationResult result : validationResults) {
            if (!result.isSuccessful()) {
                LOGGER.error(result.errorMessage());
                continue;
            }
            this.resolvedCustomJiraFields.add(result.validatedCustomField());
        }
    }

    public void setConfigurationId(int configurationId) {
        CCSMAssert.isTrue((this.configurationId == -1 ? 1 : 0) != 0, (String)"May not set configurationId more than once!");
        this.configurationId = configurationId;
    }

    public int getConfigurationId() {
        return this.configurationId;
    }

    public Map<String, EKeyedObjectType> getResolvedFieldTypes() {
        return this.resolvedFieldTypes;
    }

    public List<ExternalToolIssueCustomField> getResolvedCustomJiraFields() {
        return this.resolvedCustomJiraFields;
    }

    public void anonymizePassword() {
        this.password = "***";
    }

    public @Nullable EJiraInstanceType getJiraInstanceType() {
        return this.jiraInstanceType;
    }
}

