/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.synchronization;

import com.google.common.collect.Lists;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.jira.cache.JiraGlobalCacheIndex;
import com.teamscale.index.issues.jira.cache.JiraGlobalCacheUpdater;
import com.teamscale.index.issues.jira.model.JiraJsonIssue;
import com.teamscale.index.issues.jira.parser.JiraIssueParser;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionConfiguration;
import com.teamscale.index.issues.jira.synchronization.JiraConnectionOptions;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class JiraSynchronizerBase<T extends TeamscaleIssue>
extends IssueTrackerSynchronizerBase<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ISSUE_PATH = "browse/";
    @StepParameter(value="cookies", optional=true)
    private final List<String> cookieStringList = new ArrayList<String>();
    public static final String ISSUE_TYPES_PARAMETER_NAME = "issue-types-name";
    @StepParameter(value="issue-types-name", optional=true)
    private PairList<String, String> issueTypes = new PairList();
    public static final String JIRA_INSTANCE_TYPE_PARAMETER_NAME = "jira-instance-type-name";
    @StepParameter(value="jira-instance-type-name", optional=true)
    private @Nullable EJiraInstanceType jiraInstanceType;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected JiraGlobalCacheIndex jiraGlobalCacheIndex;
    protected JiraConnectionConfiguration configuration;

    @Override
    protected void init() throws BugTrackerException {
        JiraConnectionOptions connectionOptions = new JiraConnectionOptions(this.jiraInstanceType, this.cookieStringList, this.projects, this.issueTypes.extractFirstList(), this.customFields.toMap());
        JiraConnectionConfiguration configuration = new JiraConnectionConfiguration(this.getUrl(), this.getUsername(), this.getPassword(), connectionOptions);
        try {
            this.configuration = this.jiraGlobalCacheIndex.resolveConfiguration(configuration);
        }
        catch (ServiceCallException | StorageException e) {
            throw new BugTrackerException("Jira configuration could not be resolved: " + e.getMessage(), e);
        }
        this.addFieldTypeMappings(this.configuration.getResolvedFieldTypes());
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        try {
            new JiraGlobalCacheUpdater(this.configuration, this.pollingIntervalSeconds, this.jiraGlobalCacheIndex).updateCacheDataIfNeeded();
        }
        catch (ServiceCallException | StorageException e) {
            throw new BugTrackerException("Failed to perform Jira global cache update: " + e.getMessage(), e);
        }
        JiraSynchronizerBase jiraSynchronizerBase = this;
        JiraIssueParser<TeamscaleIssue> issueParser = new JiraIssueParser<TeamscaleIssue>(StringUtils.ensureEndsWith((String)this.getUrl(), (String)"/") + ISSUE_PATH, this.connectorId, this.configuration.getResolvedCustomJiraFields(), startTimestamp, lastScanTimestamp, onlyItemsChangedAfterTimestamp, this.issueTypes.toMap(), this::createIssue, (FunctionWithException<List<TeamscaleIssueId>, Set<TeamscaleIssueId>, StorageException>)((FunctionWithException)x$0 -> jiraSynchronizerBase.filterToUnknownIssues((List<TeamscaleIssueId>)x$0)));
        IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<TeamscaleIssue> resultBuilder = this.resultBuilder();
        List<String> changedIssueIds = this.jiraGlobalCacheIndex.getIssueIdsChangedSince(this.configuration.getConfigurationId(), lastScanTimestamp);
        LOGGER.debug("Changed issue id's for the connector {}: {}", (Object)this.configuration.getConfigurationId(), (Object)String.join((CharSequence)",", changedIssueIds));
        for (List batch : Lists.partition(changedIssueIds, (int)1000)) {
            List jsonContent = CollectionUtils.filter(this.jiraGlobalCacheIndex.getIssueJsonContent(this.configuration.getConfigurationId(), batch), Objects::nonNull);
            resultBuilder.addItems(issueParser.parseIssues(jsonContent));
        }
        return resultBuilder.addDeletions(this.performCleanupIfNecessary()).build();
    }

    protected abstract T createIssue(JiraJsonIssue var1, String var2, List<String> var3, List<String> var4, Map<String, String> var5);

    protected abstract Map<TeamscaleIssueId, Long> performCleanupIfNecessary() throws BugTrackerException, StorageException;
}

