/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.issues.radar.client.ComponentBundleClause;
import com.teamscale.index.issues.radar.client.ComponentBundleGroupIdClause;
import com.teamscale.index.issues.radar.client.ComponentClause;
import com.teamscale.index.issues.radar.client.ComponentQueryClause;
import com.teamscale.index.issues.radar.client.RadarClient;
import com.teamscale.index.issues.radar.client.RadarComponentNameQuery;
import com.teamscale.index.issues.radar.client.RadarQueryOperator;
import com.teamscale.index.issues.radar.model.RadarComponent;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class RadarFindProblemIDsQuery {
    @JsonProperty
    private boolean idsOnly;
    @JsonProperty
    private int rowLimit;
    @JsonProperty(value="keyword")
    private @Nullable List<String> keywords;
    @JsonProperty(value="any")
    private @Nullable List<ComponentQueryClause> componentClauses;
    @JsonProperty
    private @Nullable RadarQueryOperator createdAt;
    @JsonProperty
    private @Nullable RadarQueryOperator lastModifiedAt;

    private RadarFindProblemIDsQuery(@Nullable List<ComponentQueryClause> componentClauses, @Nullable RadarQueryOperator createdAt, @Nullable RadarQueryOperator lastModifiedAt, int rowLimit, boolean idsOnly, @Nullable List<String> keywords) {
        this.componentClauses = componentClauses;
        this.createdAt = createdAt;
        this.idsOnly = idsOnly;
        this.keywords = keywords;
        this.lastModifiedAt = lastModifiedAt;
        this.rowLimit = rowLimit;
    }

    public static RadarFindProblemIDsQuery idsOfProblemsChangedAfter(List<String> components, List<String> componentBundles, List<Long> componentBundleGroupIds, long minCreationTimestamp, long modifiedTimestamp, Set<String> keywords, boolean inclusiveDateMatching) {
        QueryBuilder builder = new QueryBuilder();
        RadarQueryOperator createdAtOperator = RadarFindProblemIDsQuery.createDateGreaterThanOperator(minCreationTimestamp, inclusiveDateMatching);
        RadarQueryOperator modifiedOperator = RadarFindProblemIDsQuery.createDateGreaterThanOperator(modifiedTimestamp, inclusiveDateMatching);
        return builder.withIdsOnly().withCreatedAt(createdAtOperator).withLastModifiedAt(modifiedOperator).withComponents(components).withComponentBundles(componentBundles).withComponentBundleGroupIds(componentBundleGroupIds).withKeywords(new ArrayList<String>(keywords)).build();
    }

    private static RadarQueryOperator createDateGreaterThanOperator(long timestamp, boolean inclusiveDateMatching) {
        String date = RadarFindProblemIDsQuery.toISOString(timestamp);
        if (inclusiveDateMatching) {
            return RadarQueryOperator.greaterThanOrEqual(date);
        }
        return RadarQueryOperator.greaterThan(date);
    }

    private static @NonNull String toISOString(long timestamp) {
        ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), DateTimeUtils.getZone());
        return date.format(RadarClient.RADAR_DATE_FORMATTER);
    }

    public static class QueryBuilder {
        private boolean idsOnly;
        private int rowLimit = -1;
        private @Nullable List<String> keywords;
        private List<String> componentNames = Collections.emptyList();
        private List<String> componentBundleNames = Collections.emptyList();
        private List<Long> componentBundleGroupIds = Collections.emptyList();
        private @Nullable RadarQueryOperator createdAt;
        private @Nullable RadarQueryOperator lastModifiedAt;

        public RadarFindProblemIDsQuery build() {
            List componentClauses = CollectionUtils.map(this.componentNames, componentName -> new ComponentClause(RadarComponent.createQueryFromComponentName(componentName)));
            List componentBundleClauses = CollectionUtils.map(this.componentBundleNames, name -> new ComponentBundleClause(new RadarComponentNameQuery((String)name)));
            List componentBundleGroupClauses = CollectionUtils.map(this.componentBundleGroupIds, ComponentBundleGroupIdClause::new);
            List clauses = CollectionUtils.concatenateLists((List)componentClauses, (List)componentBundleClauses, (List[])new List[]{componentBundleGroupClauses});
            return new RadarFindProblemIDsQuery(clauses, this.createdAt, this.lastModifiedAt, this.rowLimit, this.idsOnly, this.keywords);
        }

        public QueryBuilder withRowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
            return this;
        }

        public QueryBuilder withIdsOnly() {
            this.idsOnly = true;
            return this;
        }

        public QueryBuilder withKeywords(List<String> keywords) {
            this.keywords = keywords.isEmpty() ? null : keywords;
            return this;
        }

        public QueryBuilder withComponents(List<String> componentNames) {
            this.componentNames = componentNames;
            return this;
        }

        public QueryBuilder withComponentBundles(List<String> componentBundleNames) {
            this.componentBundleNames = componentBundleNames;
            return this;
        }

        public QueryBuilder withComponentBundleGroupIds(List<Long> componentBundleGroupIds) {
            this.componentBundleGroupIds = componentBundleGroupIds;
            return this;
        }

        public QueryBuilder withCreatedAt(RadarQueryOperator operator) {
            this.createdAt = operator;
            return this;
        }

        public QueryBuilder withLastModifiedAt(RadarQueryOperator operator) {
            this.lastModifiedAt = operator;
            return this;
        }
    }
}

