/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc;

import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.RtcConnectorUtils;
import com.teamscale.index.issues.rtc.RtcIssueSynchronizer;
import java.util.Collections;
import java.util.List;

@ConnectorDescriptor
public class RtcBugTrackerConnectorDescriptor
extends BugTrackerConnectorDescriptorBase {
    private static final String ITEM_TYPES_PARAMETER_NAME = "Item types";
    private static final String ITEM_TYPES_PARAMETER_DESCRIPTION = "The types of work items to retrieve. Leave empty for all item types.";
    @ConfigExposed(name="Item types", description="The types of work items to retrieve. Leave empty for all item types.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private List<String> itemTypes = Collections.emptyList();
    @ConfigExposed(name="Field filter expression", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A pattern to filter work items based on their fields. This is sent to the Reportable REST API and will be concatenated with a logical AND to any existing filters.")
    protected String additionalFieldFilter = null;
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(RtcConnectorUtils::validateAccountDetails, true);

    public RtcBugTrackerConnectorDescriptor() {
        super(EIssueTracker.RTC);
        this.autoExpose();
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return RtcIssueSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("field-filter", this.additionalFieldFilter);
        issueTrackerTriggerBuilder.setTriggerParameter("item-type", ITriggerParameter.of(this.itemTypes));
    }
}

