/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.core.tfs.TfsWorkItem;
import com.teamscale.index.issues.BugTrackerException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;

public class TfsWorkItemRevisionFetcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IWorkItemRestClient workItemRestClient;

    public TfsWorkItemRevisionFetcher(IWorkItemRestClient workItemRestClient) {
        this.workItemRestClient = workItemRestClient;
    }

    public List<TfsWorkItem> getRevisionsForIssue(String id, String expandOption) throws BugTrackerException {
        EntryMessage entryMessage = LOGGER.traceEntry("getRevisionsForIssue(id={}, expandOption={})", new Object[]{id, expandOption});
        ArrayList revisions = new ArrayList();
        try {
            int skip = 0;
            while (true) {
                List result = this.workItemRestClient.getWorkItemRevision(id, skip, expandOption).getWorkItems();
                revisions.addAll(result);
                if (!result.isEmpty()) {
                    skip += result.size();
                    continue;
                }
                break;
            }
        }
        catch (ServiceCallException e) {
            throw (BugTrackerException)LOGGER.traceExit(entryMessage, (Object)new BugTrackerException(String.format("Fetching the revisions of the work item with the id %s failed", id), e));
        }
        return (List)LOGGER.traceExit(entryMessage, revisions);
    }
}

