/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.tfs;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.core.tfs.wiql.SimpleWiqlBuilder;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.tfs.AzureDevOpsIssueConnectorUtils;
import com.teamscale.index.issues.tfs.TfsWorkItemFilterParameters;
import com.teamscale.index.issues.tfs.TfsWorkItemSynchronizer;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;

@ConnectorDescriptor
public class TfsWorkItemTrackerConnectorDescriptor
extends BugTrackerConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpRequestRetryPolicy httpRequestRetryPolicy = this.getRetryPolicy();
    @ConfigExposed(name="Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of areas to extract work items from (full area paths). (case-insensitive)")
    private List<String> areas = CollectionUtils.emptyList();
    @ConfigExposed(name="Include Sub-Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-areas are retrieved as well.\nOtherwise, just work items exactly matching one of the area paths are retrieved.")
    private boolean includeSubAreas = false;
    @ConfigExposed(name="Excluded Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of areas to exclude from extracting work items (full area paths). (case-insensitive)")
    private List<String> excludedAreas = CollectionUtils.emptyList();
    @ConfigExposed(name="Exclude Sub-Areas of Excluded Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-areas declared in \"Excluded Areas\" are excluded as well.\nOtherwise, just work items exactly matching one of the area paths are excluded.")
    private boolean excludeSubAreas = false;
    @ConfigExposed(name="Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of iterations to extract work items from (full iteration paths). (case-insensitive)")
    private List<String> iterations = CollectionUtils.emptyList();
    @ConfigExposed(name="Include Sub-Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-iterations are retrieved as well.\nOtherwise, just work items exactly matching one of the iteration paths are retrieved.")
    private boolean includeSubIterations = false;
    @ConfigExposed(name="Excluded Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of iterations to exclude from extracting work items (full iteration paths). (case-insensitive)")
    private List<String> excludedIterations = CollectionUtils.emptyList();
    @ConfigExposed(name="Exclude Sub-Iterations or Excluded Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-iterations declared in \"Excluded Iterations\" are excluded as well.\nOtherwise, just work items exactly matching one of the iteration paths are excluded.")
    private boolean excludeSubIterations = false;
    @ConfigExposed(name="Tags", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of tags. Import work items with any of these tags only. (case-insensitive)")
    private List<String> tags = CollectionUtils.emptyList();
    @ConfigExposed(name="Excluded Tags", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of tags. Do not import work items with any of these tags. (case-insensitive)")
    private List<String> excludedTags = CollectionUtils.emptyList();
    @ConfigExposed(name="Item Types", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of work item types to retrieve. Leave empty for all item types. (case-insensitive)")
    private List<String> itemTypes = CollectionUtils.emptyList();
    @ConfigExposed(name="Closed states", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of states. If a work item is in one of the following states it is considered closed. (case-sensitive)")
    private List<String> closedStates = Arrays.asList("Done", "Closed", "Resolved");
    @ConfigExposed(name="Retrieve history", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, the full history of a work item is retrieved. This can lead to high load on the TFS-Server.")
    private boolean includeHistory = true;
    @ConfigExposed(name="Retrieve parent links", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, any parent relationship will be retrieved. This can lead to more load on the TFS-Server.")
    private boolean includeLinks = false;
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(this::validateAccountDetails, false, false);

    protected TfsWorkItemTrackerConnectorDescriptor() {
        super(EIssueTracker.TFS);
        this.autoExpose();
    }

    protected HttpRequestRetryPolicy getRetryPolicy() {
        return HttpRequestRetryPolicy.AZURE_DEVOPS;
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return TfsWorkItemSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        this.getFilterParameters().setTriggerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("item-type", ITriggerParameter.of(this.itemTypes));
        issueTrackerTriggerBuilder.setTriggerParameter("closed-state", ITriggerParameter.of(this.closedStates));
        issueTrackerTriggerBuilder.setTriggerParameter("include-history", this.includeHistory);
        issueTrackerTriggerBuilder.setTriggerParameter("include-links", this.includeLinks);
        issueTrackerTriggerBuilder.resolveIndexNamePlaceholder("work-item-cleanup-index-placeholder", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        this.validateWiqlValues();
    }

    private void validateWiqlValues() throws ConnectorValidationException {
        List<String> invalidValues = Stream.of(this.closedStates, this.itemTypes, this.areas).flatMap(Collection::stream).filter(Predicate.not(SimpleWiqlBuilder::isValueValidForQuery)).distinct().toList();
        if (!invalidValues.isEmpty()) {
            throw new ConnectorValidationException("The following values may not be used in a query, as they contain ' or \": " + String.valueOf(invalidValues));
        }
    }

    protected final void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        IWorkItemRestClient workItemRestClient = new TfsHttpConnection(url, username, password, this.httpRequestRetryPolicy, LOGGER).createWorkItemRestClient();
        AzureDevOpsIssueConnectorUtils.checkWorkItemRetrieval(url, workItemRestClient, this.projects, this.getFilterParameters(), this.itemTypes);
    }

    private TfsWorkItemFilterParameters getFilterParameters() {
        return new TfsWorkItemFilterParameters(new TfsWorkItemFilterParameters.IncludeExcludeRecursiveFilterParameters(this.areas, this.includeSubAreas, this.excludedAreas, this.excludeSubAreas), new TfsWorkItemFilterParameters.IncludeExcludeRecursiveFilterParameters(this.iterations, this.includeSubIterations, this.excludedIterations, this.excludeSubIterations), new TfsWorkItemFilterParameters.IncludeExcludeFilterParameters(this.tags, this.excludedTags));
    }
}

