/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.updater.TypeSpecificIssueTrackerContentUpdaterBase;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class BasicTokenElementIndexUpdater
extends TypeSpecificIssueTrackerContentUpdaterBase {
    @VisibleForTesting
    static final TomlMapper MAPPER = (TomlMapper)((TomlMapper.Builder)JsonUtils.configureDefaultSettings((MapperBuilder)TomlMapper.builder())).build();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BasicTokenElementIndex basicTokenElementIndex;

    @Override
    protected void handleTypeFilteredWorkItemUpdates(List<SpecItem> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws StorageException {
        for (SpecItem issue : updatedItems) {
            String textContent = this.getText(issue);
            ELanguage language = issue.getWorkItemType().getLanguage();
            UniformPath uniformPath = issue.getUniformPath();
            this.basicTokenElementIndex.setTokenElements(List.of(new BasicTokenElementInfo(uniformPath.toString(), language, false, textContent, Collections.emptyList(), Collections.emptyList())));
        }
        for (TeamscaleIssueId deletedItemId : deletedItemIds) {
            SpecItem deletedIssue = (SpecItem)this.previousIssueIndex.getIssue(deletedItemId);
            CCSMAssert.isNotNull((Object)deletedIssue, () -> String.format("Expected deleted issue for id \"%s\" to be not null in previous version", deletedItemId));
            this.basicTokenElementIndex.removeTokenElements(Set.of(deletedIssue.getUniformPath().toString()));
        }
    }

    private String getText(SpecItem issue) {
        try {
            return MAPPER.writeValueAsString((Object)issue);
        }
        catch (JsonProcessingException e) {
            throw new UnsupportedOperationException("Unable to serialize issue: %s".formatted(issue), e);
        }
    }
}

