/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.updater;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.index.issues.updater.TypeSpecificIssueTrackerContentUpdaterBase;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class BinaryElementIndexUpdater
extends TypeSpecificIssueTrackerContentUpdaterBase {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private BinaryElementIndex binaryElementIndex;

    @Override
    protected void handleTypeFilteredWorkItemUpdates(List<SpecItem> updatedItems, List<TeamscaleIssueId> deletedItemIds) throws StorageException {
        for (SpecItem updatedItem : updatedItems) {
            UniformPath uniformPath = updatedItem.getUniformPath();
            try {
                this.binaryElementIndex.setContent(uniformPath, SerializationUtils.serializeToByteArray((Serializable)updatedItem));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        for (TeamscaleIssueId deletedItemId : deletedItemIds) {
            SpecItem deletedIssue = (SpecItem)this.previousIssueIndex.getIssue(deletedItemId);
            CCSMAssert.isNotNull((Object)deletedIssue, () -> String.format("Expected deleted issue for id \"%s\" to be not null in previous version", deletedItemId));
            UniformPath uniformPath = deletedIssue.getUniformPath();
            this.binaryElementIndex.removeContent(uniformPath);
        }
    }
}

