/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.testcoverage;

import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.testcoverage.LineCoverageChange;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.git.common.VoteSupportingGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import com.teamscale.index.testcoverage.CoverageAdjuster;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.utils.LocaleIndependentDoubleParser;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.equals.IEquator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.sonar.api.utils.Preconditions;

public class MergeRequestLineCoverageCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_DIFF_SIZE = 10000;
    private static final IEquator<LineOfTokens> TOKEN_TEXT_EQUATOR = (line1, line2) -> Objects.equals(line1.tokenTexts(), line2.tokenTexts());
    private final ProjectStorageSystem projectStorageSystem;
    private final MergeBaseInfo mergeBaseInfo;
    private final TokenElementIndex baselineElementIndex;
    private final TokenElementIndex headElementIndex;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final LineCoverageIndex lineCoverageIndex;
    private final ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex;
    private final double threshold;
    private Map<String, TokenElementInfo> headTokenElements;
    private Map<String, TokenElementInfo> baselineTokenElementsByUniformPath;
    private Map<String, TokenElementLineInfo> elementLineInfosByPath;
    private Map<String, LineCoverageInfo> mergedCoverage;

    private MergeRequestLineCoverageCalculator(ProjectStorageSystem projectStorageSystem, CommitDescriptor source, MergeBaseInfo mergeBaseInfo, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        this(projectStorageSystem, source, mergeBaseInfo, MergeRequestLineCoverageCalculator.getCoverageThreshold(projectStorageSystem, mergeRequestIdentifier));
    }

    private MergeRequestLineCoverageCalculator(ProjectStorageSystem projectStorageSystem, CommitDescriptor source, MergeBaseInfo mergeBaseInfo, double threshold) throws StorageException {
        this.projectStorageSystem = projectStorageSystem;
        this.mergeBaseInfo = mergeBaseInfo;
        this.threshold = threshold;
        CommitDescriptor startCommit = mergeBaseInfo.getMergeBase();
        HistoryAccessOption baselineAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)startCommit);
        HistoryAccessOption sourceAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)source);
        this.baselineElementIndex = (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", baselineAccessOption);
        this.headElementIndex = (TokenElementIndex)projectStorageSystem.openProjectIndex(TokenElementIndex.class, "content", sourceAccessOption);
        this.tokenElementLineInfoIndex = (TokenElementLineInfoIndex)projectStorageSystem.openProjectIndex(TokenElementLineInfoIndex.class, sourceAccessOption);
        this.lineCoverageIndex = (LineCoverageIndex)projectStorageSystem.openProjectIndex(LineCoverageIndex.class, sourceAccessOption);
        this.externalResultsPartitionLastUpdateIndex = (ExternalResultsPartitionLastUpdateIndex)projectStorageSystem.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, sourceAccessOption);
    }

    private static double getCoverageThreshold(ProjectStorageSystem projectStorageSystem, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        MetaIndex metaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        double result = Double.MAX_VALUE;
        for (String repositoryIdentifier : MergeRequestUtils.getMatchingConnectorIdentifiersFromProject(projectStorageSystem, mergeRequestIdentifier)) {
            Optional optionValue = metaIndex.getStringValue(VoteSupportingGitRepositoryConnectorDescriptorBase.getLineCoverageThresholdKey(repositoryIdentifier));
            if (optionValue.isEmpty()) continue;
            double threshold = LocaleIndependentDoubleParser.parseDouble((String)optionValue.get());
            if (threshold > 100.0) {
                throw new StorageException("Invalid configured threshold '%s'. Must be between 0 and 100.".formatted(threshold));
            }
            result = Math.min(threshold, result);
        }
        if (result > 100.0) {
            throw new StorageException(String.format("No line coverage threshold configured for `%s`.", mergeRequestIdentifier.repositoryPath()));
        }
        return result / 100.0;
    }

    public static TestCoverageDeltaInfo getLineCoverageDelta(ProjectStorageSystem projectStorageSystem, CommitDescriptor source, MergeBaseInfo mergeBaseInfo, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        return new MergeRequestLineCoverageCalculator(projectStorageSystem, source, mergeBaseInfo, mergeRequestIdentifier).calculate();
    }

    public static TestCoverageDeltaInfo getLineCoverageDelta(ProjectStorageSystem projectStorageSystem, CommitDescriptor source, MergeBaseInfo mergeBaseInfo, int threshold) throws StorageException {
        Preconditions.checkArgument((threshold <= 100 && threshold >= 0 ? 1 : 0) != 0, (String)"Threshold must be between 0 and 100.");
        return new MergeRequestLineCoverageCalculator(projectStorageSystem, source, mergeBaseInfo, (double)threshold / 100.0).calculate();
    }

    private TestCoverageDeltaInfo calculate() throws StorageException {
        RepositoryLogIndex repositoryLogIndex = (RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        List<CommitDescriptor> relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest(repositoryLogIndex, this.mergeBaseInfo);
        List<TokenElementChurnWithOriginInfo> affectedFilesInfo = AffectedFilesUtils.getAffectedFiles(this.projectStorageSystem, relevantCommits, null).stream().filter(info -> info.getChangeType() != EElementHistoryChangeType.DELETE && info.getChangeType() != EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD).toList();
        List allTestCoveragePartitions = this.lineCoverageIndex.getPartitions();
        List<String> updatedPartitions = MergeRequestUtils.getUpdatedTestCoveragePartitions(this.externalResultsPartitionLastUpdateIndex, relevantCommits, allTestCoveragePartitions);
        List<String> relevantPartitions = MergeRequestLineCoverageCalculator.getRelevantCoveragePartitions(updatedPartitions, allTestCoveragePartitions);
        return new TestCoverageDeltaInfo(this.getLineCoverage(affectedFilesInfo, relevantPartitions), this.mergeBaseInfo.getMergeBase(), !allTestCoveragePartitions.isEmpty(), updatedPartitions, this.threshold);
    }

    private static List<String> getRelevantCoveragePartitions(List<String> updatedPartitions, List<String> allTestCoveragePartitions) {
        List<String> relevantCoverage = EFeatureToggle.USE_COVERABLE_LINES_FROM_COVERAGE_REPORTS.isEnabled() ? updatedPartitions : allTestCoveragePartitions;
        return relevantCoverage;
    }

    private List<LineCoverageChange> getLineCoverage(List<TokenElementChurnWithOriginInfo> affectedFilesInfo, List<String> partitions) throws StorageException {
        List affectedUniformPaths = CollectionUtils.map(affectedFilesInfo, TokenElementChurnInfo::getUniformPath);
        this.headTokenElements = this.headElementIndex.getTokenElementsByUniformPath(affectedUniformPaths);
        affectedFilesInfo = MergeRequestLineCoverageCalculator.filterTestFiles(affectedFilesInfo, this.headTokenElements.values());
        affectedUniformPaths = CollectionUtils.map(affectedFilesInfo, TokenElementChurnInfo::getUniformPath);
        this.baselineTokenElementsByUniformPath = this.baselineElementIndex.getTokenElementsByUniformPath(affectedFilesInfo.stream().map(MergeRequestLineCoverageCalculator::getBaselinePath).filter(Objects::nonNull).distinct().toList());
        this.elementLineInfosByPath = this.tokenElementLineInfoIndex.getLineInfosByPaths(affectedUniformPaths);
        Map<String, Map<String, LineCoverageInfo>> coverageInfos = this.lineCoverageIndex.getCoverageInfos(partitions, (List<String>)affectedUniformPaths);
        this.mergedCoverage = MergeRequestLineCoverageCalculator.mergeCoverageAcrossPartitions(coverageInfos);
        return CollectionUtils.filter((Collection)CollectionUtils.map(affectedFilesInfo, this::getLineCoverageChange), Objects::nonNull);
    }

    private static Map<String, LineCoverageInfo> mergeCoverageAcrossPartitions(Map<String, Map<String, LineCoverageInfo>> coverageInfos) {
        HashMap<String, LineCoverageInfo> merged = new HashMap<String, LineCoverageInfo>();
        coverageInfos.values().stream().flatMap(e -> e.entrySet().stream()).forEach(entry -> {
            String filePath = (String)entry.getKey();
            LineCoverageInfo lineCoverageInfo = (LineCoverageInfo)entry.getValue();
            if (merged.containsKey(filePath)) {
                ((LineCoverageInfo)merged.get(filePath)).addAll(lineCoverageInfo);
            } else {
                merged.put(filePath, lineCoverageInfo);
            }
        });
        return merged;
    }

    private boolean hasLineInfo(TokenElementChurnWithOriginInfo churn) {
        return this.elementLineInfosByPath.get(churn.getUniformPath()) != null;
    }

    private @Nullable LineCoverageChange getLineCoverageChange(TokenElementChurnWithOriginInfo churn) {
        if (!this.hasLineInfo(churn)) {
            return null;
        }
        String uniformPath = churn.getUniformPath();
        LineCoverageInfo lineCoverageInfo = this.mergedCoverage.get(uniformPath);
        boolean coverageInfoPresent = lineCoverageInfo != null;
        TokenElementLineInfo tokenElementLineInfo = this.elementLineInfosByPath.get(uniformPath);
        if (coverageInfoPresent) {
            CoverageAdjuster.correctLineCoverage(uniformPath, tokenElementLineInfo, lineCoverageInfo, true);
        }
        CompactLines coverableLines = CoverageAdjuster.getCoverableLines(tokenElementLineInfo, lineCoverageInfo, coverageInfoPresent, uniformPath);
        CompactLines addedOrChangedLines = this.getAddedOrChangedLines(churn, uniformPath);
        int addedOrChangedCoverableLines = addedOrChangedLines.intersection(coverableLines).size();
        if (addedOrChangedCoverableLines == 0) {
            return null;
        }
        CompactLines coveredLines = MergeRequestLineCoverageCalculator.getCoveredLines(lineCoverageInfo);
        int addedOrChangedCoveredLines = addedOrChangedLines.intersection(coveredLines).size();
        double coverageOnNewCode = MergeRequestLineCoverageCalculator.getCoverageOnNewCode(addedOrChangedCoveredLines, addedOrChangedCoverableLines);
        boolean aboveThreshold = coverageOnNewCode >= this.threshold;
        return new LineCoverageChange(uniformPath, churn.getOriginPath(), coverageOnNewCode, addedOrChangedCoverableLines, addedOrChangedCoveredLines, aboveThreshold);
    }

    private static double getCoverageOnNewCode(int numberOfAddedOrChangedCoveredLines, int numberOfAddedOrChangedCoverableLines) {
        return LineCoverageInfo.calculateCoverageRatio((int)numberOfAddedOrChangedCoveredLines, (int)numberOfAddedOrChangedCoverableLines);
    }

    private CompactLines getAddedOrChangedLines(TokenElementChurnWithOriginInfo churn, String uniformPath) {
        String baselinePath = MergeRequestLineCoverageCalculator.getBaselinePath(churn);
        TokenElementInfo baselineTokenElementInfo = this.baselineTokenElementsByUniformPath.get(baselinePath);
        TokenElementInfo headTokenElement = this.headTokenElements.get(uniformPath);
        return MergeRequestLineCoverageCalculator.calculateNewAndChangedLines(baselineTokenElementInfo, headTokenElement);
    }

    public static @NonNull CompactLines calculateNewAndChangedLines(@Nullable TokenElementInfo baselineTokenElementInfo, TokenElementInfo headTokenElement) {
        if (baselineTokenElementInfo == null) {
            CompactLines allLines = new CompactLines();
            for (IToken token : headTokenElement.getTokens()) {
                allLines.add(token.getLineNumber() + 1);
            }
            return allLines;
        }
        Diff.Delta delta = Diff.computeDelta(MergeRequestLineCoverageCalculator.groupByLines(baselineTokenElementInfo.getTokens()), MergeRequestLineCoverageCalculator.groupByLines(headTokenElement.getTokens()), (int)10000, TOKEN_TEXT_EQUATOR);
        if (delta.getSize() == 10000) {
            LOGGER.warn("Reached maximum delta size of {} while calculating diff for {}.", (Object)10000, (Object)headTokenElement.getUniformPath());
        }
        return MergeRequestLineCoverageCalculator.filterAddedAndModifiedLinesFromDelta((Diff.Delta<LineOfTokens>)delta);
    }

    private static List<LineOfTokens> groupByLines(@NonNull List<IToken> tokens) {
        ArrayList<LineOfTokens> result = new ArrayList<LineOfTokens>();
        LineOfTokens currentLine = null;
        int currentLineNumber = -1;
        for (IToken token : tokens) {
            if (currentLine == null || currentLineNumber != token.getLineNumber()) {
                currentLineNumber = token.getLineNumber();
                currentLine = new LineOfTokens(new ArrayList<String>(), token.getLineNumber() + 1);
                result.add(currentLine);
            }
            currentLine.tokenTexts.add(token.getText());
        }
        return result;
    }

    private static CompactLines filterAddedAndModifiedLinesFromDelta(Diff.Delta<LineOfTokens> delta) {
        CompactLines addedOrChangedLines = new CompactLines();
        for (int i = 0; i < delta.getSize(); ++i) {
            boolean isAdditionOrChange;
            boolean bl = isAdditionOrChange = delta.getPosition(i) > 0;
            if (!isAdditionOrChange) continue;
            LineOfTokens addedOrChangedToken = (LineOfTokens)delta.getT(i);
            addedOrChangedLines.add(addedOrChangedToken.lineNumber());
        }
        return addedOrChangedLines;
    }

    private static CompactLines getCoveredLines(LineCoverageInfo lineCoverageInfo) {
        if (lineCoverageInfo == null) {
            return new CompactLines();
        }
        return lineCoverageInfo.getCoveredLines();
    }

    private static @NonNull List<TokenElementChurnWithOriginInfo> filterTestFiles(List<TokenElementChurnWithOriginInfo> affectedFilesInfo, Collection<TokenElementInfo> tokenElementInfos) {
        Set testFiles = tokenElementInfos.stream().filter(element -> element.getFirstDetailOfType(PartOfTestCodeDetail.class).isPresent()).map(BasicTokenElementInfo::getUniformPath).collect(Collectors.toSet());
        affectedFilesInfo = CollectionUtils.filter(affectedFilesInfo, info -> !testFiles.contains(info.getUniformPath()));
        return affectedFilesInfo;
    }

    private static @Nullable String getBaselinePath(TokenElementChurnWithOriginInfo tokenElementChurnWithOriginInfo) {
        return Optional.ofNullable(tokenElementChurnWithOriginInfo.getOriginPath()).orElse(tokenElementChurnWithOriginInfo.getUniformPath());
    }

    private record LineOfTokens(List<String> tokenTexts, int lineNumber) {
    }
}

