/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata;

import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.Nullable;

@Index(name="token-elements-metadata", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={IFileMetadata.class})
public class TokenElementMetadataIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "token-elements-metadata";
    private static final List<Class<? extends IFileMetadata>> META_DATA_CLASSES = List.of(AbapFileMetadata.class);
    private static final Map<Class<? extends IFileMetadata>, Byte> META_DATA_CLASS_INDEX = new HashMap<Class<? extends IFileMetadata>, Byte>();

    public TokenElementMetadataIndex(IStore store) {
        super(store);
    }

    public void storeMetadata(PairList<String, ? extends IFileMetadata> filesToMetadata) throws StorageException {
        PairList keysValues = new PairList();
        List abbreviated = this.store.getAbbreviator().abbreviate((SequencedCollection)filesToMetadata.extractFirstList());
        for (int i = 0; i < filesToMetadata.size(); ++i) {
            byte[] key = TokenElementMetadataIndex.makeKey((int)((Integer)abbreviated.get(i)), ((IFileMetadata)filesToMetadata.getSecond(i)).getClass());
            keysValues.add((Object)key, (Object)StorageUtils.serialize((Serializable)((Serializable)filesToMetadata.getSecond(i))));
        }
        this.store.put(keysValues);
    }

    private static byte[] makeKey(int abbreviatedUniformPath, Class<? extends IFileMetadata> metaDataClass) {
        Byte metaDataClassByte = META_DATA_CLASS_INDEX.get(metaDataClass);
        if (metaDataClassByte == null) {
            throw new AssertionError((Object)("Trying to insert meta-data class " + String.valueOf(metaDataClass) + " which was not registered in this index!"));
        }
        return TokenElementMetadataIndex.makeKey(abbreviatedUniformPath, metaDataClassByte);
    }

    private static byte[] makeKey(int abbreviatedUniformPath, byte metaDataClassByte) {
        byte[] key = new byte[5];
        ByteArrayUtils.putIntIntoByteArray((byte[])key, (int)0, (int)abbreviatedUniformPath);
        key[4] = metaDataClassByte;
        return key;
    }

    public List<List<IFileMetadata>> getMetadataForFiles(List<String> uniformPaths) throws StorageException {
        List values = this.store.get(this.getAllMetaDataKeys(uniformPaths));
        ArrayList<List<IFileMetadata>> result = new ArrayList<List<IFileMetadata>>();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            ArrayList<IFileMetadata> metadata = null;
            for (int metaDataIndex = 0; metaDataIndex < META_DATA_CLASSES.size(); metaDataIndex = (int)((byte)(metaDataIndex + 1))) {
                byte[] value = (byte[])values.get(i * META_DATA_CLASSES.size() + metaDataIndex);
                if (value == null) continue;
                if (metadata == null) {
                    metadata = new ArrayList<IFileMetadata>(1);
                }
                metadata.add((IFileMetadata)StorageUtils.deserialize((byte[])value));
            }
            result.add(Objects.requireNonNullElse(metadata, Collections.emptyList()));
        }
        return result;
    }

    public <T extends IFileMetadata> Optional<T> getMetadataOfTypeForFile(String uniformPath, Class<T> fileMetadataClass) throws StorageException {
        byte[] value = this.store.get(TokenElementMetadataIndex.makeKey(this.store.getAbbreviator().abbreviate(uniformPath), fileMetadataClass));
        return Optional.ofNullable((IFileMetadata)StorageUtils.deserialize((byte[])value));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public <T extends IFileMetadata> List<T> getMetadataOfTypeForFiles(List<String> uniformPaths, Class<T> fileMetadataClass) throws StorageException {
        List abbreviatedPaths = this.store.getAbbreviator().abbreviate(uniformPaths);
        List<byte[]> keys = abbreviatedPaths.stream().map(path -> TokenElementMetadataIndex.makeKey((int)path, fileMetadataClass)).toList();
        @Nullable List values = this.store.get(keys);
        ArrayList<IFileMetadata> metadataEntries = new ArrayList<IFileMetadata>();
        for (byte[] value : values) {
            if (value == null) {
                metadataEntries.add(null);
                continue;
            }
            metadataEntries.add((IFileMetadata)StorageUtils.deserialize((byte[])value));
        }
        return metadataEntries;
    }

    public void removeMetadata(List<String> files) throws StorageException {
        this.store.remove(this.getAllMetaDataKeys(files));
    }

    private List<byte[]> getAllMetaDataKeys(List<String> files) throws StorageException {
        ArrayList<byte[]> allMetaDataKeys = new ArrayList<byte[]>();
        Iterator iterator = this.store.getAbbreviator().abbreviate(files).iterator();
        while (iterator.hasNext()) {
            int abbreviated = (Integer)iterator.next();
            for (byte metaDataIndex = 0; metaDataIndex < META_DATA_CLASSES.size(); metaDataIndex = (byte)(metaDataIndex + 1)) {
                allMetaDataKeys.add(TokenElementMetadataIndex.makeKey(abbreviated, metaDataIndex));
            }
        }
        return allMetaDataKeys;
    }

    public ListMap<String, IFileMetadata> getMetadataForKeys(List<StorageKey> keys) throws StorageException {
        List<String> uniformPaths = this.unabbreviateKeys(keys);
        List values = this.store.get(keys.stream().map(StorageKey::getKey).toList());
        ListMap result = new ListMap();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            byte[] value = (byte[])values.get(i);
            if (value == null) continue;
            result.add((Object)uniformPaths.get(i), (Object)((IFileMetadata)StorageUtils.deserialize((byte[])value)));
        }
        return result;
    }

    public List<String> unabbreviateKeys(List<StorageKey> keys) throws StorageException {
        return this.store.getAbbreviator().unabbreviate(keys.stream().map(key -> ByteBuffer.wrap(key.getKey()).getInt()).toList());
    }

    static {
        for (int i = 0; i < META_DATA_CLASSES.size(); ++i) {
            META_DATA_CLASS_INDEX.put(META_DATA_CLASSES.get(i), (byte)i);
        }
    }
}

