/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.computation;

import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.NumericMetricValue;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.assessment.computation.MetricComputationBase;
import java.text.DecimalFormat;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class NumericMetricComputation
extends MetricComputationBase<Double> {
    public static final DecimalFormat NUMERIC_TREND_NUMBER_FORMAT = NumericMetricValue.createNumberFormat((String)"+###.##;-###.##");
    private static final double COMPARISON_ERROR_MARGIN = 1.0 / Math.pow(10.0, NUMERIC_TREND_NUMBER_FORMAT.getMaximumFractionDigits());

    public NumericMetricComputation(MetricDirectorySchemaEntry schemaEntry) {
        super(schemaEntry);
    }

    @Override
    public ETrend execComputeTrend(EvaluatedMetricThreshold threshold, Double currentValue, Double baselineValue) {
        int comparisonResult = this.compareWithMargin(baselineValue, currentValue);
        if (this.isLowIsBad(threshold)) {
            comparisonResult *= -1;
        }
        return ETrend.fromValueComparison(comparisonResult);
    }

    private int compareWithMargin(double baselineValue, double currentValue) {
        double delta = this.getMetricDelta(baselineValue, currentValue);
        if (Math.abs(delta) < COMPARISON_ERROR_MARGIN) {
            return 0;
        }
        return Double.compare(baselineValue, currentValue);
    }

    @Override
    protected TrendDelta execComputeTrendDelta(Double currentValue, Double baselineValue) {
        double delta = this.getMetricDelta(currentValue, baselineValue);
        Object formattedDelta = NUMERIC_TREND_NUMBER_FORMAT.format(delta);
        if (this.getSchemaEntry().hasProperty(EMetricProperty.RATIO_METRIC)) {
            formattedDelta = (String)formattedDelta + "%";
        }
        return new TrendDelta((String)formattedDelta);
    }

    private double getMetricDelta(Double currentValue, Double baselineValue) {
        double delta = currentValue - baselineValue;
        if (this.getSchemaEntry().hasProperty(EMetricProperty.RATIO_METRIC)) {
            delta *= 100.0;
        }
        return delta;
    }

    @Override
    protected ETrafficLightColor execComputeMetricRating(EvaluatedMetricThreshold threshold, IMetricValue<?> metricValue) {
        return this.getRatingColor(threshold, metricValue.getValueAsDoubleForRating(null).orElse(0.0), metricValue.getValueAsDoubleForRating(null).orElse(0.0));
    }
}

