/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.context;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.external.update.ExternalMetricsLastUpdateIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogIndex;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public enum PartitionUpdateType {
    NO_UPDATES,
    BRANCH_HEAD_OUTDATED,
    BASELINE_INCOMPLETE,
    BOTH_COMPLETE;


    public static PartitionUpdateType computePartitionUpdateType(ProjectStorageSystem projectStorageSystem, HistoryAccessOption baselineHistoryAccessOption, HistoryAccessOption currentHistoryAccessOption, String metricId, UniformPath thresholdSubPath) throws StorageException {
        currentHistoryAccessOption = PartitionUpdateType.determineRelevantCommitHistoryAccessOption(projectStorageSystem, currentHistoryAccessOption);
        ExternalMetricsLastUpdateIndex startExternalMetricsLastUpdateIndex = (ExternalMetricsLastUpdateIndex)projectStorageSystem.openProjectIndex(ExternalMetricsLastUpdateIndex.class, baselineHistoryAccessOption);
        ExternalMetricsLastUpdateIndex endExternalMetricsLastUpdateIndex = (ExternalMetricsLastUpdateIndex)projectStorageSystem.openProjectIndex(ExternalMetricsLastUpdateIndex.class, currentHistoryAccessOption);
        long currentReadTimestamp = PartitionUpdateType.getCurrentReadTimestamp(projectStorageSystem, currentHistoryAccessOption);
        Set<ExternalMetricsLastUpdateIndex.PartitionUpdateEntry> startPartitionUpdates = startExternalMetricsLastUpdateIndex.getLastPartitionUpdates(metricId, thresholdSubPath);
        Set<ExternalMetricsLastUpdateIndex.PartitionUpdateEntry> endPartitionUpdates = endExternalMetricsLastUpdateIndex.getLastPartitionUpdates(metricId, thresholdSubPath);
        PartitionUpdateResults results = PartitionUpdateType.getUpdatedAndOutdatedPartitions(startPartitionUpdates, endPartitionUpdates, currentReadTimestamp, baselineHistoryAccessOption.getTimestamp());
        return PartitionUpdateType.getPartitionUpdateType(results);
    }

    private static PartitionUpdateResults getUpdatedAndOutdatedPartitions(Set<ExternalMetricsLastUpdateIndex.PartitionUpdateEntry> startPartitionUpdates, Set<ExternalMetricsLastUpdateIndex.PartitionUpdateEntry> endPartitionUpdates, long currentReadTimestamp, long baselineTimestamp) {
        HashSet<String> partitionsDirectlyUpdatedInEndCommit = new HashSet<String>();
        HashSet<String> partitionsWithOutdatedData = new HashSet<String>();
        for (ExternalMetricsLastUpdateIndex.PartitionUpdateEntry endPartitionUpdate : endPartitionUpdates) {
            if (endPartitionUpdate.timestamp() == currentReadTimestamp) {
                partitionsDirectlyUpdatedInEndCommit.add(endPartitionUpdate.partition());
                continue;
            }
            partitionsWithOutdatedData.add(endPartitionUpdate.partition());
        }
        HashSet<String> partitionsDirectlyUpdatedInStartCommit = new HashSet<String>();
        for (ExternalMetricsLastUpdateIndex.PartitionUpdateEntry startPartitionUpdate : startPartitionUpdates) {
            if (startPartitionUpdate.timestamp() != baselineTimestamp) continue;
            partitionsDirectlyUpdatedInStartCommit.add(startPartitionUpdate.partition());
        }
        return new PartitionUpdateResults(partitionsDirectlyUpdatedInStartCommit, partitionsDirectlyUpdatedInEndCommit, partitionsWithOutdatedData);
    }

    private static @NonNull PartitionUpdateType getPartitionUpdateType(PartitionUpdateResults results) {
        if (results.partitionsDirectlyUpdatedInStartCommit.isEmpty() && results.partitionsDirectlyUpdatedInEndCommit.isEmpty()) {
            return NO_UPDATES;
        }
        if (!results.partitionsWithOutdatedData.isEmpty()) {
            return BRANCH_HEAD_OUTDATED;
        }
        if (SetUtils.difference(results.partitionsDirectlyUpdatedInEndCommit, results.partitionsDirectlyUpdatedInStartCommit).isEmpty()) {
            return BOTH_COMPLETE;
        }
        return BASELINE_INCOMPLETE;
    }

    private static HistoryAccessOption determineRelevantCommitHistoryAccessOption(ProjectStorageSystem projectStorageSystem, HistoryAccessOption currentHistoryAccessOption) throws StorageException {
        RepositoryLogIndex logIndex = (RepositoryLogIndex)projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        long currentReadTimestamp = PartitionUpdateType.getCurrentReadTimestamp(projectStorageSystem, currentHistoryAccessOption);
        CommitDescriptor currentCommit = new CommitDescriptor(currentHistoryAccessOption.getBranchName(), currentReadTimestamp);
        Optional<CommitDescriptor> lastCodeOrUploadCommit = RepositoryLastChangeUtils.findLastCommitOfType(currentCommit, Set.of(ECommitType.CODE_COMMIT, ECommitType.EXTERNAL_ANALYSIS), logIndex, commitDescriptorIndex);
        if (lastCodeOrUploadCommit.isPresent()) {
            return HistoryAccessOption.readCommit((CommitDescriptor)lastCodeOrUploadCommit.get());
        }
        return HistoryAccessOption.readCommit((CommitDescriptor)currentCommit);
    }

    private static long getCurrentReadTimestamp(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        Optional branchHead;
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        if (historyAccessOption.isReadHead() && !StringUtils.isEmpty((String)historyAccessOption.getBranchName()) && (branchHead = commitDescriptorIndex.getLatestCommitForBranch(historyAccessOption.getBranchName())).isPresent()) {
            return ((ParentedCommitDescriptor)branchHead.get()).getTimestamp();
        }
        return historyAccessOption.getTimestamp();
    }

    private record PartitionUpdateResults(Set<String> partitionsDirectlyUpdatedInStartCommit, Set<String> partitionsDirectlyUpdatedInEndCommit, Set<String> partitionsWithOutdatedData) {
    }
}

