/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig
extends ConfigurationOptionMigrationBase {
    private static final Map<String, String> CONFIG_MAPPING = Map.of("MANDT", "GET_CLIENT", "HOST", "GET_HOST_NAME", "SYSID", "GET_INSTANCE_NAME", "UNAME", "GET_USER_NAME");

    public AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig() {
        super("Usage of system variables - relevant system variables", "Usage of System Fields");
    }

    @Override
    protected void doMigrateJson(ObjectNode analysisProfile) {
        Set<String> prevUsageSystemFieldConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.asUppercaseSet(this.options.get("Usage of system variables - relevant system variables"));
        Set<String> prevUsageContextMethodConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.asUppercaseSet(this.options.get("Usage of system variables - relevant context info methods"));
        List<String> newUsageSystemMethodConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.mappedConfig(prevUsageSystemFieldConfig, prevUsageContextMethodConfig);
        Set<String> prevControlSystemFieldConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.asUppercaseSet(this.options.get("Control flow depending on system variables - relevant system variables"));
        Set<String> prevControlContextMethodConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.asUppercaseSet(this.options.get("Control flow depending on system variables - relevant context info methods"));
        List<String> newControlSystemMethodConfig = AnalysisProfileVersion216ConsiderPreviousSystemVariableConfig.mappedConfig(prevControlSystemFieldConfig, prevControlContextMethodConfig);
        JsonNodeFactory factory = JsonNodeFactory.instance;
        this.options.set("Usage of system variables - relevant system methods", (JsonNode)factory.textNode(StringUtils.concatWithEscapeCharacter(newUsageSystemMethodConfig, (Character)CollectionUtils.MULTI_VALUE_DELIMITER)));
        this.options.set("Control flow depending on system variables - relevant system methods", (JsonNode)factory.textNode(StringUtils.concatWithEscapeCharacter(newControlSystemMethodConfig, (Character)CollectionUtils.MULTI_VALUE_DELIMITER)));
    }

    private static Set<String> asUppercaseSet(JsonNode configNode) {
        if (configNode == null) {
            return Set.of("");
        }
        String config = configNode.asText();
        return CollectionUtils.parseMultiValueStringToList((String)config, (boolean)true).stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    private static List<String> mappedConfig(Set<String> prevSystemFieldConfig, Set<String> prevContextMethodConfig) {
        List newConfig = CONFIG_MAPPING.keySet().stream().filter(prevSystemFieldConfig::contains).map(CONFIG_MAPPING::get).collect(Collectors.toCollection(ArrayList::new));
        if (prevContextMethodConfig.contains("GET_USER_ALIAS")) {
            newConfig.add("GET_ALIAS_USER");
        }
        if (prevSystemFieldConfig.contains("HOST")) {
            newConfig.add("GET_INSTANCE_NAME");
        }
        if (prevContextMethodConfig.stream().map(s -> s.startsWith("GET_USER_")).findAny().isPresent()) {
            newConfig.add("GET_USER_NAME");
        }
        return newConfig.stream().distinct().sorted().toList();
    }
}

