/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import java.io.Serializable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion150ExternalAccountConnectorTypeInfo
implements IPointwiseStorageMigrator {
    public String getStoreName() {
        return "external-credentials";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V150;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        ExternalCredentials credentials = (ExternalCredentials)StorageUtils.deserialize((byte[])LZ4Utils.decompress((byte[])value));
        if (credentials.connectorTypeInfo == null) {
            ExternalCredentials newValue = new ExternalCredentials(credentials.credentialsName, credentials.uri, credentials.username, credentials.password, new ExternalCredentials.ConnectorTypeInfo());
            newValue.setLastChangeInformation(credentials.getLastChangeUser(), credentials.getLastChangeTimestamp());
            return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])StorageUtils.serialize((Serializable)newValue)));
        }
        return PairList.from((Object)key, (Object)value);
    }
}

