/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.google.common.collect.Iterables;
import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics
extends BranchBasedStoreBatchMigratorBase {
    private static final String PREDEFINED_COUNT_METRIC_FIELD = "count";
    private static final String PREDEFINED_TIME_METRIC_FIELD = "time";
    private static final String PREDEFINED_ASSESSMENT_METRIC_FIELD = "assessment";
    private static final String NUMERIC_METRICS_FIELD = "numericMetrics";
    private static final String ASSESSMENT_METRICS_FIELD = "assessmentMetrics";

    protected MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V160, true);
    }

    public String getStoreName() {
        return "external-analysis-results";
    }

    protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
        try {
            String keyString = StringUtils.bytesToString((byte[])key);
            if (!keyString.contains("##-non-code-/")) {
                return value;
            }
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            SerializedClass infoClass = entityPool.findClass("com.teamscale.index.external.ExternalProcessStepInfo");
            if (infoClass == null) {
                return value;
            }
            List infos = SerializedEntityUtils.findInstancesOf((SerializedClass)infoClass, (SerializedEntityPool)entityPool);
            MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics.migrateExternalProcessStepInfos(infos, infoClass, entityPool);
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException("Can't deserialize value object for key " + Arrays.toString(key), (Throwable)e);
        }
    }

    private static void migrateExternalProcessStepInfos(List<SerializedObject> infos, SerializedClass infoClass, SerializedEntityPool entityPool) throws IOException, StorageException {
        IdentityHashMap<SerializedObject, HashMap<String, Number>> numericMetricsForInfos = new IdentityHashMap<SerializedObject, HashMap<String, Number>>(infos.size());
        for (SerializedObject info : infos) {
            numericMetricsForInfos.put(info, MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics.getHardCodedNumericMetricsAsMap(entityPool, info));
        }
        IdentityHashMap<SerializedObject, HashMap<String, SerializationMigrationUtils.WrappedHandle>> assessmentMetricsForInfos = new IdentityHashMap<SerializedObject, HashMap<String, SerializationMigrationUtils.WrappedHandle>>(infos.size());
        for (SerializedObject info : infos) {
            assessmentMetricsForInfos.put(info, MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics.getHardCodedAssessmentMetricsAsMap(entityPool, info));
        }
        for (SerializedObject info : infos) {
            info.removeFieldValue(PREDEFINED_COUNT_METRIC_FIELD);
            info.removeFieldValue(PREDEFINED_ASSESSMENT_METRIC_FIELD);
            info.removeFieldValue(PREDEFINED_TIME_METRIC_FIELD);
        }
        infoClass.removeField(PREDEFINED_COUNT_METRIC_FIELD);
        infoClass.removeField(PREDEFINED_ASSESSMENT_METRIC_FIELD);
        infoClass.removeField(PREDEFINED_TIME_METRIC_FIELD);
        infoClass.addField((SerializedFieldBase)new SerializedObjectField(NUMERIC_METRICS_FIELD, SerializedObjectField.createJvmNotationFromPlainClassName((String)HashMap.class.getName())));
        infoClass.addField((SerializedFieldBase)new SerializedObjectField(ASSESSMENT_METRICS_FIELD, SerializedObjectField.createJvmNotationFromPlainClassName((String)HashMap.class.getName())));
        for (SerializedObject info : infos) {
            HashMap numericMetrics = (HashMap)numericMetricsForInfos.get(info);
            SerializedEntityBase numericMetricsEntity = MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics.getCustomMapAsSerializedEntity(numericMetrics, entityPool);
            info.setFieldValue(NUMERIC_METRICS_FIELD, (Object)numericMetricsEntity.getHandle());
            HashMap assessmentMetrics = (HashMap)assessmentMetricsForInfos.get(info);
            SerializedEntityBase assessmentMetricsEntity = MigrateVersion160ConvertHardCodedToCustomExternalProcessMetrics.getCustomMapAsSerializedEntity(assessmentMetrics, entityPool);
            info.setFieldValue(ASSESSMENT_METRICS_FIELD, (Object)assessmentMetricsEntity.getHandle());
        }
    }

    private static HashMap<String, Number> getHardCodedNumericMetricsAsMap(SerializedEntityPool entityPool, SerializedObject externalProcessStepInfo) throws IOException {
        int count;
        HashMap<String, Number> hardCodedNumericMetrics = new HashMap<String, Number>();
        int countHandle = (Integer)externalProcessStepInfo.getFieldValue(PREDEFINED_COUNT_METRIC_FIELD);
        if (countHandle == 0) {
            count = 1;
        } else {
            SerializedObject countObject = (SerializedObject)entityPool.getEntity(countHandle, SerializedObject.class);
            count = (Integer)countObject.getFieldValue("value");
        }
        hardCodedNumericMetrics.put(PREDEFINED_COUNT_METRIC_FIELD, count);
        double time = (Double)externalProcessStepInfo.getFieldValue(PREDEFINED_TIME_METRIC_FIELD);
        hardCodedNumericMetrics.put(PREDEFINED_TIME_METRIC_FIELD, time);
        return hardCodedNumericMetrics;
    }

    private static HashMap<String, SerializationMigrationUtils.WrappedHandle> getHardCodedAssessmentMetricsAsMap(SerializedEntityPool entityPool, SerializedObject externalProcessStepInfo) throws IOException {
        HashMap<String, SerializationMigrationUtils.WrappedHandle> hardCodedAssessmentMetrics = new HashMap<String, SerializationMigrationUtils.WrappedHandle>();
        Integer assessmentHandle = (Integer)externalProcessStepInfo.getFieldValue(PREDEFINED_ASSESSMENT_METRIC_FIELD);
        SerializedObject serializedAssessment = (SerializedObject)entityPool.getEntity(assessmentHandle.intValue(), SerializedObject.class);
        hardCodedAssessmentMetrics.put(PREDEFINED_ASSESSMENT_METRIC_FIELD, SerializationMigrationUtils.WrappedHandle.of((SerializedObjectBase)serializedAssessment));
        return hardCodedAssessmentMetrics;
    }

    private static SerializedEntityBase getCustomMapAsSerializedEntity(HashMap<String, ? extends Serializable> customMetrics, SerializedEntityPool entityPool) throws IOException {
        SerializedEntityPool temporaryPool = SerializedEntityParser.parse((byte[])SerializationUtils.serializeToByteArray(customMetrics));
        SerializedEntityBase temporaryEntity = (SerializedEntityBase)Iterables.getOnlyElement((Iterable)temporaryPool.getRootEntities());
        return SerializationMigrationUtils.copy((SerializedEntityPool)temporaryPool, (SerializedEntityBase)temporaryEntity, (SerializedEntityPool)entityPool);
    }
}

