/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import com.teamscale.core.option.HashedPasswordOptionUtils;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion161PrometheusServiceOption
extends SerializedValueMigratorBase {
    private static final String OLD_CLASS = "com.teamscale.index.monitoring.prometheus.PrometheusServiceOption";
    private static final String NEW_CLASS = "com.teamscale.core.options.PrometheusServiceOption";

    protected MigrateVersion161PrometheusServiceOption() {
        super(true);
    }

    public String getStoreName() {
        return "server-options";
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V161;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass oldClass = entityPool.findClass(OLD_CLASS);
        if (oldClass == null) {
            return;
        }
        SerializedObject serviceOption = entityPool.getEntities(SerializedObject.class).stream().filter(object -> object.getClassHandle() == oldClass.getHandle()).findFirst().orElseThrow();
        Object secretObject = serviceOption.getFieldValue("secret");
        SerializedStringObject stringEntity = (SerializedStringObject)entityPool.getEntity(((Integer)secretObject).intValue(), SerializedStringObject.class);
        if (stringEntity != null) {
            String secret = stringEntity.getValue();
            stringEntity.setValue(HashedPasswordOptionUtils.hashPassword((byte[])StringUtils.stringToBytes((String)secret), (String)HashedStoredPasswordAuthenticator.generateSalt((int)32)));
        }
        entityPool.renameClass(OLD_CLASS, NEW_CLASS);
    }
}

