/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.intellij.lang.annotations.Language;

public class ProjectVersion52AddTgaBranchConfig {
    private static final String ADD_TO_JIRA_ISSUES_OPTION = "Add to Jira issues";

    public static String migrate(@Language(value="JSON") String json) throws JsonSerializationException, JsonProcessingException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        for (ConnectorConfiguration connector : holder.connectors) {
            ObjectNode issueUpdateConfig;
            String issueUpdateConfigJson = connector.getOptionValue(ADD_TO_JIRA_ISSUES_OPTION);
            if (issueUpdateConfigJson == null || (issueUpdateConfig = (ObjectNode)JsonUtils.deserializeFromJson((String)issueUpdateConfigJson)).has("tgaBranchConfig")) continue;
            ObjectNode tgaBranchConfig = JsonUtils.getObjectMapper().createObjectNode();
            tgaBranchConfig.put("autoSelectBranch", true);
            issueUpdateConfig.set("tgaBranchConfig", (JsonNode)tgaBranchConfig);
            connector.setOptionValue(ADD_TO_JIRA_ISSUES_OPTION, JsonUtils.getObjectMapper().writeValueAsString((Object)issueUpdateConfig));
        }
        return JsonUtils.serializeToJSON((Object)holder);
    }
}

