/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.finding;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.teamscale.index.migration.finding.ConfigurationOptionMigrationBase;
import java.util.Map;
import java.util.TreeMap;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public class ConfigurationOptionValueReplacement
extends ConfigurationOptionMigrationBase {
    private final Map<String, String> oldToNewOptionValues;

    public ConfigurationOptionValueReplacement(String optionName, String analysisGroup, Map<String, String> oldToNewOptionValues) {
        super(optionName, analysisGroup);
        this.oldToNewOptionValues = oldToNewOptionValues;
    }

    @Override
    protected void doMigrateJson(ObjectNode analysisProfile) {
        Pair<ObjectNode, ObjectNode> qualityIndicatorAndGroup = ConfigurationOptionValueReplacement.getAnalysisGroup(analysisProfile, this.oldAnalysisGroup);
        if (qualityIndicatorAndGroup == null) {
            return;
        }
        ObjectNode analysisGroup = (ObjectNode)qualityIndicatorAndGroup.getSecond();
        if (!analysisGroup.hasNonNull("options")) {
            return;
        }
        ObjectNode analysisGroupOptions = (ObjectNode)CCSMAssert.checkedCast((Object)analysisGroup.get("options"), ObjectNode.class);
        JsonNode optionNode = analysisGroupOptions.get(this.oldOptionName);
        if (optionNode instanceof TextNode) {
            TextNode optionTextNode = (TextNode)optionNode;
            String oldOptionValue = optionTextNode.textValue();
            String newOptionValue = this.oldToNewOptionValues.get(oldOptionValue);
            if (newOptionValue == null) {
                return;
            }
            analysisGroupOptions.put(this.oldOptionName, newOptionValue);
        }
    }

    public static ConfigurationOptionValueReplacement withCaseInsensitive(String optionName, String analysisGroup, Map<String, String> oldToNewOptionValues) {
        TreeMap<String, String> caseInsensitiveMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveMap.putAll(oldToNewOptionValues);
        return new ConfigurationOptionValueReplacement(optionName, analysisGroup, caseInsensitiveMap);
    }
}

