/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v128_tokens_in_compile_commands;

import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@ThreadSafe
public class MigrateVersion128TokensInCompileCommands
extends BranchBasedStoreBatchMigratorBase {
    private static final String EXTERNAL_ANALYSIS_COMMIT_KEY = "#-#commit#-#";
    private static final String PARTITION_SEPARATOR = "##";

    public MigrateVersion128TokensInCompileCommands() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V128, true);
    }

    public String getStoreName() {
        return "external-analysis-results";
    }

    protected byte[] migrateValue(byte[] originalKey, byte[] value) throws StorageException {
        SerializedEntityPool entityPool;
        String key = StringUtils.bytesToString((byte[])originalKey);
        if (StringUtils.containsIgnoreCase((String)key, (String)EXTERNAL_ANALYSIS_COMMIT_KEY)) {
            return value;
        }
        if (!MigrateVersion128TokensInCompileCommands.shouldMigrateEntry(MigrateVersion128TokensInCompileCommands.splitKey(key))) {
            return value;
        }
        try {
            entityPool = SerializedEntityParser.parse((byte[])value);
        }
        catch (IOException e) {
            throw new StorageException("Can't deserialize value object for key " + key, (Throwable)e);
        }
        try {
            SerializedClass compilationCommandClass = entityPool.findClass("org.conqat.engine.index.shared.CompilationCommand");
            if (compilationCommandClass == null) {
                return value;
            }
            MigrateVersion128TokensInCompileCommands.migrateCompilationCommandsInEntityPool(entityPool, compilationCommandClass);
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException("Can't migrate value object for key " + key, (Throwable)e);
        }
    }

    private static boolean shouldMigrateEntry(PartitionAndPath partitionAndPath) {
        if (partitionAndPath == null) {
            return false;
        }
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)partitionAndPath.getUniformPath());
        return uniformPath.getType() == UniformPath.EType.CODE;
    }

    private static PartitionAndPath splitKey(String originalKey) {
        String[] components = originalKey.split(PARTITION_SEPARATOR);
        if (components.length != 2) {
            return null;
        }
        return new PartitionAndPath(components[0], components[1]);
    }

    private static void migrateCompilationCommandsInEntityPool(SerializedEntityPool entityPool, SerializedClass compilationCommandClass) throws IOException {
        List<SerializedObject> compileCommandObjects = entityPool.getEntities(SerializedObject.class).stream().filter(object -> object.getClassHandle() == compilationCommandClass.getHandle()).toList();
        for (SerializedObject compileCommandObject : compileCommandObjects) {
            Integer definitionsFieldHandle = (Integer)compileCommandObject.getFieldValue("definitions");
            if (definitionsFieldHandle == null) continue;
            SerializedObject definitionsDetailObject = (SerializedObject)entityPool.getEntity(definitionsFieldHandle.intValue(), SerializedObject.class);
            SerializedObject directiveListObject = (SerializedObject)entityPool.getEntity(((Integer)definitionsDetailObject.getFieldValue("prependDirectives")).intValue(), SerializedObject.class);
            MigrateVersion128TokensInCompileCommands.migrateTokenListEntriesToString(directiveListObject, entityPool);
            compileCommandObject.setFieldValue("definitions", (Object)directiveListObject.getHandle());
        }
        MigrateVersion128TokensInCompileCommands.migrateFieldTypeInCompilationCommandClass(compilationCommandClass);
    }

    private static void migrateFieldTypeInCompilationCommandClass(SerializedClass compilationCommandClass) {
        ArrayList fields = new ArrayList(compilationCommandClass.getFields());
        for (SerializedFieldBase field : fields) {
            compilationCommandClass.removeField(field.getName());
        }
        for (SerializedFieldBase field : fields) {
            if (field.getName().equals("definitions")) {
                compilationCommandClass.addField((SerializedFieldBase)new SerializedObjectField("definitions", "Ljava/util/ArrayList;"));
                continue;
            }
            compilationCommandClass.addField(field);
        }
    }

    private static void migrateTokenListEntriesToString(SerializedObject directiveListObject, SerializedEntityPool entityPool) throws IOException {
        SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy((SerializedObject)directiveListObject, ArrayList.class);
        SerializedClassValues fieldSets = directiveListObject.getFieldSet(directiveListObject.getPlainClassHierarchy().indexOf(listClass));
        List postFieldData = fieldSets.getPostFieldData();
        for (int i = 0; i < postFieldData.size(); ++i) {
            Object data = postFieldData.get(i);
            if (!(data instanceof Integer)) continue;
            SerializedEntityBase containedElement = entityPool.getEntity(((Integer)data).intValue(), SerializedEntityBase.class);
            String reconstructedString = MigrateVersion128TokensInCompileCommands.createCompilerParameterFromDefineDirectiveToken(containedElement, entityPool);
            SerializedStringObject newString = new SerializedStringObject(reconstructedString, entityPool);
            postFieldData.set(i, newString.getHandle());
        }
    }

    private static String createCompilerParameterFromDefineDirectiveToken(SerializedEntityBase token, SerializedEntityPool entityPool) throws IOException {
        SerializedObject tokenObject = (SerializedObject)token;
        int textHandle = (Integer)tokenObject.getFieldValue("text");
        SerializedStringObject textObject = (SerializedStringObject)entityPool.getEntity(textHandle, SerializedStringObject.class);
        String tokenText = textObject.getValue();
        String modifiedText = StringUtils.stripPrefix((String)tokenText, (String)"#define ");
        if (modifiedText.contains(" ")) {
            modifiedText = modifiedText.replaceFirst(" ", "=");
        }
        return "-D" + modifiedText;
    }
}

