/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v154_compiler_and_options_in_compile_commands;

import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.List;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@ThreadSafe
public class MigrateVersion154CompileCommands
extends BranchBasedStoreBatchMigratorBase {
    private static final String COMPILATION_COMMAND_CLASS = "com.teamscale.index.resource.CompilationCommand";
    private static final String COMPILER_COMMAND_ATTRIBUTE = "compilerCommand";
    private static final String OTHER_OPTIONS_ATTRIBUTE = "otherOptions";
    private static final String EXTERNAL_ANALYSIS_COMMIT_KEY = "#-#commit#-#";
    private static final String PARTITION_SEPARATOR = "##";

    public MigrateVersion154CompileCommands() {
        super(EStorageSystemVersion.STORAGE_SYSTEM_V154, true);
    }

    public String getStoreName() {
        return "external-analysis-results";
    }

    protected byte[] migrateValue(byte[] originalKey, byte[] value) throws StorageException {
        SerializedEntityPool entityPool;
        String key = StringUtils.bytesToString((byte[])originalKey);
        if (StringUtils.containsIgnoreCase((String)key, (String)EXTERNAL_ANALYSIS_COMMIT_KEY)) {
            return value;
        }
        if (!MigrateVersion154CompileCommands.shouldMigrateEntry(MigrateVersion154CompileCommands.splitKey(key))) {
            return value;
        }
        try {
            entityPool = SerializedEntityParser.parse((byte[])value);
        }
        catch (IOException e) {
            throw new StorageException("Can't deserialize value object for key " + key, (Throwable)e);
        }
        try {
            MigrateVersion154CompileCommands.addCompilerCommandAndOptionsFields(entityPool);
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException("Can't migrate value object for key " + key, (Throwable)e);
        }
    }

    private static void addCompilerCommandAndOptionsFields(SerializedEntityPool entityPool) throws IOException {
        SerializedClassFieldMigrator fieldMigrator = new SerializedClassFieldMigrator(entityPool);
        fieldMigrator.addStringField(COMPILATION_COMMAND_CLASS, COMPILER_COMMAND_ATTRIBUTE, "clang++");
        fieldMigrator.addListField(COMPILATION_COMMAND_CLASS, OTHER_OPTIONS_ATTRIBUTE, SerializationMigrationUtils.createSerializedArrayListObject(List.of(), (SerializedEntityPool)entityPool).getHandle());
    }

    private static boolean shouldMigrateEntry(PartitionAndPath partitionAndPath) {
        if (partitionAndPath == null) {
            return false;
        }
        UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)partitionAndPath.getUniformPath());
        return uniformPath.getType() == UniformPath.EType.CODE;
    }

    private static PartitionAndPath splitKey(String originalKey) {
        String[] components = originalKey.split(PARTITION_SEPARATOR);
        if (components.length != 2) {
            return null;
        }
        return new PartitionAndPath(components[0], components[1]);
    }
}

