/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v171_user_alias;

import com.google.common.collect.Iterables;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.MigrateVersion174UnmodifiableCollectionsBase;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public abstract class MigrationVersion171UserAlias
extends SerializedValueMigratorBase {
    private static final EStorageSystemVersion VERSION = EStorageSystemVersion.STORAGE_SYSTEM_V171;
    private static final String ALIASES_FIELD_NAME = "aliases";
    private final String storeName;
    private final EStorageMigratorType storeType;

    protected MigrationVersion171UserAlias(String storeName, EStorageMigratorType storeType, boolean compressed) {
        super(compressed);
        this.storeName = storeName;
        this.storeType = storeType;
    }

    protected final void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass userClass = entityPool.findClass("com.teamscale.core.user.User");
        if (userClass == null) {
            return;
        }
        List userEntities = entityPool.getEntities(userClass);
        MigrateVersion174UnmodifiableCollectionsBase.doMigrate((SerializedEntityPool)entityPool);
        for (SerializedObject userEntity : userEntities) {
            int aliasesHandle = (Integer)userEntity.getFieldValue(ALIASES_FIELD_NAME);
            SerializedObject serializedAliasesList = (SerializedObject)entityPool.getEntity(aliasesHandle, SerializedObject.class);
            List deserializeAliasesList = (List)((Object)StorageUtils.deserialize((byte[])SerializedEntitySerializer.serializeToBytes(List.of(serializedAliasesList))));
            LinkedHashSet deserializedAliasesSet = new LinkedHashSet(deserializeAliasesList);
            SerializedEntityPool temporaryPool = SerializedEntityParser.parse((byte[])StorageUtils.serialize(deserializedAliasesSet));
            SerializedEntityBase serilizedAliasesSet = (SerializedEntityBase)Iterables.getOnlyElement((Iterable)temporaryPool.getRootEntities());
            serilizedAliasesSet = SerializationMigrationUtils.copy((SerializedEntityPool)temporaryPool, (SerializedEntityBase)serilizedAliasesSet, (SerializedEntityPool)entityPool);
            userEntity.setFieldValue(ALIASES_FIELD_NAME, (Object)serilizedAliasesSet.getHandle());
        }
    }

    public String getStoreName() {
        return this.storeName;
    }

    public EStorageMigratorType getType() {
        return this.storeType;
    }

    public EStorageSystemVersion getVersion() {
        return VERSION;
    }

    @ThreadSafe
    public static final class MigrateVersion171MetricNotificationRuleIndex
    extends MigrationVersion171UserAlias {
        public MigrateVersion171MetricNotificationRuleIndex() {
            super("metric-notification-rules", EStorageMigratorType.GLOBAL, true);
        }
    }

    @ThreadSafe
    public static final class MigrateVersion171ProjectNotificationRuleIndex
    extends MigrationVersion171UserAlias {
        public MigrateVersion171ProjectNotificationRuleIndex() {
            super("project-notification-rules", EStorageMigratorType.GLOBAL, true);
        }
    }

    @ThreadSafe
    public static final class MigrateVersion171SlideRenderDataIndex
    extends MigrationVersion171UserAlias {
        public MigrateVersion171SlideRenderDataIndex() {
            super("slide-render-data", EStorageMigratorType.GLOBAL, true);
        }
    }

    @ThreadSafe
    public static final class MigrateVersion171UserIndex
    extends MigrationVersion171UserAlias {
        private static final byte[] USER_KEY_PREFIX = StringUtils.stringToBytes((String)"users$%$");

        public MigrateVersion171UserIndex() {
            super("users", EStorageMigratorType.GLOBAL, true);
        }

        protected boolean isHiddenKey(byte[] key) {
            return super.isHiddenKey(key) || !MigrateVersion171UserIndex.isUserKey(key);
        }

        private static boolean isUserKey(byte[] key) {
            return ByteArrayUtils.isPrefix((byte[])USER_KEY_PREFIX, (byte[])key);
        }
    }
}

