/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v88_project_alias;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoMigrated;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class V89ProjectInfoUnmigrated
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String ALIAS_PROPERTY = "alias";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CREATION_TIMESTAMP_PROPERTY = "creationTimestamp";
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="alias")
    @Nullable String alias;
    @JsonProperty(value="aliases")
    @Nullable List<String> aliases;
    @JsonProperty(value="parentProjectId")
    @Nullable String parentProjectId;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="description")
    @Nullable String description;
    @JsonProperty(value="creationTimestamp")
    long creationTimestamp;
    @JsonProperty(value="deleting")
    boolean deleting = false;
    @JsonProperty(value="reanalyzing")
    boolean reanalyzing = false;
    @JsonProperty(value="copyingData")
    boolean copyingData = false;

    @JsonCreator
    public V89ProjectInfoUnmigrated(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="alias") String alias, @JsonProperty(value="aliases") List<String> aliases, @JsonProperty(value="parentProjectId") String parentProjectId, @JsonProperty(value="description") String description, @JsonProperty(value="creationTimestamp") long creationTimestamp) {
        this.id = id;
        this.name = name;
        this.aliases = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)alias)) {
            this.aliases.add(alias);
        }
        if (!CollectionUtils.isNullOrEmpty(aliases)) {
            this.aliases.addAll(aliases);
        }
        if (!this.aliases.isEmpty()) {
            this.alias = this.aliases.get(0);
        }
        this.parentProjectId = parentProjectId;
        this.description = description;
        this.creationTimestamp = creationTimestamp;
        if (parentProjectId != null) {
            Preconditions.checkState((!StringUtils.isEmpty((String)parentProjectId) ? 1 : 0) != 0, (Object)"Can't have an empty parent project id. Must be either null or a non-empty string.");
        }
    }

    public V89ProjectInfoUnmigrated(V89ProjectInfoMigrated migrated) {
        this.id = migrated.internalId.toString();
        this.name = migrated.name;
        this.aliases = CollectionUtils.map(migrated.publicIds, ProjectIdBase::toString);
        this.alias = this.aliases.get(0);
        this.parentProjectId = Optional.ofNullable(migrated.parentProjectId).map(ProjectIdBase::toString).orElse(null);
        this.description = migrated.description;
        this.creationTimestamp = migrated.creationTimestamp;
    }
}

