/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionGroup;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocationUtils;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

public class NamingConventionAnalyzer {
    public static final String FINDINGS_CATEGORY_NAME = "Naming";
    public static final String VIOLATION_PROPERTY = "Violation Entity";
    private static final String PATTERN_PROPERTY = "Pattern";
    static final String ENABLED_PARAMETER = "enabled";
    static final String PATTERNS_PARAMETER = "patterns";
    private static final int MAX_PATTERN_LENGTH_IN_MESSAGE = 100;
    private static final Set<String> DEFAULT_EXCLUDED_METHOD_SUBTYPES = CollectionUtils.asHashSet((Object[])new String[]{"operator", "operator declaration", "cast operator", "constructor", "destructor", "constructor declaration", "destructor declaration"});
    private final CodeScopeAware<ListMap<String, IndexFinding>> findings = CodeScopeAware.empty();
    private final String findingGroup;
    private final String findingCategory;
    @StepParameter(value="enabled")
    private CodeScopeAware<Boolean> enabled = CodeScopeAware.empty();
    @StepParameter(value="patterns")
    protected CodeScopeAware<Map<ENamingConventionTokenClass, Pattern>> patterns = CodeScopeAware.empty();
    protected final ELanguage language;
    private final Set<String> excludedMethodSubtypes;
    private StringOffsetTransformer offsetTransformer;
    private LineOffsetConverter rawLineOffsetConverter;

    protected NamingConventionAnalyzer(ELanguage language) {
        this.findingGroup = language.name();
        this.findingCategory = FINDINGS_CATEGORY_NAME;
        this.language = language;
        this.excludedMethodSubtypes = new HashSet<String>();
        this.excludedMethodSubtypes.addAll(DEFAULT_EXCLUDED_METHOD_SUBTYPES);
        this.excludedMethodSubtypes.addAll(this.getExcludedMethodSubTypes());
    }

    private @Nullable Pattern getPattern(CodeScopeName codeScope, ENamingConventionTokenClass tokenClass) {
        return (Pattern)((Map)this.patterns.getValue(codeScope)).get((Object)tokenClass);
    }

    public ELanguage getLanguage() {
        return this.language;
    }

    public void performAnalysis(Collection<TokenElementInfo> elements) throws StorageException {
        for (TokenElementInfo element : elements) {
            this.analyzeShallowEntities(element, (List<ShallowEntity>)element.getShallowEntitiesWithoutPreprocessorTokens());
        }
    }

    private void analyzeShallowEntities(TokenElementInfo element, List<ShallowEntity> entities) {
        CodeScopeName codeScope = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
        if (!((Boolean)this.enabled.getValue(codeScope)).booleanValue()) {
            return;
        }
        this.offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        this.rawLineOffsetConverter = new LineOffsetConverter(element.getText());
        for (ShallowEntity entity : ShallowEntityTraversalUtils.listAllEntities(entities)) {
            if (NamingConventionAnalyzer.isIgnoredEntity(entity)) continue;
            switch (entity.getType()) {
                case MODULE: {
                    this.checkEntityName(element, entity, NamingConventionGroup.create(this.language, ENamingConventionTokenClass.MODULES));
                    break;
                }
                case TYPE: {
                    this.checkType(element, entity);
                    break;
                }
                case METHOD: {
                    this.checkMethod(element, entity);
                    break;
                }
                case ATTRIBUTE: {
                    this.checkAttribute(element, entity);
                    break;
                }
                case META: {
                    this.checkMeta(element, entity);
                    break;
                }
                case STATEMENT: {
                    this.checkStatement(element, entity);
                    break;
                }
            }
        }
    }

    private static boolean isIgnoredEntity(ShallowEntity entity) {
        ELanguage language = TokenStreamUtils.getLanguage((Collection)entity.includedTokens());
        return entity.isEmpty() || entity.ownStartTokens().size() <= 1 && LanguageGroups.C_CPP_AND_MS_CLI.contains(language) && !entity.getSubtype().equals("typedef");
    }

    protected void checkType(TokenElementInfo element, ShallowEntity entity) {
        if ("anonymous class".equals(entity.getSubtype())) {
            return;
        }
        this.checkEntityName(element, entity, NamingConventionGroup.create(this.language, ENamingConventionTokenClass.TYPES));
    }

    protected void checkMethod(TokenElementInfo element, ShallowEntity entity) {
        if (!this.isIgnoredMethodType(entity)) {
            this.checkEntityName(element, entity, NamingConventionGroup.create(this.language, ENamingConventionTokenClass.METHODS));
        }
        this.checkMethodParameters(element, entity);
    }

    protected boolean isIgnoredMethodType(ShallowEntity entity) {
        return this.excludedMethodSubtypes.contains(entity.getSubtype()) || this.isOverride(entity);
    }

    protected Set<String> getExcludedMethodSubTypes() {
        return Collections.emptySet();
    }

    protected boolean isOverride(ShallowEntity entity) {
        return TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.OVERRIDE);
    }

    protected void checkMethodParameters(TokenElementInfo element, ShallowEntity entity) {
        for (IToken token : ShallowParsingUtils.extractParameterNameTokens((ShallowEntity)entity)) {
            this.checkTokenName(element, token, ENamingConventionTokenClass.METHOD_PARAMETERS);
        }
    }

    protected void checkAttribute(TokenElementInfo element, ShallowEntity entity) {
        if (this.isConstant(entity)) {
            this.checkNameWithMultipleVariables(element, entity, ENamingConventionTokenClass.CONSTANTS);
        } else if (NamingConventionAnalyzer.isGlobal(entity) && !NamingConventionAnalyzer.isClassStaticMemberVariable(entity)) {
            this.checkNameWithMultipleVariables(element, entity, ENamingConventionTokenClass.GLOBAL_VARIABLES);
        } else {
            this.checkNameWithMultipleVariables(element, entity, ENamingConventionTokenClass.ATTRIBUTES);
        }
    }

    private static boolean isClassStaticMemberVariable(ShallowEntity entity) {
        List variableTokens = ShallowParsingUtils.extractVariableNameTokens((List)entity.includedTokens());
        if (variableTokens.isEmpty()) {
            return false;
        }
        UnmodifiableList entityTokens = entity.ownStartTokens();
        int startVariableTokenIndex = TokenStreamUtils.indexOfByOffset((List)entityTokens, (int)((IToken)variableTokens.getFirst()).getOffset());
        return startVariableTokenIndex >= 2 && ((IToken)entityTokens.get(startVariableTokenIndex - 1)).getType() == ETokenType.SCOPE && CppShallowParser.VALID_IDENTIFIERS.matches((IToken)entityTokens.get(startVariableTokenIndex - 2));
    }

    protected boolean isConstant(ShallowEntity entity) {
        return TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.CONST);
    }

    protected static boolean isGlobal(ShallowEntity entity) {
        return entity.getParent() == null || entity.getParent().getType() == EShallowEntityType.MODULE;
    }

    protected void checkMeta(TokenElementInfo element, ShallowEntity entity) {
    }

    protected void checkStatement(TokenElementInfo element, ShallowEntity entity) {
        if (entity.getSubtype().equals("local variable")) {
            this.checkNameWithMultipleVariables(element, entity, ENamingConventionTokenClass.LOCAL_VARIABLES);
        }
        if (entity.getSubtype().equalsIgnoreCase(ETokenType.FOR.name())) {
            for (IToken token : ShallowParsingUtils.extractVariablesDeclaredInFor((ShallowEntity)entity)) {
                this.checkTokenName(element, token, ENamingConventionTokenClass.LOCAL_VARIABLES);
            }
        }
    }

    private void checkNameWithMultipleVariables(TokenElementInfo element, ShallowEntity entity, ENamingConventionTokenClass namingConventionClass) {
        for (IToken token : ShallowParsingUtils.extractVariableNameTokens((List)entity.includedTokens())) {
            this.checkTokenName(element, token, namingConventionClass);
        }
    }

    protected void checkEntityName(TokenElementInfo element, ShallowEntity entity, NamingConventionGroup namingConventionGroup) {
        if (!StringUtils.isEmpty((String)entity.getName())) {
            this.checkEntityWithGivenName(element, entity, entity.getName(), namingConventionGroup);
        }
    }

    protected void checkEntityWithGivenName(TokenElementInfo element, ShallowEntity entity, String name, NamingConventionGroup namingConventionGroup) {
        CodeScopeName codeScope = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
        Pattern pattern = this.getPattern(codeScope, namingConventionGroup.tokenClass);
        if (pattern != null && !pattern.matcher(name).matches()) {
            IndexFinding finding = this.createFindingForEntityStart(codeScope, NamingConventionAnalyzer.getMessage(name, pattern, namingConventionGroup), element, entity);
            NamingConventionAnalyzer.addFindingProperties(finding, namingConventionGroup, pattern);
        }
    }

    protected void checkTokenName(TokenElementInfo element, IToken token, ENamingConventionTokenClass namingConventionClass) {
        CodeScopeName codeScope = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
        Pattern pattern = this.getPattern(codeScope, namingConventionClass);
        if (pattern != null && !pattern.matcher(token.getText()).matches()) {
            NamingConventionGroup namingConventionGroup = NamingConventionGroup.create(this.language, namingConventionClass);
            IndexFinding finding = this.createFindingForFilteredOffsets(codeScope, NamingConventionAnalyzer.getMessage(token.getText(), pattern, namingConventionGroup), element, token.getOffset(), token.getEndOffset());
            NamingConventionAnalyzer.addFindingProperties(finding, namingConventionGroup, pattern);
        }
    }

    private static void addFindingProperties(IndexFinding finding, NamingConventionGroup namingConventionGroup, Pattern pattern) {
        finding.setProperty(VIOLATION_PROPERTY, (Object)namingConventionGroup.getReadableName());
        finding.setProperty(PATTERN_PROPERTY, (Object)pattern.pattern());
    }

    private IndexFinding createFindingForEntityStart(CodeScopeName codeScope, String message, TokenElementInfo element, ShallowEntity entity) {
        int endOffset = entity.ownStartTokens().isEmpty() ? (entity.includedTokens().isEmpty() ? entity.getEndOffset() : ((IToken)entity.includedTokens().getFirst()).getEndOffset()) : Objects.requireNonNull((IToken)CollectionUtils.getLast((List)entity.ownStartTokens())).getEndOffset();
        return this.createFindingForFilteredOffsets(codeScope, message, element, entity.getStartOffset(), endOffset);
    }

    private IndexFinding createFindingForFilteredOffsets(CodeScopeName codeScope, String message, TokenElementInfo element, int offset, int endOffset) {
        TextRegionLocation location = TextRegionLocationUtils.createTextRegionLocationForFilteredOffsets((String)element.getUniformPath(), (int)offset, (int)endOffset, (StringOffsetTransformer)this.offsetTransformer, (LineOffsetConverter)this.rawLineOffsetConverter);
        return this.createFinding(codeScope, element.getUniformPath(), message, (ElementLocation)location);
    }

    private static String getMessage(String name, Pattern pattern, NamingConventionGroup namingConventionGroup) {
        return "%s `%s` violates naming convention. Should match `%s`".formatted(namingConventionGroup.getFindingMessagePrefix(), name, StringUtils.truncateWithEllipsis((String)pattern.pattern(), (int)100));
    }

    @TestOnly
    public void setEnablement(CodeScopeName codeScope, boolean enablement) {
        this.enabled.setValue(codeScope, (Object)enablement);
    }

    @TestOnly
    public void setPattern(CodeScopeName codeScope, ENamingConventionTokenClass tokenClass, @Language(value="RegExp") String pattern) {
        ((Map)this.patterns.getOrComputeValue(codeScope, ignored -> new HashMap())).put(tokenClass, Pattern.compile(pattern));
    }

    @TestOnly
    public void setAllPatterns(CodeScopeName codeScope, @Language(value="RegExp") String pattern) {
        for (ENamingConventionTokenClass tokenClass : ENamingConventionTokenClass.values()) {
            this.setPattern(codeScope, tokenClass, pattern);
        }
    }

    public CodeScopeAware<ListMap<String, IndexFinding>> getFindings() {
        return this.findings;
    }

    protected IndexFinding createFinding(CodeScopeName codeScope, String uniformPath, String message, ElementLocation location) {
        IndexFinding finding = new IndexFinding(this.findingGroup, this.findingCategory, message, location);
        ((ListMap)this.findings.getOrComputeValue(codeScope, ignored -> new ListMap())).add((Object)uniformPath, (Object)finding);
        return finding;
    }
}

