/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.user.User;
import com.teamscale.index.notifications.ENotificationThresholdType;
import com.teamscale.index.notifications.INotificationRule;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationChecker;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import java.io.Serializable;
import java.util.HashSet;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class MetricNotificationRule
implements INotificationRule,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String RULE_NAME_PROPERTY = "ruleName";
    private static final String PROJECT_NAME_PROPERTY = "projectName";
    private static final String METRIC_NAME_PROPERTY = "metricName";
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String THRESHOLD_VALUE_PROPERTY = "thresholdValue";
    private static final String CURRENT_USER_PROPERTY = "currentUser";
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="projectName")
    private final String projectName;
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="thresholdValue")
    private final String thresholdValue;
    @JsonProperty(value="uniformPath")
    private final @Nullable String uniformPath;
    @JsonProperty(value="currentUser")
    private final User currentUser;

    @JsonCreator
    protected MetricNotificationRule(@JsonProperty(value="ruleName") String ruleName, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="metricName") String metricName, @JsonProperty(value="thresholdValue") String thresholdValue, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="currentUser") User currentUser) {
        this.ruleName = ruleName;
        this.projectName = projectName;
        this.metricName = metricName;
        this.thresholdValue = thresholdValue;
        this.uniformPath = uniformPath;
        this.currentUser = currentUser;
    }

    public NotificationThresholdViolationInfo matches(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException {
        MetricDirectorySchema schema = MetricRetrievalStrategyFactory.getStrategy(UniformPathCompatibilityUtil.convert((String)this.uniformPath).getType(), (ProjectStorageSystem)notificationContext.getProjectStorageSystem(), notificationContext.getGlobalStorageSystem(), this.currentUser, notificationContext.getSchemaRetrieverFactory()).getMetricDirectorySchema();
        int entryValuePosition = schema.getValuePosition(this.metricName);
        if (entryValuePosition < 0) {
            throw new InvalidNotificationRuleException(this, "Could not find the metric '" + this.metricName + "' on the path '" + this.uniformPath + "'.");
        }
        MetricDirectorySchemaEntry schemaEntry = schema.getEntry(entryValuePosition);
        EMetricValueType valueType = schemaEntry.getValueType();
        if (valueType == EMetricValueType.ASSESSMENT) {
            return this.matchesAssessment(notificationContext);
        }
        if (valueType == EMetricValueType.NUMERIC) {
            return this.matchesNumeric(notificationContext);
        }
        throw new InvalidNotificationRuleException(this, "Rule contains unsupported value type: '" + String.valueOf(valueType) + "'.");
    }

    private NotificationThresholdViolationInfo matchesNumeric(NotificationContext notificationContext) throws StorageException {
        NotificationThresholdViolationChecker valueChecker = new NotificationThresholdViolationChecker(this.metricName, this.uniformPath, notificationContext, new HashSet<EThresholdEvaluationOption>(), this.currentUser);
        return valueChecker.doesViolateConstantThreshold(this.getThresholdAsDouble(), ENotificationThresholdType.VALUE);
    }

    private NotificationThresholdViolationInfo matchesAssessment(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException {
        NotificationThresholdViolationChecker checker = new NotificationThresholdViolationChecker(this.metricName, this.uniformPath, notificationContext, new HashSet<EThresholdEvaluationOption>(), this.currentUser);
        NotificationThresholdViolationInfo redInfo = checker.doesViolateConstantThreshold(this.extractRedThreshold(), ENotificationThresholdType.RED);
        if (redInfo.isViolated()) {
            return redInfo;
        }
        return checker.doesViolateConstantThreshold(this.extractYellowThreshold(), ENotificationThresholdType.YELLOW);
    }

    private Double getThresholdAsDouble() {
        return Double.parseDouble(this.thresholdValue.trim());
    }

    private Double extractRedThreshold() throws InvalidNotificationRuleException {
        return this.extractThresholdValue(ENotificationThresholdType.RED);
    }

    private Double extractYellowThreshold() throws InvalidNotificationRuleException {
        return this.extractThresholdValue(ENotificationThresholdType.YELLOW);
    }

    private double extractThresholdValue(ENotificationThresholdType thresholdType) throws InvalidNotificationRuleException {
        String[] splitThreshold = this.thresholdValue.split(",");
        if (splitThreshold.length < 2) {
            throw new InvalidNotificationRuleException(this, "Threshold value '" + this.thresholdValue + "' does not have the desired format: (<yellow threshold>, <red threshold>)");
        }
        return switch (thresholdType) {
            case ENotificationThresholdType.RED -> Double.parseDouble(splitThreshold[0].trim());
            case ENotificationThresholdType.YELLOW -> Double.parseDouble(splitThreshold[1].trim());
            default -> throw new InvalidNotificationRuleException(this, "Threshold type '" + String.valueOf((Object)thresholdType) + "' is not supported.");
        };
    }

    public String getPath() {
        return this.uniformPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getThresholdValue() {
        return this.thresholdValue;
    }

    @VisibleForTesting
    public User getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }
}

