/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.user.User;
import com.teamscale.index.notifications.ENotificationThresholdType;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationChecker;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.project.ProjectNotificationRule;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ProjectNotificationRuleWithConfiguration
extends ProjectNotificationRule {
    private static final long serialVersionUID = 1L;
    private static final String THRESHOLD_CONFIGURATION_NAME_PROPERTY = "thresholdConfigurationName";
    private static final String GROUP_NAME_PROPERTY = "groupName";
    @JsonProperty(value="thresholdConfigurationName")
    private final String thresholdConfigurationName;
    @JsonProperty(value="groupName")
    private final String groupName;

    @JsonCreator
    protected ProjectNotificationRuleWithConfiguration(@JsonProperty(value="ruleName") String ruleName, @JsonProperty(value="projectNames") Set<String> projectNames, @JsonProperty(value="thresholdConfigurationName") String thresholdConfigurationName, @JsonProperty(value="groupName") String groupName, @JsonProperty(value="metricDisplayName") String metricDisplayName, @JsonProperty(value="type") ENotificationThresholdType type, @JsonProperty(value="thresholdValue") Double thresholdValue, @JsonProperty(value="recipientUsers") List<String> recipientUsers, @JsonProperty(value="recipientGroups") List<String> recipientGroups, @JsonProperty(value="currentUser") User currentUser) {
        super(ruleName, projectNames, metricDisplayName, thresholdValue, type, recipientUsers, recipientGroups, currentUser);
        this.thresholdConfigurationName = thresholdConfigurationName;
        this.groupName = groupName;
    }

    @Override
    protected NotificationThresholdViolationInfo doesViolateThreshold(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException {
        MetricThresholdConfiguration configuration = this.retrieveMetricThresholdConfiguration(notificationContext);
        try {
            MetricThreshold threshold = (MetricThreshold)configuration.findThreshold(this.groupName, this.getMetricDisplayName()).orElseThrow(() -> new InvalidNotificationRuleException(this, "The configuration group '" + this.groupName + "' does not contain the metric '" + this.getMetricDisplayName() + "'."));
            String metricName = threshold.getMetricName();
            String subPath = threshold.getSubPath();
            NotificationThresholdViolationChecker checker = this.createNotificationThresholdViolationChecker(metricName, StringUtils.emptyIfNull((String)subPath), notificationContext, threshold.getEvaluationOptions(), this.currentUser);
            checker.setAssessmentSpecification(threshold.getAssessmentSpecification());
            return checker.doesViolateTimeDependentThreshold(configuration, threshold.getDisplayName(), this.groupName, this.getType());
        }
        catch (MetricThresholdConfigurationException e) {
            throw new InvalidNotificationRuleException(this, "Rule contains invalid threshold configuration.", e);
        }
    }

    private MetricThresholdConfiguration retrieveMetricThresholdConfiguration(NotificationContext notificationContext) throws StorageException, InvalidNotificationRuleException {
        MetricThresholdConfigurationIndex metricThresholdConfigurationIndex = this.openMetricThresholdConfigurationIndex(notificationContext);
        MetricThresholdConfiguration configuration = metricThresholdConfigurationIndex.getConfiguration(this.thresholdConfigurationName);
        if (configuration == null) {
            throw new InvalidNotificationRuleException(this, "Threshold configuration '" + this.thresholdConfigurationName + "' could not be found.");
        }
        return configuration;
    }

    protected MetricThresholdConfigurationIndex openMetricThresholdConfigurationIndex(NotificationContext notificationContext) throws StorageException {
        return (MetricThresholdConfigurationIndex)notificationContext.getGlobalStorageSystem().openGlobalIndex(MetricThresholdConfigurationIndex.class);
    }

    @Override
    public void checkValidity() throws InvalidNotificationRuleException {
        super.checkValidity();
        if (this.thresholdConfigurationName == null) {
            throw new InvalidNotificationRuleException(this, "The rule must provide the name of the threshold configuration.");
        }
        if (this.groupName == null) {
            throw new InvalidNotificationRuleException(this, "The rule must provide the name of the threshold configuration group.");
        }
    }
}

