/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.DiffInfo;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SelfContainedFinding;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.WrappedLogEntry;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class FindingDetailSlide
extends ReportSlideBase<FindingDetailSlideParameters, FindingDetailSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.FINDING_DETAIL;
    }

    @IndexValueClass(containedInBackup=true)
    public static class SiblingInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="siblingId")
        private final String siblingId;
        @JsonProperty(value="originalId")
        private final String originalId;

        @JsonCreator
        public SiblingInfo(@JsonProperty(value="siblingId") String siblingId, @JsonProperty(value="originalId") String originalId) {
            this.siblingId = siblingId;
            this.originalId = originalId;
        }

        public String getSiblingId() {
            return this.siblingId;
        }
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    private static enum ECodeRenderOption {
        WITH_SCROLLBARS("Scrollbars"),
        BREAK_INTO_MULTIPLE_PARTS("Stack code snippets");

        @JsonProperty(value="uiLabel")
        private String uiLabel;

        private ECodeRenderOption(String uiLabel) {
            this.uiLabel = uiLabel;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class CodeRange
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_START = "startLine";
        private static final String PROPERTY_END = "endLine";
        @JsonProperty(value="startLine")
        private String startLine = "";
        @JsonProperty(value="endLine")
        private String endLine = "";

        @JsonCreator
        public CodeRange(@JsonProperty(value="startLine") String startLine, @JsonProperty(value="endLine") String endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }

        public String getStartLine() {
            return this.startLine;
        }

        public String getEndLine() {
            return this.endLine;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class FindingDetailSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_FINDING = "finding";
        private static final String PROPERTY_LOG_ENTRY = "logEntry";
        private static final String PROPERTY_REPORT_END_COMMIT = "reportEndCommit";
        private static final String PROPERTY_CODE_RANGE = "codeRange";
        private static final String PROPERTY_DIFF_INFO = "diffInfo";
        private static final String PROPERTY_SIBLING_FINDING = "siblingFinding";
        private static final String PROPERTY_COMMENTS = "comments";
        @JsonProperty(value="finding")
        private @Nullable SelfContainedFinding finding;
        @JsonProperty(value="diffInfo")
        private @Nullable DiffInfo diffInfo;
        @JsonProperty(value="logEntry")
        private @Nullable WrappedLogEntry logEntry;
        @JsonProperty(value="reportEndCommit")
        private CommitDescriptor reportEndCommit;
        @JsonProperty(value="siblingFinding")
        private final @Nullable String siblingFinding;
        @JsonProperty(value="codeRange")
        private @Nullable CodeRange codeRange;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public FindingDetailSlideResult(@JsonProperty(value="finding") @Nullable SelfContainedFinding finding, @JsonProperty(value="logEntry") @Nullable WrappedLogEntry logEntry, @JsonProperty(value="reportEndCommit") CommitDescriptor reportEndCommit, @JsonProperty(value="siblingFinding") @Nullable String siblingFinding, @JsonProperty(value="codeRange") @Nullable CodeRange codeRange, @JsonProperty(value="diffInfo") @Nullable DiffInfo diffInfo, @JsonProperty(value="comments") @Nullable List<SlideCommentRenderData> comments) {
            this.finding = finding;
            this.logEntry = logEntry;
            this.reportEndCommit = reportEndCommit;
            this.codeRange = codeRange;
            this.diffInfo = diffInfo;
            this.siblingFinding = siblingFinding;
            this.comments = comments;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class FindingDetailSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projectBranchPath")
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        private ProjectBranchPath projectBranchPath;
        @JsonProperty(value="findingId")
        @SlideParameter(formattedName="Finding ID", type=ESlideOptionType.SINGLE_FINDING, inputHint="Can be copied on finding details view")
        private @Nullable String findingId;
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @SlideParameter(formattedName="Code font size", type=ESlideOptionType.SIZE)
        @JsonProperty(value="codeFontSize")
        private int codeFontSize;
        @SlideParameter(formattedName="Overflow mode", type=ESlideOptionType.ONE_OF_ENUM_SELECTION)
        @JsonProperty(value="codeRenderMode")
        private ECodeRenderOption codeRenderMode;
        @SlideParameter(formattedName="Show introduction/removal commit", type=ESlideOptionType.BOOLEAN)
        @JsonProperty(value="showIntroOrRemovalCommit")
        private boolean showIntroOrRemovalCommit;
        @SlideParameter(formattedName="Show introduction/removal diff", type=ESlideOptionType.BOOLEAN)
        @JsonProperty(value="showIntroOrRemovalDiff")
        private boolean showIntroOrRemovalDiff;
        @JsonProperty(value="siblingInfo")
        @SlideParameter(formattedName="Compare with", type=ESlideOptionType.CLONE_SIBLING)
        private @Nullable SiblingInfo siblingInfo;
        @SlideParameter(formattedName="Code range", type=ESlideOptionType.CODE_RANGE)
        @JsonProperty(value="codeRange")
        private @Nullable CodeRange codeRange;
        @JsonProperty(value="comments")
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        private List<ISlideComment> comments;

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public @Nullable String getFindingId() {
            return this.findingId;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public int getCodeFontSize() {
            return this.codeFontSize;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public boolean showIntroOrRemovalDiff() {
            return this.showIntroOrRemovalDiff;
        }

        public CodeRange getCodeRange() {
            if (this.codeRange == null) {
                return new CodeRange("", "");
            }
            return this.codeRange;
        }

        public @Nullable SiblingInfo getSiblingInfo() {
            return this.siblingInfo;
        }

        public String getSiblingId() {
            if (this.siblingInfo == null) {
                return null;
            }
            return this.siblingInfo.getSiblingId();
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }
    }
}

