/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.index.metrics.assessment.MetricOverride;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass(containedInBackup=true)
public class SystemQualityOverviewSlide
extends ReportSlideBase<SystemQualityOverviewSlideParameters, SystemQualityOverviewSlideResult> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_SLIDE_TITLE = "System Quality Overview";

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.SYSTEM_QUALITY_OVERVIEW;
    }

    @Override
    protected void resetUserOverwrites() {
        ((SystemQualityOverviewSlideParameters)this.getSlideParameters()).metricOverrides.clear();
    }

    @IndexValueClass(containedInBackup=true)
    public static class SystemQualityOverviewSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        @JsonProperty(value="projectBranchPath")
        private ProjectBranchPath projectBranchPath = new ProjectBranchPath("", (UniformPath)UniformPath.codeRoot(), "");
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        @JsonProperty(value="slideTitle")
        private String slideTitle;
        @SlideParameter(formattedName="Metric(s)", inputHint="Maximum 10 lines in one column", type=ESlideOptionType.THRESHOLD_PROFILE_METRIC)
        @JsonProperty(value="metricNames")
        private List<String> metricNames;
        @SlideParameter(formattedName="Metric Overrides", type=ESlideOptionType.METRIC_OVERRIDE)
        @JsonProperty(value="metricOverrides")
        private List<MetricOverride> metricOverrides;
        @SlideParameter(formattedName="Include", inputHint="Select options", type=ESlideOptionType.MULTISELECT_SYSTEM_QUALITY_OVERVIEW)
        @JsonProperty(value="includeOptions")
        private List<ESystemQualityOverviewSlideOption> includeOptions;
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        @JsonProperty(value="comments")
        private List<ISlideComment> comments;

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<String> getMetricNames() {
            return this.metricNames;
        }

        public List<MetricOverride> getMetricOverrides() {
            return this.metricOverrides;
        }

        public List<ESystemQualityOverviewSlideOption> getIncludeOptions() {
            return this.includeOptions;
        }

        @JsonCreator
        SystemQualityOverviewSlideParameters() {
        }

        @VisibleForTesting
        public SystemQualityOverviewSlideParameters(ProjectBranchPath projectBranchPath, String slideTitle, List<String> metricNames, List<MetricOverride> metricOverrides, List<ESystemQualityOverviewSlideOption> includeOptions, List<ISlideComment> comments) {
            this.projectBranchPath = projectBranchPath;
            this.slideTitle = slideTitle;
            this.metricNames = metricNames;
            this.metricOverrides = metricOverrides;
            this.includeOptions = includeOptions;
            this.comments = comments;
        }

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum ESystemQualityOverviewSlideOption {
        INCLUDE_ASSESSMENTS("KPI Assessments"),
        INCLUDE_METRIC_VALUES("Metric values"),
        INCLUDE_TREND_DELTA("Trend delta");

        private final String readableName;

        private ESystemQualityOverviewSlideOption(String readableName) {
            this.readableName = readableName;
        }

        public String getReadableName() {
            return this.readableName;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class SystemQualityOverviewSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        private static final String PROPERTY_ASSESSMENTS = "assessments";
        private static final String PROPERTY_COMMENTS = "comments";
        @JsonProperty(value="assessments")
        private List<GroupAssessment> assessments;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public SystemQualityOverviewSlideResult(@JsonProperty(value="assessments") List<GroupAssessment> assessments, @JsonProperty(value="comments") List<SlideCommentRenderData> comments) {
            this.assessments = assessments;
            this.comments = comments;
        }

        public List<SlideCommentRenderData> getComments() {
            return this.comments;
        }

        public List<GroupAssessment> getAssessments() {
            return this.assessments;
        }
    }
}

