/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.store.StorageException;

public abstract class ReplacePreprocessorBase
implements IQueryPreprocessor {
    protected abstract String getKeyword();

    protected abstract int insertReplacement(int var1, List<QueryToken> var2, List<QueryToken> var3, Set<String> var4) throws StorageException, QueryParsingException;

    public List<QueryToken> preprocessQuery(List<QueryToken> tokens) throws QueryParsingException, StorageException {
        return this.preprocessQuery(tokens, new HashSet<String>());
    }

    private List<QueryToken> preprocessQuery(List<QueryToken> tokens, Set<String> encounteredValues) throws QueryParsingException, StorageException {
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            QueryToken token = tokens.get(i);
            if (this.isKeyword(token)) {
                i += this.insertReplacement(i, tokens, result, new HashSet<String>(encounteredValues));
                continue;
            }
            result.add(token);
        }
        return result;
    }

    private boolean isKeyword(QueryToken token) {
        return token.getType() == EQueryTokenType.LITERAL && this.getKeyword().equalsIgnoreCase(token.getText());
    }

    static String extractParameterName(List<QueryToken> tokens, int start, String errorContext) throws QueryParsingException {
        ReplacePreprocessorBase.assertTokenType(tokens, start, EQueryTokenType.PAREN_OPEN, errorContext);
        ReplacePreprocessorBase.assertTokenType(tokens, start + 1, EQueryTokenType.LITERAL, errorContext);
        ReplacePreprocessorBase.assertTokenType(tokens, start + 2, EQueryTokenType.PAREN_CLOSE, errorContext);
        return tokens.get(start + 1).getText();
    }

    private static void assertTokenType(List<QueryToken> tokens, int index, EQueryTokenType expectedType, String errorContext) throws QueryParsingException {
        if (index >= tokens.size() || tokens.get(index).getType() != expectedType) {
            throw new QueryParsingException("Expected token type " + String.valueOf(expectedType) + " after " + errorContext, new QueryToken[0]);
        }
    }
}

