/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.external.input.SimulinkFindingLocationAdjuster;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMultiFileRangeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.report.AnalysisReportIntegratorBase;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.ParsedReportIndex;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.GeneralReportContentIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.ReportPartitionOriginIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class AnalysisReportIntegrator
extends AnalysisReportIntegratorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_PARTITION = "external-data-imported-from-repository";
    public static final String DISABLE_PLAUSIBILITY_CHECK_FOR_PATH_MAPPING = "disable-plausibility-check";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private GeneralReportContentIndex reportContentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ReportPartitionOriginIndex reportPartitionOriginIndex;
    @DeltaSource(value=GeneralReportContentIndex.class)
    private KeyDelta reportContentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ParsedReportIndex parsedReportIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SimulinkModelInfoIndex simulinkModelInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisStatusIndex statusIndex;
    @StepParameter(value="disable-plausibility-check")
    private boolean disablePlausibilityCheckForPathMapping;
    private final Set<String> updatedPartitions = Collections.synchronizedSet(new HashSet());
    private final Set<String> allReportPartitions = Collections.synchronizedSet(new HashSet());
    private final Set<EReportFormat> allReportFormats = Collections.synchronizedSet(EnumSet.noneOf(EReportFormat.class));

    @Override
    public void executeReportIntegration() throws StorageException, ExecutionException {
        List changedPaths = this.reportContentDelta.getAddedOrChangedKeysAsStrings();
        TokenElementIndexCache tokenElementIndexCache = new TokenElementIndexCache(this.tokenElementIndex, Collections.emptyList());
        try {
            ConcurrentHashMap parsedReportNames = new ConcurrentHashMap();
            this.executeInParallelBatches(changedPaths, uniformPaths -> this.processReportsForPaths(tokenElementIndexCache, (List<String>)uniformPaths, parsedReportNames), 1);
            this.removeDeletedReports();
            AnalysisReportIntegrator.reportStatus(null, this.allReportPartitions, this.allReportFormats, this.getSchedulingCommit(), this.statusIndex);
        }
        catch (Throwable t) {
            AnalysisReportIntegrator.reportStatus(t, this.allReportPartitions, this.allReportFormats, this.getSchedulingCommit(), this.statusIndex);
            throw t;
        }
    }

    private void processReportsForPaths(TokenElementIndexCache tokenElementIndexCache, List<String> changedPaths, ConcurrentHashMap<String, Object> parsedReportNames) throws StorageException {
        PairList<String, ParsedReportIndex.ParsedReport> parsedReports = this.parseReportContents(tokenElementIndexCache, changedPaths);
        if (!parsedReports.isEmpty()) {
            this.parsedReportIndex.setReports(parsedReports);
            parsedReports.forEach((uniformPath, parsedReport) -> parsedReportNames.putIfAbsent((String)uniformPath, new Object()));
        }
    }

    private @NonNull PairList<String, ParsedReportIndex.ParsedReport> parseReportContents(TokenElementIndexCache tokenElementIndexCache, List<String> changedPaths) throws StorageException {
        List<ReportContentIndexBase.ReportContent> contents = this.reportContentIndex.getReportContents(changedPaths);
        for (ReportContentIndexBase.ReportContent content : contents) {
            this.allReportPartitions.add(content.getPartitionOrElse(DEFAULT_PARTITION));
            this.allReportFormats.add(content.format);
        }
        PairList parsedReports = new PairList();
        for (int i = 0; i < changedPaths.size(); ++i) {
            String reportPath = changedPaths.get(i);
            ReportContentIndexBase.ReportContent reportContent = contents.get(i);
            try {
                Optional<ExternalAnalysisImportInfos> optionalImportInfos = this.parseReport(reportPath, reportContent, tokenElementIndexCache, this.disablePlausibilityCheckForPathMapping);
                optionalImportInfos.ifPresent(importInfos -> parsedReports.add((Object)reportPath, (Object)new ParsedReportIndex.ParsedReport((ExternalAnalysisImportInfos)importInfos, reportContent.connectorId)));
                continue;
            }
            catch (ReportParserException e) {
                AnalysisReportIntegrator.reportStatus(e, this.allReportPartitions, this.allReportFormats, this.getSchedulingCommit(), this.statusIndex);
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to parse report '{}'. Skipping this report.", (Object)reportPath);
            }
        }
        return parsedReports;
    }

    private void removeDeletedReports() throws StorageException {
        Map<String, ReportPartitionOriginIndex.ReportPartitionOrigin> allReportPartitionOrigins = this.reportPartitionOriginIndex.loadAllPartitionOrigins();
        HashSet<String> reportsToDelete = new HashSet<String>();
        HashSet unknownPartitions = CollectionUtils.differenceSet(this.updatedPartitions, (Collection[])new Collection[]{allReportPartitionOrigins.keySet()});
        if (!unknownPartitions.isEmpty()) {
            reportsToDelete.addAll(this.logUnknownPartitionOriginsAndReturnDeletedReports(unknownPartitions));
        }
        boolean projectHasOnlyOnePartition = allReportPartitionOrigins.size() == 1;
        for (ReportPartitionOriginIndex.ReportPartitionOrigin partitionOrigin : allReportPartitionOrigins.values()) {
            String partitionName = partitionOrigin.partitionName();
            ReportPartitionOriginIndex.EReportDeletionBehavior reportDeletionBehavior = partitionOrigin.reportDeletionBehavior();
            reportsToDelete.addAll(this.determineReportsToDeleteFromPartition(partitionName, reportDeletionBehavior, projectHasOnlyOnePartition));
        }
        this.parsedReportIndex.removeReports(new ArrayList<String>(reportsToDelete));
    }

    private @NonNull Set<String> determineReportsToDeleteFromPartition(String partitionName, ReportPartitionOriginIndex.EReportDeletionBehavior reportDeletionBehavior, boolean projectHasOnlyOnePartition) throws StorageException {
        return switch (reportDeletionBehavior) {
            default -> throw new MatchException(null, null);
            case ReportPartitionOriginIndex.EReportDeletionBehavior.REMOVE_ALL_DELETED_REPORTS -> this.determineAllReportsDeletedInCommit(partitionName, projectHasOnlyOnePartition);
            case ReportPartitionOriginIndex.EReportDeletionBehavior.IGNORE_REPORT_DELETION_IN_PARTITION_WITHOUT_ADDITIONS_OR_CHANGES -> {
                if (this.updatedPartitions.contains(partitionName)) {
                    Set unchangedReportsPathsInPartition = this.parsedReportIndex.getAllReportsForPartition(partitionName).orElseGet(Collections::emptySet);
                    List addedOrChangedReportPaths = this.reportContentDelta.getAddedOrChangedKeysAsStrings();
                    unchangedReportsPathsInPartition.removeIf(addedOrChangedReportPaths::contains);
                    yield unchangedReportsPathsInPartition;
                }
                yield Collections.emptySet();
            }
        };
    }

    private Set<String> logUnknownPartitionOriginsAndReturnDeletedReports(HashSet<String> unknownPartitions) throws StorageException {
        HashSet<String> reportsToDelete = new HashSet<String>();
        LOGGER.error("Found no partition origin for partitions '{}'. Assuming that we should remove deleted reports.", (Object)String.join((CharSequence)",", unknownPartitions));
        for (String partitionName : unknownPartitions) {
            reportsToDelete.addAll(this.determineAllReportsDeletedInCommit(partitionName, false));
        }
        return reportsToDelete;
    }

    private Set<String> determineAllReportsDeletedInCommit(String partitionName, boolean projectHasOnlyOnePartition) throws StorageException {
        HashSet<String> reportsToDelete = new HashSet<String>();
        if (projectHasOnlyOnePartition) {
            reportsToDelete.addAll(this.reportContentDelta.getDeletedKeysAsStrings());
        } else {
            Set allReportsPathsInPartition = this.parsedReportIndex.getAllReportsForPartition(partitionName).orElseGet(Collections::emptySet);
            reportsToDelete.addAll(CollectionUtils.intersectionSet((Collection)allReportsPathsInPartition, (Collection[])new Collection[]{this.reportContentDelta.getDeletedKeysAsStrings()}));
        }
        return reportsToDelete;
    }

    static void reportStatus(Throwable error, Set<String> partitions, Set<EReportFormat> formats, CommitDescriptor commit, ExternalAnalysisStatusIndex statusIndex) throws StorageException {
        statusIndex.runWithLock(lockedIndex -> AnalysisReportIntegrator.reportStatus(lockedIndex, error, partitions, formats, commit));
    }

    private static void reportStatus(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndex, Throwable error, Set<String> partitions, Set<EReportFormat> formats, CommitDescriptor commit) throws StorageException {
        ExternalAnalysisStatusInfo oldStatus = lockedIndex.getStatus(commit);
        ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(commit, false, 0L, false));
        status.addPartitions(partitions);
        ExternalAnalysisProcessingStepInfo step = AnalysisReportIntegrator.createStepInfo(EExternalAnalysisProcessingStatus.QUEUED, error);
        step.addMessage("Formats: " + StringUtils.concat(formats, (String)", "));
        status.addProcessingStep(step);
        lockedIndex.updateStatusWithKnownOldStatus(oldStatus, status);
    }

    private Optional<ExternalAnalysisImportInfos> parseReport(String reportPath, ReportContentIndexBase.ReportContent reportContent, TokenElementIndexCache tokenElementIndexCache, boolean disablePlausibilityCheckForPathMapping) throws ReportParserException {
        IReportParser parser = this.createAndInitParser(reportContent, tokenElementIndexCache, disablePlausibilityCheckForPathMapping);
        parser.parse(reportContent, reportPath);
        ExternalAnalysisImportInfos importInfosFromParser = parser.getInfos();
        ExternalAnalysisImportInfos processedImportInfos = new ExternalAnalysisImportInfos();
        importInfosFromParser.getInfos().forEach(processedImportInfos::addInfo);
        AnalysisReportIntegrator.convertTestWiseToLineCoverage(importInfosFromParser, processedImportInfos);
        for (ExternalAnalysisImportInfoLineCoverage info : processedImportInfos.filterByType(ExternalAnalysisImportInfoLineCoverage.class)) {
            info.getData().setUploadCommitTimestamp(this.getSchedulingCommit().getTimestamp());
        }
        this.correctSimulinkLocations(processedImportInfos);
        String partition = reportContent.getPartitionOrElse(DEFAULT_PARTITION);
        this.updatedPartitions.add(partition);
        for (ExternalAnalysisImportInfo info : processedImportInfos.getInfos()) {
            info.setPartition(partition);
        }
        return Optional.of(processedImportInfos);
    }

    private static void convertTestWiseToLineCoverage(ExternalAnalysisImportInfos importInfosFromParser, ExternalAnalysisImportInfos processedImportInfos) {
        HashMap<String, LineCoverageInfo> aggregatedLineCoverageByOriginalPath = new HashMap<String, LineCoverageInfo>();
        for (ExternalAnalysisImportInfoMultiFileRangeCoverage testwiseInfo : importInfosFromParser.filterByType(ExternalAnalysisImportInfoMultiFileRangeCoverage.class)) {
            testwiseInfo.appendLineCoverageTo(aggregatedLineCoverageByOriginalPath);
        }
        aggregatedLineCoverageByOriginalPath.forEach((originalPath, lineCoverage) -> processedImportInfos.addInfo(new ExternalAnalysisImportInfoLineCoverage((String)originalPath, (LineCoverageInfo)lineCoverage)));
    }

    private void correctSimulinkLocations(ExternalAnalysisImportInfos externalAnalysisImportInfos) {
        IdentityHashSet findingsToRelocate = new IdentityHashSet();
        List<ExternalAnalysisImportInfoFindings> findingInfos = externalAnalysisImportInfos.filterByType(ExternalAnalysisImportInfoFindings.class);
        for (ExternalAnalysisImportInfoFindings findings : findingInfos) {
            Iterator iterator = findings.getData().iterator();
            while (iterator.hasNext()) {
                DetachedFinding finding = (DetachedFinding)iterator.next();
                ElementLocation findingLocation = finding.getLocation();
                if (!SimulinkUtils.isSimulinkModelPath((String)findingLocation.getUniformPath()) || !(findingLocation instanceof QualifiedNameLocation)) continue;
                finding.setLocation(SimulinkFindingLocationAdjuster.correctSimulinkLocation((QualifiedNameLocation)findingLocation, this.simulinkModelInfoIndex));
                if (findings.getUniformPath().equals(finding.getLocation().getUniformPath())) continue;
                findingsToRelocate.add(finding);
            }
        }
        AnalysisReportIntegrator.relocateFindings((Set<DetachedFinding>)findingsToRelocate, externalAnalysisImportInfos);
    }

    private static void relocateFindings(Set<DetachedFinding> findingsToRelocate, ExternalAnalysisImportInfos externalAnalysisImportInfos) {
        if (findingsToRelocate.isEmpty()) {
            return;
        }
        List<ExternalAnalysisImportInfoFindings> findingInfos = externalAnalysisImportInfos.filterByType(ExternalAnalysisImportInfoFindings.class);
        for (ExternalAnalysisImportInfoFindings findings : findingInfos) {
            findings.retainMatching(finding -> !findingsToRelocate.contains(finding));
        }
        Map pathToFindings = findingInfos.stream().collect(Collectors.toMap(ExternalAnalysisImportInfo::getUniformPath, Function.identity()));
        for (DetachedFinding finding2 : findingsToRelocate) {
            String uniformPath = finding2.getLocation().getUniformPath();
            ExternalAnalysisImportInfoFindings info = (ExternalAnalysisImportInfoFindings)pathToFindings.get(uniformPath);
            if (info == null) {
                info = new ExternalAnalysisImportInfoFindings(uniformPath, Collections.emptyList());
                externalAnalysisImportInfos.addInfo(info);
                pathToFindings.put(uniformPath, info);
            }
            info.addFinding(finding2);
        }
    }

    public static ExternalAnalysisProcessingStepInfo createStepInfo(EExternalAnalysisProcessingStatus successStatus, @Nullable Throwable error) {
        boolean processingSuccess = error == null;
        ExternalAnalysisProcessingStepInfo step = new ExternalAnalysisProcessingStepInfo(AnalysisReportIntegrator.getStatus(successStatus, processingSuccess), processingSuccess);
        if (error != null) {
            step.addMessage("Fatal: " + error.getMessage());
        }
        return step;
    }

    private static EExternalAnalysisProcessingStatus getStatus(EExternalAnalysisProcessingStatus successStatus, boolean processingSuccess) {
        if (processingSuccess) {
            return successStatus;
        }
        return EExternalAnalysisProcessingStatus.FAILED;
    }
}

