/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.astree.AstreeReportParser;
import com.teamscale.index.report.coverage.GenericCoverageReportParserInvoker;
import com.teamscale.index.report.coverage.JaCoCoReportParserInvoker;
import com.teamscale.index.report.coverage.MsCoverageReportParser;
import com.teamscale.index.report.coverage.OpenCoverCoverageReportParser;
import com.teamscale.index.report.coverage.RawTestwiseReportParser;
import com.teamscale.index.report.coverage.SapCoverageReportParser;
import com.teamscale.index.report.coverage.TeamscaleCompactCoverageReportParserInvoker;
import com.teamscale.index.report.coverage.XrBaboonReportParser;
import com.teamscale.index.report.coverage.bullseye.BullseyeReportParser;
import com.teamscale.index.report.coverage.testwise_coverage.TestwiseCoverageReportParser;
import com.teamscale.index.report.cppcheck.CppcheckReportParser;
import com.teamscale.index.report.generic.GenericExternalFindingsParser;
import com.teamscale.index.report.generic.GenericNonCodeMetricsParser;
import com.teamscale.index.report.parser.CSCompilerWarningsParser;
import com.teamscale.index.report.parser.ClangReportParser;
import com.teamscale.index.report.parser.ClangXCResultJsonReportParser;
import com.teamscale.index.report.parser.CompilationDatabaseReportParser;
import com.teamscale.index.report.parser.FindbugsReportParser;
import com.teamscale.index.report.parser.FxCopReportParser;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.report.parser.IssueCsvReportParser;
import com.teamscale.index.report.parser.JQAssistantReportParser;
import com.teamscale.index.report.parser.ModelAdvisorReportParser;
import com.teamscale.index.report.parser.MypyReportParser;
import com.teamscale.index.report.parser.PCLintReportParser;
import com.teamscale.index.report.parser.ParasoftCppTestReportParser;
import com.teamscale.index.report.parser.PreparsedReportParser;
import com.teamscale.index.report.parser.PyLintReportParser;
import com.teamscale.index.report.parser.SimulinkMatFileReportParser;
import com.teamscale.index.report.parser.SpecItemCsvReportParser;
import com.teamscale.index.report.parser.fortify.FortifyReportParser;
import com.teamscale.index.report.parser.sap_code_inspector.CodeInspectorJsonParser;
import com.teamscale.index.report.parser.sonarqube.SonarqubeReportParser;
import com.teamscale.index.report.roslyn.RoslynReportParser;
import com.teamscale.index.report.testexecution.boost.BoostReportParser;
import com.teamscale.index.report.testexecution.junit.JUnitReportParser;
import com.teamscale.index.report.testexecution.mstest.MsTestReportParser;
import com.teamscale.index.report.testexecution.nunit.NUnitReportParser;
import com.teamscale.index.report.testexecution.xcresult.XCResultJsonReportParser;
import com.teamscale.index.report.testexecution.xunit.XUnitReportParser;
import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.CoverageReportParserFactory;
import com.teamscale.reportparser.parser.ECoverageFormat;
import java.util.EnumMap;
import java.util.function.Supplier;

public class ReportParserFactory {
    private static final EnumMap<EReportFormat, Supplier<IReportParser>> FACTORIES = new EnumMap(EReportFormat.class);

    public static IReportParser createParser(EReportFormat format) {
        Supplier<IReportParser> reportParserSupplier = FACTORIES.get((Object)format);
        if (reportParserSupplier != null) {
            return reportParserSupplier.get();
        }
        ECoverageFormat coverageFormat = format.getAssociatedCoverageFormat();
        if (coverageFormat == null) {
            throw new AssertionError((Object)("Missing factory for report format " + String.valueOf((Object)format)));
        }
        CoverageReportParserBase reportParser = CoverageReportParserFactory.createParser((ECoverageFormat)coverageFormat);
        return new GenericCoverageReportParserInvoker(reportParser);
    }

    static {
        FACTORIES.put(EReportFormat.ASTREE, AstreeReportParser::new);
        FACTORIES.put(EReportFormat.JACOCO, JaCoCoReportParserInvoker::new);
        FACTORIES.put(EReportFormat.XR_BABOON, XrBaboonReportParser::new);
        FACTORIES.put(EReportFormat.MS_COVERAGE, MsCoverageReportParser::new);
        FACTORIES.put(EReportFormat.ROSLYN, RoslynReportParser::new);
        FACTORIES.put(EReportFormat.CPPCHECK, CppcheckReportParser::new);
        FACTORIES.put(EReportFormat.PCLINT, PCLintReportParser::new);
        FACTORIES.put(EReportFormat.CLANG, ClangReportParser::new);
        FACTORIES.put(EReportFormat.CLANG_XCRESULT_JSON, ClangXCResultJsonReportParser::new);
        FACTORIES.put(EReportFormat.PYLINT, PyLintReportParser::new);
        FACTORIES.put(EReportFormat.FINDBUGS, FindbugsReportParser::new);
        FACTORIES.put(EReportFormat.FORTIFY, FortifyReportParser::new);
        FACTORIES.put(EReportFormat.FXCOP, FxCopReportParser::new);
        FACTORIES.put(EReportFormat.JUNIT, JUnitReportParser::new);
        FACTORIES.put(EReportFormat.XUNIT, XUnitReportParser::new);
        FACTORIES.put(EReportFormat.MS_TEST, MsTestReportParser::new);
        FACTORIES.put(EReportFormat.CS_COMPILER_WARNING, CSCompilerWarningsParser::new);
        FACTORIES.put(EReportFormat.ISSUE_CSV, IssueCsvReportParser::new);
        FACTORIES.put(EReportFormat.REQUIREMENTS_CSV, SpecItemCsvReportParser::new);
        FACTORIES.put(EReportFormat.MODEL_ADVISOR, ModelAdvisorReportParser::new);
        FACTORIES.put(EReportFormat.SAP_CODE_INSPECTOR, CodeInspectorJsonParser::new);
        FACTORIES.put(EReportFormat.SAP_COVERAGE, SapCoverageReportParser::new);
        FACTORIES.put(EReportFormat.TESTWISE_COVERAGE, TestwiseCoverageReportParser::new);
        FACTORIES.put(EReportFormat.OPEN_COVER, OpenCoverCoverageReportParser::new);
        FACTORIES.put(EReportFormat.GENERIC_FINDINGS, () -> new GenericExternalFindingsParser(true));
        FACTORIES.put(EReportFormat.GENERIC_NON_CODE, GenericNonCodeMetricsParser::new);
        FACTORIES.put(EReportFormat.PARASOFT_CPP_TEST, ParasoftCppTestReportParser::new);
        FACTORIES.put(EReportFormat.COMPILATION_DATABASE, CompilationDatabaseReportParser::new);
        FACTORIES.put(EReportFormat.MYPY, MypyReportParser::new);
        FACTORIES.put(EReportFormat.JQASSISTANT, JQAssistantReportParser::new);
        FACTORIES.put(EReportFormat.NUNIT, NUnitReportParser::new);
        FACTORIES.put(EReportFormat.SIMULINK_MAT, SimulinkMatFileReportParser::new);
        FACTORIES.put(EReportFormat.TEAMSCALE_COMPACT_COVERAGE, TeamscaleCompactCoverageReportParserInvoker::new);
        FACTORIES.put(EReportFormat.XCRESULT_JSON, XCResultJsonReportParser::new);
        FACTORIES.put(EReportFormat.BULLSEYE, BullseyeReportParser::new);
        FACTORIES.put(EReportFormat.RAW_TESTWISE, RawTestwiseReportParser::new);
        FACTORIES.put(EReportFormat.BOOST_TEST, BoostReportParser::new);
        FACTORIES.put(EReportFormat.PREPARSED, PreparsedReportParser::new);
        FACTORIES.put(EReportFormat.SONARQUBE, SonarqubeReportParser::new);
    }
}

