/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.astree;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.xml.sax.Attributes;

public class AstreeAlarmMessage {
    private static final String NOT_DUPLICATE = "0";
    private final String type;
    private final String locationId;
    private final boolean duplicate;
    private final List<TextLine> textLines = new ArrayList<TextLine>();

    private AstreeAlarmMessage(String type, String locationId, boolean duplicate) {
        this.type = type;
        this.locationId = locationId;
        this.duplicate = duplicate;
    }

    public String getMessage() {
        return StringUtils.concat((Iterable)CollectionUtils.map(this.textLines, TextLine::getContent), (String)" ");
    }

    public void addTextLine(TextLine currentTextline) {
        this.textLines.add(currentTextline);
    }

    public String getLocationId() {
        return this.locationId;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "AstreeAlarmMessage [locationId=" + this.getLocationId() + ", type=" + this.getType() + ", duplicate=" + this.duplicate + ", textlines=" + String.valueOf(this.textLines) + "]";
    }

    public static Optional<AstreeAlarmMessage> createFrom(Attributes attributes) {
        String type = attributes.getValue("type");
        String locationId = attributes.getValue("location_id");
        if (type == null || locationId == null) {
            return Optional.empty();
        }
        boolean duplicate = !NOT_DUPLICATE.equals(attributes.getValue("duplicate"));
        return Optional.of(new AstreeAlarmMessage(type, locationId, duplicate));
    }

    public static class TextLine {
        private String content;
        private final String location;

        private TextLine(String location) {
            this.location = location;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getLocation() {
            return this.location;
        }

        public String toString() {
            return "TextLine [content=" + this.content + ", location=" + this.location + "]";
        }

        public static Optional<TextLine> createFrom(Attributes attributes) {
            String locationId = attributes.getValue("location_id");
            if (locationId == null) {
                return Optional.empty();
            }
            return Optional.of(new TextLine(locationId));
        }
    }
}

