/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.astree;

import com.teamscale.index.report.astree.AstreeElementBase;
import com.teamscale.index.report.astree.AstreeReportParserUtils;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;

public class AstreeLocation
extends AstreeElementBase {
    private final @Nullable String pFile;
    private final @Nullable String oFile;
    private final @Nullable Integer oStartLine;
    private final @Nullable Integer oEndLine;

    private AstreeLocation(String id, String pFile, String oFile, Integer oStartLine, Integer oEndLine) {
        super(id);
        CCSMAssert.isTrue((oFile != null || pFile != null ? 1 : 0) != 0, (String)"Either oFile or pFile must not be null.");
        this.pFile = pFile;
        this.oFile = oFile;
        this.oStartLine = oStartLine;
        this.oEndLine = oEndLine;
    }

    private static Integer getIntegerValue(Attributes attributes, String qName) {
        String value = attributes.getValue(qName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public String getFileId() {
        if (this.oFile == null) {
            return this.pFile;
        }
        return this.oFile;
    }

    public Optional<Integer> getoStartLine() {
        return Optional.ofNullable(this.oStartLine);
    }

    public Optional<Integer> getoEndLine() {
        return Optional.ofNullable(this.oEndLine);
    }

    public String toString() {
        return "AstreeLocation [id=" + this.getId() + ", pFile=" + this.pFile + ", oFile=" + this.oFile + ", oStartLine=" + this.oStartLine + ", oEndLine=" + this.oEndLine + "]";
    }

    public static Optional<AstreeLocation> createFrom(Attributes attributes) {
        Optional<String> id = AstreeReportParserUtils.getIdFromAttributes(attributes);
        if (!id.isPresent()) {
            return Optional.empty();
        }
        String pFile = attributes.getValue("p_file");
        String oFile = attributes.getValue("o_file");
        if (pFile == null && oFile == null) {
            return Optional.empty();
        }
        Integer oStartLine = AstreeLocation.getIntegerValue(attributes, "o_start_line");
        Integer oEndLine = AstreeLocation.getIntegerValue(attributes, "o_end_line");
        return Optional.of(new AstreeLocation(id.get(), pFile, oFile, oStartLine, oEndLine));
    }
}

