/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage;

import com.google.common.collect.Lists;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoExecutionUnit;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMultiFileRangeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoProbeCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoTestExecution;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.coverage.CoverageReportPathMatchingPlausibilityCheck;
import com.teamscale.index.report.parser.IPathPrefixedReportParser;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.CoverageUnitContainer;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class CoverageReportParserInvokerBase
extends ReportParserBase
implements IPathPrefixedReportParser {
    private static final int MAX_BATCH_TOKEN_ELEMENTS_SIZE = 1000;
    private static final Logger LOGGER = LogManager.getLogger();
    private CoverageInfoRetriever coverageInfoRetriever;
    private @Nullable String pathPrefix = null;

    @Override
    protected void resetState() {
        super.resetState();
        this.coverageInfoRetriever = this.createCoverageInfoRetriever();
    }

    protected CoverageInfoRetriever createCoverageInfoRetriever() {
        return new CoverageInfoRetriever();
    }

    @Override
    protected IPathMatchingPlausibilityCheck buildPlausibilityCheck() {
        return new CoverageReportPathMatchingPlausibilityCheck(this.tokenElementLineInfoIndex, this.coverageInfoRetriever, this.pathPrefix, this.disablePlausibilityCheckForPathMapping);
    }

    @Override
    public final void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        this.parseCoverageReport(report, this.coverageInfoRetriever);
    }

    @Override
    public ExternalAnalysisImportInfos getInfos() throws ReportParserException {
        ExternalAnalysisImportInfos infos = super.getInfos();
        if (this.coverageInfoRetriever.getAllPaths().isEmpty()) {
            LOGGER.warn(this.getClass().getSimpleName() + ": No coverage data imported. Either the report does not contain any valid coverage (please check report) or the data could not be mapped to the files in Teamscale (please check previous warnings).");
        }
        return infos;
    }

    protected abstract void parseCoverageReport(String var1, CoverageInfoRetriever var2) throws ReportParserException;

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() throws StorageException {
        Map<String, String> pathInTeamscaleToPathInReport = this.getPathMapping(this.coverageInfoRetriever);
        List<ExternalAnalysisImportInfo<?>> importInfos = this.createLineCoverageImportInfos(this.coverageInfoRetriever.getAllLineCoverage(), pathInTeamscaleToPathInReport);
        importInfos.addAll(CoverageReportParserInvokerBase.createProbeCoverageImportInfos(this.coverageInfoRetriever.getAllProbeCoverage(), pathInTeamscaleToPathInReport));
        importInfos.addAll(CoverageReportParserInvokerBase.createTestExecutionImportInfos(this.coverageInfoRetriever.getAllTestwiseCoverage()));
        importInfos.addAll(CoverageReportParserInvokerBase.createExecutionUnitImportInfos(this.coverageInfoRetriever.getAllExecutionUnits()));
        importInfos.addAll(CoverageReportParserInvokerBase.createCoverageUnitImportInfos(this.coverageInfoRetriever.getAllCoverageUnits(), pathInTeamscaleToPathInReport));
        return new ExternalAnalysisImportInfos(importInfos);
    }

    private static List<ExternalAnalysisImportInfo<?>> createExecutionUnitImportInfos(Map<String, ExecutionUnit> allExecutionUnits) {
        ArrayList importInfos = new ArrayList();
        for (Map.Entry<String, ExecutionUnit> executableUnitContainerEntry : allExecutionUnits.entrySet()) {
            String executionUnitUniformPath = executableUnitContainerEntry.getKey();
            ExecutionUnit executionUnitContainer = executableUnitContainerEntry.getValue();
            importInfos.add(new ExternalAnalysisImportInfoExecutionUnit(executionUnitUniformPath, executionUnitContainer));
        }
        return importInfos;
    }

    private List<ExternalAnalysisImportInfo<?>> createLineCoverageImportInfos(Map<String, LineCoverageInfo> lineCoverageData, Map<String, String> pathInTeamscaleToPathInReport) throws StorageException {
        ArrayList importInfos = new ArrayList();
        if (lineCoverageData.size() == 0) {
            return importInfos;
        }
        List uniformPathsInChunks = Lists.partition(new ArrayList<String>(pathInTeamscaleToPathInReport.keySet()), (int)1000);
        for (List uniformPathsInChunk : uniformPathsInChunks) {
            List<TokenElementLineInfo> tokenElementLineInfos = this.tokenElementLineInfoIndex.getLineInfos(uniformPathsInChunk);
            CollectionUtils.forEach((Iterable)uniformPathsInChunk, tokenElementLineInfos, (uniformPath, tokenElementLineInfo) -> {
                String pathInReport = (String)pathInTeamscaleToPathInReport.get(uniformPath);
                LineCoverageInfo lineCoverage = (LineCoverageInfo)lineCoverageData.get(pathInReport);
                if (lineCoverage == null) {
                    return;
                }
                this.adjustCoverageToEntities((TokenElementLineInfo)tokenElementLineInfo, lineCoverage);
                importInfos.add(new ExternalAnalysisImportInfoLineCoverage((String)uniformPath, lineCoverage));
            });
        }
        return importInfos;
    }

    private static List<ExternalAnalysisImportInfo<?>> createProbeCoverageImportInfos(Map<String, ProbeCoverageInfo> probeCoverageData, Map<String, String> pathInTeamscaleToPathInReport) {
        ArrayList importInfos = new ArrayList();
        if (probeCoverageData.isEmpty()) {
            return importInfos;
        }
        for (Map.Entry<String, String> paths : pathInTeamscaleToPathInReport.entrySet()) {
            String pathInTeamscale = paths.getKey();
            String pathInReport = paths.getValue();
            ProbeCoverageInfo probeCoverage = probeCoverageData.get(pathInReport);
            if (probeCoverage == null) continue;
            importInfos.add(new ExternalAnalysisImportInfoProbeCoverage(pathInTeamscale, probeCoverage));
        }
        return importInfos;
    }

    private static List<ExternalAnalysisImportInfo<?>> createTestExecutionImportInfos(Map<String, TestInfoContainer> testwiseCoverageData) {
        ArrayList importInfos = new ArrayList();
        for (Map.Entry<String, TestInfoContainer> testwiseCoverageEntry : testwiseCoverageData.entrySet()) {
            TestInfoContainer testInfoContainer = testwiseCoverageEntry.getValue();
            if (!testInfoContainer.hasTestExecution()) continue;
            importInfos.add(new ExternalAnalysisImportInfoTestExecution(testwiseCoverageEntry.getKey(), testInfoContainer.getTestExecution(), testInfoContainer.isPartOfPartialReport()));
        }
        return importInfos;
    }

    private static List<ExternalAnalysisImportInfo<?>> createCoverageUnitImportInfos(Map<String, CoverageUnitContainer> coverageUnitContainers, Map<String, String> pathInTeamscaleToPathInReport) {
        for (CoverageUnitContainer coverageUnitContainer : coverageUnitContainers.values()) {
            for (Map.Entry<String, String> paths : pathInTeamscaleToPathInReport.entrySet()) {
                String pathInTeamscale = paths.getKey();
                String pathInReport = paths.getValue();
                coverageUnitContainer.getCoverageInfo().changeFilePath(pathInReport, pathInTeamscale);
            }
        }
        ArrayList importInfos = new ArrayList();
        for (Map.Entry<String, CoverageUnitContainer> coverageUnitEntry : coverageUnitContainers.entrySet()) {
            CoverageUnitContainer coverageUnitContainer = coverageUnitEntry.getValue();
            importInfos.add(new ExternalAnalysisImportInfoMultiFileRangeCoverage(coverageUnitEntry.getKey(), coverageUnitContainer.getCoverageInfo(), coverageUnitContainer.isPartOfPartialReport(), coverageUnitContainer.isPartOfMethodAccurateReport()));
        }
        return importInfos;
    }

    private Map<String, String> getPathMapping(CoverageInfoRetriever coverageInfoRetriever) throws StorageException {
        Set reportPaths = coverageInfoRetriever.getAllPaths();
        HashMap<String, String> pathInTeamscaleToPathInReport = new HashMap<String, String>();
        IPathMatchingPlausibilityCheck plausibilityCheck = this.buildPlausibilityCheck();
        for (String reportPath : reportPaths) {
            Optional<String> pathInTeamscaleOptional = this.resolvePath(reportPath, plausibilityCheck, this.pathPrefix);
            if (pathInTeamscaleOptional.isEmpty()) continue;
            String pathInTeamscale = pathInTeamscaleOptional.get();
            if (pathInTeamscaleToPathInReport.containsKey(pathInTeamscale)) {
                String existingMappedPath = (String)pathInTeamscaleToPathInReport.get(pathInTeamscale);
                if (!CoverageReportParserInvokerBase.isBetterPathMapping(reportPath, pathInTeamscale, existingMappedPath)) continue;
                pathInTeamscaleToPathInReport.put(pathInTeamscale, reportPath);
                continue;
            }
            pathInTeamscaleToPathInReport.put(pathInTeamscale, reportPath);
        }
        return pathInTeamscaleToPathInReport;
    }

    private static boolean isBetterPathMapping(String reportPath, String pathInTeamscale, String existingMappedPath) {
        int candidateSuffixLength;
        int existingSuffixLength = StringUtils.longestCommonSuffix((String)existingMappedPath.toLowerCase(), (String)pathInTeamscale.toLowerCase()).length();
        if (existingSuffixLength != (candidateSuffixLength = StringUtils.longestCommonSuffix((String)reportPath.toLowerCase(), (String)pathInTeamscale.toLowerCase()).length())) {
            return candidateSuffixLength > existingSuffixLength;
        }
        return reportPath.length() < existingMappedPath.length();
    }

    protected void adjustCoverageToEntities(TokenElementLineInfo tokenElementLineInfo, LineCoverageInfo coverage) {
    }

    protected CoverageInfoRetriever getCoverageInfoRetriever() {
        return this.coverageInfoRetriever;
    }

    @Override
    public void setPathPrefix(@Nullable String pathPrefix) {
        this.pathPrefix = pathPrefix == null ? null : StringUtils.ensureEndsWith((String)pathPrefix, (String)UniformPathUtils.SEPARATOR);
    }
}

