/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.findbugs;

import com.teamscale.index.report.findbugs.EBugCollectionAttributes;
import com.teamscale.index.report.findbugs.EBugCollectionElements;
import com.teamscale.index.report.findbugs.FindbugsMessageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.util.XMLReaderBase;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLElementProcessor;

public abstract class FindBugsReportConsumerBase
extends XMLReaderBase<EBugCollectionElements, EBugCollectionAttributes, ConQATException> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean findingCreated = false;

    protected FindBugsReportConsumerBase(String reportContent) {
        super(reportContent, EBugCollectionAttributes.class);
    }

    public void load() throws ConQATException {
        this.parseAndWrapExceptions();
        this.processChildElements(new BugInstanceProcessor(this));
    }

    private void createFinding(String findbugsRule, String message, String sourcePath) throws ConQATException {
        this.processChildElements(new SourceLineProcessor(this, findbugsRule, message));
        if (!this.findingCreated) {
            this.processChildElements(new MethodAndFieldProcessor(this, EBugCollectionElements.Field, null, null, findbugsRule, message));
        }
        if (!this.findingCreated) {
            this.processChildElements(new MethodAndFieldProcessor(this, EBugCollectionElements.Method, null, null, findbugsRule, message));
        }
        if (!this.findingCreated) {
            this.processChildElements(new ClassProcessor(this, findbugsRule, message));
        }
        if (!this.findingCreated) {
            LOGGER.warn("No specific locations found for '" + sourcePath + "'. Adding plain file location.");
            this.createFileFinding(findbugsRule, message, sourcePath);
        }
    }

    protected abstract void createFileFinding(String var1, String var2, String var3) throws ConQATException;

    protected abstract boolean createRegionFinding(String var1, String var2, String var3, Integer var4, Integer var5) throws ConQATException;

    private final class BugInstanceProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        final /* synthetic */ FindBugsReportConsumerBase this$0;

        private BugInstanceProcessor(FindBugsReportConsumerBase findBugsReportConsumerBase) {
            FindBugsReportConsumerBase findBugsReportConsumerBase2 = findBugsReportConsumerBase;
            Objects.requireNonNull(findBugsReportConsumerBase2);
            this.this$0 = findBugsReportConsumerBase2;
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.BugInstance;
        }

        public void process() throws ConQATException {
            String type = this.this$0.getStringAttribute(EBugCollectionAttributes.type);
            HashSet<String> classNames = new HashSet<String>();
            ArrayList<String> methodAndFieldNames = new ArrayList<String>();
            ClassProcessor cp = new ClassProcessor(this.this$0, null, null);
            this.extractLocationInformation(cp, classNames, methodAndFieldNames);
            this.this$0.findingCreated = false;
            this.this$0.createFinding(type, FindbugsMessageManager.getInstance().getShortDescription(type), cp.sourcePath);
            if (!this.this$0.findingCreated) {
                LOGGER.warn("Could not create finding as no locations were found (see messages above)");
            }
        }

        private void extractLocationInformation(ClassProcessor cp, Set<String> classNames, List<String> methodAndFieldNames) throws ConQATException {
            this.this$0.processChildElements(cp);
            classNames.add(cp.className);
            this.this$0.processChildElements(new MethodAndFieldProcessor(this.this$0, EBugCollectionElements.Method, classNames, methodAndFieldNames, null, null));
            this.this$0.processChildElements(new MethodAndFieldProcessor(this.this$0, EBugCollectionElements.Field, classNames, methodAndFieldNames, null, null));
        }
    }

    private final class SourceLineProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private String sourcePath;
        private final String findbugsRule;
        private final String message;
        final /* synthetic */ FindBugsReportConsumerBase this$0;

        public SourceLineProcessor(FindBugsReportConsumerBase findBugsReportConsumerBase, String findbugsRule, String message) {
            FindBugsReportConsumerBase findBugsReportConsumerBase2 = findBugsReportConsumerBase;
            Objects.requireNonNull(findBugsReportConsumerBase2);
            this.this$0 = findBugsReportConsumerBase2;
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.SourceLine;
        }

        public void process() throws ConQATException {
            this.sourcePath = this.this$0.getStringAttribute(EBugCollectionAttributes.sourcepath);
            if (this.findbugsRule == null || this.this$0.findingCreated) {
                return;
            }
            Integer startLine = this.obtainLineNumber(EBugCollectionAttributes.start);
            Integer endLine = this.obtainLineNumber(EBugCollectionAttributes.end);
            if (startLine != null && endLine != null) {
                endLine = Math.max(startLine, endLine);
                this.this$0.findingCreated = this.this$0.createRegionFinding(this.sourcePath, this.findbugsRule, this.message, startLine, endLine);
            }
        }

        private Integer obtainLineNumber(EBugCollectionAttributes attribute) {
            String lineAsString = this.this$0.getStringAttribute(attribute);
            if (StringUtils.isEmpty((String)lineAsString)) {
                return null;
            }
            try {
                return Integer.parseInt(lineAsString);
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Invalid line number information for " + this.sourcePath + ": '" + lineAsString + "'");
                return null;
            }
        }
    }

    private final class MethodAndFieldProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private final EBugCollectionElements targetElement;
        private final Set<String> classNames;
        private final List<String> methodAndFieldNames;
        private final String findbugsRule;
        private final String message;
        final /* synthetic */ FindBugsReportConsumerBase this$0;

        public MethodAndFieldProcessor(FindBugsReportConsumerBase findBugsReportConsumerBase, EBugCollectionElements targetElement, Set<String> classNames, List<String> methodAndFieldNames, String findbugsRule, String message) {
            FindBugsReportConsumerBase findBugsReportConsumerBase2 = findBugsReportConsumerBase;
            Objects.requireNonNull(findBugsReportConsumerBase2);
            this.this$0 = findBugsReportConsumerBase2;
            this.targetElement = targetElement;
            this.classNames = classNames;
            this.methodAndFieldNames = methodAndFieldNames;
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return this.targetElement;
        }

        public void process() throws ConQATException {
            if (this.classNames != null) {
                this.classNames.add(this.this$0.getStringAttribute(EBugCollectionAttributes.classname));
            }
            if (StringUtils.isEmpty((String)this.this$0.getStringAttribute(EBugCollectionAttributes.role))) {
                if (this.methodAndFieldNames != null) {
                    this.methodAndFieldNames.add(this.this$0.getStringAttribute(EBugCollectionAttributes.name));
                }
                if (this.findbugsRule != null) {
                    this.this$0.processChildElements(new SourceLineProcessor(this.this$0, this.findbugsRule, this.message));
                }
            }
        }
    }

    private final class ClassProcessor
    implements IXMLElementProcessor<EBugCollectionElements, ConQATException> {
        private String className;
        private String sourcePath;
        private final String findbugsRule;
        private final String message;
        final /* synthetic */ FindBugsReportConsumerBase this$0;

        public ClassProcessor(FindBugsReportConsumerBase findBugsReportConsumerBase, String findbugsRule, String message) {
            FindBugsReportConsumerBase findBugsReportConsumerBase2 = findBugsReportConsumerBase;
            Objects.requireNonNull(findBugsReportConsumerBase2);
            this.this$0 = findBugsReportConsumerBase2;
            this.findbugsRule = findbugsRule;
            this.message = message;
        }

        public EBugCollectionElements getTargetElement() {
            return EBugCollectionElements.Class;
        }

        public void process() throws ConQATException {
            if (StringUtils.isEmpty((String)this.this$0.getStringAttribute(EBugCollectionAttributes.role))) {
                this.className = this.this$0.getStringAttribute(EBugCollectionAttributes.classname);
                SourceLineProcessor slp = new SourceLineProcessor(this.this$0, this.findbugsRule, this.message);
                this.this$0.processChildElements(slp);
                if (this.sourcePath == null) {
                    this.sourcePath = slp.sourcePath;
                }
            }
        }
    }
}

