/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.ClangReportParser;
import com.teamscale.reportparser.parser.ReportParserException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;

public class ClangXCResultJsonReportParser
extends FindingCollectingReportParserBase {
    private List<ClangFinding> clangFindings;
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    protected void resetState() {
        super.resetState();
        this.clangFindings = new ArrayList<ClangFinding>();
    }

    @Override
    public void parseStringReportInternal(@Language(value="JSON") String report, @Nullable String reportPath) throws ReportParserException {
        JsonNode errors;
        JsonNode warnings;
        JsonNode jsonReport;
        try {
            jsonReport = JsonUtils.deserializeFromJson((String)report);
        }
        catch (JsonSerializationException e) {
            throw new ReportParserException("Unable to parse Clang XCResult JSON report", (Throwable)e);
        }
        JsonNode analyzerWarnings = jsonReport.get("analyzerWarnings");
        if (analyzerWarnings != null && analyzerWarnings.isArray()) {
            for (Iterator warning : analyzerWarnings) {
                this.parseWarningOrError((JsonNode)warning);
            }
        }
        if ((warnings = jsonReport.get("warnings")) != null && warnings.isArray()) {
            for (JsonNode warning : warnings) {
                this.parseWarningOrError(warning);
            }
        }
        if ((errors = jsonReport.get("errors")) != null && errors.isArray()) {
            for (JsonNode error : errors) {
                this.parseWarningOrError(error);
            }
        }
    }

    private void parseWarningOrError(JsonNode warning) {
        JsonNode issueTypeNode = warning.get("issueType");
        JsonNode messageNode = warning.get("message");
        JsonNode sourceUrlNode = warning.get("sourceURL");
        if (issueTypeNode == null || messageNode == null || sourceUrlNode == null) {
            return;
        }
        String issueType = issueTypeNode.textValue();
        String message = messageNode.textValue();
        String sourceUrl = sourceUrlNode.textValue();
        SourceLocation location = ClangXCResultJsonReportParser.parseSourceUrl(sourceUrl);
        if (location != null) {
            String checkId = ClangXCResultJsonReportParser.mapIssueTypeToCategory(issueType);
            this.clangFindings.add(new ClangFinding(checkId, message, location, new ArrayList<StatementPathElement>()));
        } else {
            LOGGER.error("Unable to parse location: {}. Skipping json node in report: {}", (Object)sourceUrl, (Object)warning.toString());
        }
    }

    private static @Nullable SourceLocation parseSourceUrl(String sourceUrl) {
        try {
            int fragmentIndex = sourceUrl.indexOf(35);
            if (fragmentIndex == -1) {
                return null;
            }
            String fileUrlPart = sourceUrl.substring(0, fragmentIndex);
            String fragment = sourceUrl.substring(fragmentIndex + 1);
            String filePath = fileUrlPart.replace("file://", "");
            filePath = URLDecoder.decode(filePath, StandardCharsets.UTF_8);
            StringUtils.stripPrefix((String)filePath, (String)"/");
            Map<String, String> params = ClangXCResultJsonReportParser.parseUrlFragment(fragment);
            String startLineStr = params.get("StartingLineNumber");
            if (startLineStr == null) {
                return null;
            }
            int startLine = Integer.parseInt(startLineStr);
            String endLineStr = params.get("EndingLineNumber");
            int endLine = endLineStr != null ? Integer.parseInt(endLineStr) : startLine;
            return new SourceLocation(filePath, startLine, endLine, ClangXCResultJsonReportParser.readOffsetParam(params.get("StartingColumnNumber")), ClangXCResultJsonReportParser.readOffsetParam(params.get("EndingColumnNumber")));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int readOffsetParam(String offsetParameterValue) {
        if (offsetParameterValue == null) {
            return -1;
        }
        return NumberUtils.toInt((String)offsetParameterValue, (int)-1);
    }

    private static Map<String, String> parseUrlFragment(String fragment) {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = fragment.split("&")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) continue;
            params.put(keyValue[0], keyValue[1]);
        }
        return params;
    }

    private static String mapIssueTypeToCategory(String issueType) {
        if (ClangReportParser.KNOWN_CATEGORIES.contains(issueType)) {
            return issueType;
        }
        String replaced = ClangReportParser.CHECK_ID_REPLACEMENTS.getOrDefault(issueType, issueType);
        if (ClangReportParser.KNOWN_CATEGORIES.contains(replaced)) {
            return replaced;
        }
        return "Other";
    }

    @Override
    protected void collectFindings() throws StorageException {
        for (ClangFinding clangFinding : this.clangFindings) {
            Optional<String> uniformPath = this.resolvePath(clangFinding.location.fileLocationInReport());
            if (uniformPath.isEmpty()) {
                LOGGER.error("Unable to resolve path for: {}. Skipping finding: {}", (Object)clangFinding.location.fileLocationInReport(), (Object)clangFinding.checkId());
                continue;
            }
            this.createAndAddFinding(clangFinding, uniformPath.get());
        }
    }

    private void createAndAddFinding(ClangFinding clangFinding, String uniformPath) throws StorageException {
        ElementLocation location;
        BasicTokenElementInfo tokenElementInfo = this.basicTokenElementIndex.getTokenElement(uniformPath);
        if (tokenElementInfo == null) {
            LOGGER.error("Unable to find token element info for: {}. Skipping finding: {}", (Object)uniformPath, (Object)clangFinding.checkId());
            return;
        }
        int startLineNumber = clangFinding.location.startLine() + 1;
        LineOffsetConverter offsetConverter = new LineOffsetConverter(tokenElementInfo.getText());
        if (!offsetConverter.isValidLine(startLineNumber)) {
            LOGGER.error("Found invalid line for: {}. Start line {}. Skipping finding: {}", (Object)uniformPath, (Object)startLineNumber, (Object)clangFinding.checkId());
            return;
        }
        try {
            location = ClangXCResultJsonReportParser.createLocation(offsetConverter, uniformPath, clangFinding.location);
        }
        catch (ReportParserException e) {
            LOGGER.error("Report parsing issue found: {} Skipping finding: {}", (Object)e.getMessage(), (Object)clangFinding.checkId());
            return;
        }
        DetachedFinding finding = ClangXCResultJsonReportParser.createDetachedFinding(clangFinding, location);
        this.addFindingForPath(uniformPath, finding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ElementLocation createLocation(LineOffsetConverter offsetConverter, String uniformPath, SourceLocation location) throws ReportParserException {
        int endOffset;
        int startLineOneBased = location.startLine() + 1;
        int endLineOneBased = location.endLine() + 1;
        if (!offsetConverter.isValidLine(endLineOneBased + 1)) {
            LOGGER.warn("Found invalid end line for: {}. Line {}. Using startLine instead for finding starting in line {}", (Object)uniformPath, (Object)endLineOneBased, (Object)startLineOneBased);
            endLineOneBased = startLineOneBased;
        }
        int lineStartOffset = offsetConverter.getOffset(startLineOneBased);
        int lineLength = offsetConverter.getOffset(startLineOneBased + 1) - lineStartOffset - 1;
        int startOffset = lineStartOffset;
        if (location.startColumnNUmber != -1) {
            if (location.startColumnNUmber > lineLength) {
                LOGGER.warn("Start column {} exceeds line length {} for {}:{}. Adjusting to line end.", (Object)location.startColumnNUmber, (Object)lineLength, (Object)uniformPath, (Object)startLineOneBased);
                startOffset = lineStartOffset + lineLength;
            } else {
                startOffset = lineStartOffset + location.startColumnNUmber;
            }
        }
        if (location.endColumnNumber != -1) {
            try {
                int requestedEndOffset = offsetConverter.getOffset(endLineOneBased) + location.endColumnNumber;
                if (location.endColumnNumber > lineLength) {
                    LOGGER.warn("End column {} exceeds line length {} for {}:{}. Adjusting to line end.", (Object)location.endColumnNumber, (Object)lineLength, (Object)uniformPath, (Object)endLineOneBased);
                    endOffset = offsetConverter.getOffset(endLineOneBased + 1) - 1;
                } else {
                    endOffset = requestedEndOffset;
                }
                if (location.startColumnNUmber == -1 || location.startColumnNUmber != location.endColumnNumber) return new TextRegionLocation(uniformPath, startOffset, endOffset, startLineOneBased, endLineOneBased);
                ++endOffset;
                return new TextRegionLocation(uniformPath, startOffset, endOffset, startLineOneBased, endLineOneBased);
            }
            catch (IllegalArgumentException e) {
                throw new ReportParserException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            endOffset = offsetConverter.getOffset(endLineOneBased + 1) - 1;
            return new TextRegionLocation(uniformPath, startOffset, endOffset, startLineOneBased, endLineOneBased);
        }
        catch (IllegalArgumentException e) {
            throw new ReportParserException(e.getMessage(), (Throwable)e);
        }
    }

    private static DetachedFinding createDetachedFinding(ClangFinding clangFinding, ElementLocation location) {
        String message = MarkupUtils.escapeMarkdownRelevantSymbols((String)clangFinding.message());
        DetachedFinding finding = new DetachedFinding(clangFinding.checkId(), "Clang", message, location);
        finding.setStatementPath(clangFinding.statementPath);
        return finding;
    }

    private record SourceLocation(String fileLocationInReport, int startLine, int endLine, int startColumnNUmber, int endColumnNumber) {
    }

    private record ClangFinding(String checkId, String message, SourceLocation location, ArrayList<StatementPathElement> statementPath) {
    }
}

