/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.findbugs.FindBugsReportConsumerBase;
import com.teamscale.index.report.findbugs.FindbugsMessageManager;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class FindbugsReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String FIND_BUGS = "FindBugs";

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        if (StringUtils.isEmpty((String)report)) {
            LOGGER.info("Empty report \"{}\"", (Object)reportPath);
            return;
        }
        try {
            new ReportConsumer(this, report).load();
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    protected void collectFindings() {
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        FindbugsReportParser.checkEnabledAnalysisTool(EAnalysisTool.FINDBUGS, analysisProfiles, projectId);
    }

    private class ReportConsumer
    extends FindBugsReportConsumerBase {
        final /* synthetic */ FindbugsReportParser this$0;

        private ReportConsumer(FindbugsReportParser findbugsReportParser, String reportContent) {
            FindbugsReportParser findbugsReportParser2 = findbugsReportParser;
            Objects.requireNonNull(findbugsReportParser2);
            this.this$0 = findbugsReportParser2;
            super(reportContent);
        }

        @Override
        protected void createFileFinding(String findbugsRule, String message, String sourcePath) throws ConQATException {
            try {
                Optional<String> resolvedPath = this.this$0.resolvePath(sourcePath);
                if (resolvedPath.isPresent()) {
                    this.addFileFinding(message, FindbugsMessageManager.getInstance().getShortDescription(findbugsRule), resolvedPath.get());
                }
            }
            catch (StorageException e) {
                throw new ConQATException((Throwable)e);
            }
        }

        @Override
        protected boolean createRegionFinding(String sourcePath, String findbugsRule, String message, Integer startLine, Integer endLine) throws ConQATException {
            try {
                Optional<String> filePath = this.this$0.resolvePath(sourcePath);
                if (filePath.isPresent()) {
                    this.addRegionFinding(message, FindbugsMessageManager.getInstance().getShortDescription(findbugsRule).trim(), filePath.get(), startLine, endLine);
                    return true;
                }
            }
            catch (StorageException e) {
                throw new ConQATException((Throwable)e);
            }
            return false;
        }

        private void addRegionFinding(String message, String groupName, String uniformPath, int startLine, int endLine) {
            TextRegionLocation location = FindbugsReportParser.createLineLocation(uniformPath, startLine, endLine);
            DetachedFinding finding = new DetachedFinding(groupName, FindbugsReportParser.FIND_BUGS, message, (ElementLocation)location);
            this.this$0.addFindingForPath(uniformPath, finding);
        }

        private void addFileFinding(String message, String groupName, String uniformPath) {
            ElementLocation location = new ElementLocation(uniformPath);
            DetachedFinding finding = new DetachedFinding(groupName, FindbugsReportParser.FIND_BUGS, message, location);
            this.this$0.addFindingForPath(uniformPath, finding);
        }

        protected String getLocation() {
            return "findbugs report";
        }
    }
}

