/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.tools.FxCopConfiguration;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.fxcop.FxCopReportReader;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class FxCopReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FXCOP = "FxCop";
    private List<FxCopFinding> fxCopFindings;
    private Set<String> allEncounteredTypes;

    @Override
    protected void resetState() {
        super.resetState();
        this.fxCopFindings = new ArrayList<FxCopFinding>();
        this.allEncounteredTypes = new HashSet<String>();
    }

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        Map fxCopRulesMappingsMap = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)Resource.of(FxCopConfiguration.class, (String)"message/fxcop/check-mappings.tsv"));
        try {
            new FxCopReportReader(this::createFxCopFinding, fxCopRulesMappingsMap).loadReport(report);
        }
        catch (ConQATException e) {
            throw new ReportParserException((Throwable)e);
        }
    }

    @Override
    public void checkEnabledAnalysesAndTools(List<AnalysisProfile> analysisProfiles, PublicProjectId projectId) throws ConQATException {
        FxCopReportParser.checkEnabledAnalysisTool(EAnalysisTool.FXCOP, analysisProfiles, projectId);
        boolean architectureEnabled = FxCopReportParser.isArchitectureAnalysisEnabled(analysisProfiles);
        if (!architectureEnabled) {
            throw new ConQATException("Upload failed. Architecture analysis is not enabled in the analysis configuration for project: " + String.valueOf(projectId) + ". In order for FxCop uploads to work, architecture analysis needs to be enabled.");
        }
    }

    private static boolean isArchitectureAnalysisEnabled(List<AnalysisProfile> analysisProfiles) {
        for (QualityIndicator qualityIndicator : AnalysisProfileUtils.getQualityIndicators(analysisProfiles)) {
            for (AnalysisGroup analysisGroup : qualityIndicator.getGroups()) {
                if (!"Architecture Conformance".equals(analysisGroup.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void createFxCopFinding(String message, String path, String file, String ruleId, String type, int lineNumber, String checkId, String checkName) {
        this.fxCopFindings.add(new FxCopFinding(this, message, path, file, ruleId, type, lineNumber, checkId, checkName));
        this.allEncounteredTypes.add(FxCopReportParser.stripTypeSuffix(type));
    }

    @Override
    protected void collectFindings() throws StorageException {
        Map<String, String> typePathMap = this.getTypeUniformPathMap();
        for (FxCopFinding fxCopFinding : this.fxCopFindings) {
            if (StringUtils.isEmpty((String)fxCopFinding.getPath()) || StringUtils.isEmpty((String)fxCopFinding.getFile())) {
                this.createTypeFinding(fxCopFinding, typePathMap);
                continue;
            }
            this.createLineLocationFinding(fxCopFinding);
        }
    }

    private void createTypeFinding(FxCopFinding fxCopFinding, Map<String, String> typePathMap) throws StorageException {
        String type = FxCopReportParser.stripTypeSuffix(fxCopFinding.getType());
        String targetUniformPath = typePathMap.get(type);
        if (targetUniformPath == null) {
            LOGGER.warn("No uniform path was matched to the C# type: " + type + ". FxCop finding could not be created.");
            return;
        }
        Optional<String> resolvedTargetUniformPath = this.resolvePath(targetUniformPath);
        if (resolvedTargetUniformPath.isPresent()) {
            DetachedFinding finding = FxCopReportParser.createFileFinding(resolvedTargetUniformPath.get(), fxCopFinding.getRuleId(), FXCOP, fxCopFinding.getMessage());
            this.setFindingPropertiesAndAddFinding(fxCopFinding, resolvedTargetUniformPath.get(), finding);
        }
    }

    private void createLineLocationFinding(FxCopFinding fxCopFinding) throws StorageException {
        CCSMAssert.isTrue((fxCopFinding.getLineNumber() != 0 ? 1 : 0) != 0, (String)("Expected non-0 line number for finding: " + String.valueOf(fxCopFinding)));
        String fxCopFindingPath = fxCopFinding.getPath().concat("\\").concat(fxCopFinding.getFile());
        Optional<String> uniformPath = this.resolvePath(fxCopFindingPath);
        if (uniformPath.isPresent()) {
            DetachedFinding finding = FxCopReportParser.createLineFinding(fxCopFinding.getLineNumber(), uniformPath.get(), fxCopFinding.getRuleId(), FXCOP, fxCopFinding.getMessage());
            this.setFindingPropertiesAndAddFinding(fxCopFinding, uniformPath.get(), finding);
        }
    }

    private void setFindingPropertiesAndAddFinding(FxCopFinding fxCopFinding, String uniformPath, DetachedFinding finding) {
        finding.setProperty("Rule ID", (Object)fxCopFinding.getCheckId());
        finding.setProperty("Rule name", (Object)fxCopFinding.getCheckName());
        this.addFindingForPath(uniformPath, finding);
    }

    private static String stripTypeSuffix(String type) {
        return StringUtils.removeLastPart((String)StringUtils.removeLastPart((String)type, (char)'+'), (char)'`');
    }

    private Map<String, String> getTypeUniformPathMap() throws StorageException {
        List<List<String>> uniformPathsForTypes = this.typeIndexCache.getFilesForTypes(this.allEncounteredTypes);
        HashMap<String, String> typePathMap = new HashMap<String, String>();
        int i = 0;
        for (String type : this.allEncounteredTypes) {
            List<String> paths = uniformPathsForTypes.get(i);
            if (!paths.isEmpty()) {
                typePathMap.put(type, paths.get(0));
            }
            ++i;
        }
        return typePathMap;
    }

    private class FxCopFinding {
        private final String message;
        private final String path;
        private final String file;
        private final String ruleId;
        private final String type;
        private final int lineNumber;
        private final String checkId;
        private final String checkName;

        public FxCopFinding(FxCopReportParser fxCopReportParser, String message, String path, String file, String ruleId, String type, int lineNumber, String checkId, String checkName) {
            Objects.requireNonNull(fxCopReportParser);
            this.message = message;
            this.path = path;
            this.file = file;
            this.ruleId = ruleId;
            this.type = type;
            this.lineNumber = lineNumber;
            this.checkId = checkId;
            this.checkName = checkName;
        }

        public String getType() {
            return this.type;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public String getMessage() {
            return this.message;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPath() {
            return this.path;
        }

        public String getFile() {
            return this.file;
        }

        public String getCheckId() {
            return this.checkId;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public String toString() {
            return "FxCopFinding [message=" + this.message + ", path=" + this.path + ", file=" + this.file + ", ruleId=" + this.ruleId + ", type=" + this.type + ", lineNumber=" + this.lineNumber + ", checkId=" + this.checkId + ", checkName=" + this.checkName + "]";
        }
    }
}

