/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.info.ExternalAnalysisSimulinkCodeGenerationTraceInfo;
import com.teamscale.index.report.parser.ReportParserBase;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.reportparser.parser.ReportParserException;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.MethodNotSupportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.Nullable;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;
import us.hebi.matlab.mat.types.Struct;

public class SimulinkMatFileReportParser
extends ReportParserBase {
    private static final String TRACE_INFO_MAT_FILE_NAME = "traceInfo.mat";
    private ExternalAnalysisImportInfos report;
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void parse(ReportContentIndexBase.ReportContent report, @Nullable String reportPath) throws ReportParserException {
        this.resetState();
        if (!SimulinkMatFileReportParser.isPlcCoderTraceInfoFile(reportPath)) {
            LOGGER.warn("File mapped as Simulink Mat file can't be processed: {}", (Object)reportPath);
            return;
        }
        try {
            Mat5File resultMat = SimulinkMatFileReportParser.readMat(report.content);
            Map<String, String> traceInfo = SimulinkMatFileReportParser.readTraceInfo(resultMat);
            Map<String, QualifiedNameLocation> locations = this.extractLocations(traceInfo, this.tokenElementIndexCache, this.binaryElementIndex);
            ExternalAnalysisSimulinkCodeGenerationTraceInfo.SimulinkCodeGenerationTraces traces = new ExternalAnalysisSimulinkCodeGenerationTraceInfo.SimulinkCodeGenerationTraces(locations);
            this.report = new ExternalAnalysisImportInfos(new ExternalAnalysisSimulinkCodeGenerationTraceInfo(reportPath, traces));
        }
        catch (IOException | ExecutionException | StorageException | SimulinkModelBuildingException e) {
            LOGGER.error("Error while parsing Simulink MAT trace file {}", (Object)reportPath, (Object)e);
        }
    }

    @Deprecated
    public static boolean isPlcCoderTraceInfoFile(@Nullable String uniformPath) {
        return UniformPathUtils.getElementName((String)uniformPath).equals(TRACE_INFO_MAT_FILE_NAME);
    }

    public static boolean isPlcCoderTraceInfoFile(@Nullable UniformPath uniformPath) {
        if (uniformPath == null || uniformPath.isRoot()) {
            return false;
        }
        return uniformPath.getLastSegment().equals(TRACE_INFO_MAT_FILE_NAME);
    }

    @Override
    public void parseStringReport(String reportContent, @Nullable String reportPath) throws ReportParserException {
        throw new ReportParserException((Throwable)new MethodNotSupportedException("The Simulink MAT file parser can't parse non-binary files"));
    }

    @Override
    public void parseStringReportInternal(String reportContent, @Nullable String reportPath) throws ReportParserException {
        throw new ReportParserException((Throwable)new MethodNotSupportedException("The Simulink MAT file parser can't parse non-binary files"));
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() throws StorageException {
        return this.report;
    }

    private static Mat5File readMat(byte[] reportFileBytes) throws IOException {
        try (Source source = Sources.wrap((byte[])reportFileBytes);){
            Mat5File mat5File = Mat5.newReader((Source)source).setReducedHeader(false).readMat();
            return mat5File;
        }
    }

    private static Map<String, String> readTraceInfo(Mat5File resultMat) {
        HashMap<String, String> result = new HashMap<String, String>();
        Struct traceInfo = resultMat.getStruct("infoStruct").getStruct("traceInfo");
        int numEntries = traceInfo.getDimensions()[0];
        for (int i = 0; i < numEntries; ++i) {
            Array sid = traceInfo.get("sid", i);
            Array rtwname = traceInfo.get("rtwname", i);
            result.put(rtwname.toString().replace("\n", " "), sid.toString());
        }
        return result;
    }

    private Map<String, QualifiedNameLocation> extractLocations(Map<String, String> traceInfo, TokenElementIndexCache basicTokenElementCache, BinaryElementIndex binaryElementIndex) throws StorageException, IOException, SimulinkModelBuildingException, ExecutionException {
        HashMap<String, QualifiedNameLocation> locations = new HashMap<String, QualifiedNameLocation>();
        List<String> allKeys = binaryElementIndex.getAllElements();
        this.parallelExecutor.executeParallelBatches(allKeys, keysInBatch -> this.extractLocationsFromBatch((List<String>)keysInBatch, (Map<String, QualifiedNameLocation>)locations, traceInfo, basicTokenElementCache), 100);
        return locations;
    }

    private void extractLocationsFromBatch(List<String> keysInBatch, Map<String, QualifiedNameLocation> locations, Map<String, String> traceInfo, TokenElementIndexCache basicTokenElementCache) throws StorageException {
        basicTokenElementCache.loadValues(keysInBatch);
        List<byte @Nullable []> contents = this.binaryElementIndex.getContents(keysInBatch);
        for (int i = 0; i < contents.size(); ++i) {
            byte[] file = contents.get(i);
            String path = keysInBatch.get(i);
            if (basicTokenElementCache.getValue(path) == null || basicTokenElementCache.getValue(path).getLanguage() != ELanguage.SIMULINK) continue;
            try {
                locations.putAll(SimulinkMatFileReportParser.resolveTraceInfoHintsToLocationsInModel(traceInfo, path, file));
                continue;
            }
            catch (IOException | SimulinkModelBuildingException e) {
                LOGGER.warn("Could not search for traceinfo locations in {} (could not read as simulink model)", (Object)path, (Object)e);
            }
        }
    }

    private static Map<String, QualifiedNameLocation> resolveTraceInfoHintsToLocationsInModel(Map<String, String> traceInfo, String uniformPath, byte[] fileBytes) throws IOException, SimulinkModelBuildingException {
        HashMap<String, QualifiedNameLocation> locations = new HashMap<String, QualifiedNameLocation>();
        SimulinkModel model = SimulinkUtils.parseModelFromByteArray((byte[])fileBytes, (String)uniformPath, referencedFile -> null);
        String filenameWithoutExtension = FileSystemUtils.getFilenameWithoutExtension((String)UniformPathUtils.getElementName((String)uniformPath));
        for (Map.Entry<String, String> xEntry : traceInfo.entrySet()) {
            String linkedLocation = StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)xEntry.getValue(), (String)"'"), (String)"'");
            List sourceParts = StringUtils.splitToList((String)linkedLocation, (String)":");
            if (sourceParts.size() < 2) {
                LOGGER.warn("Could not map PLCcoder trace location {} to a simulink-model location. Expected a colon in location.", (Object)xEntry.getValue());
                continue;
            }
            String modelName = (String)sourceParts.get(0);
            String sidInModel = (String)sourceParts.get(1);
            if (!filenameWithoutExtension.equals(modelName)) continue;
            SimulinkBlock block = SimulinkUtils.findBlockBySidRecursive((SimulinkBlock)model, (String)sidInModel);
            if (block == null) {
                block = SimulinkUtils.findBlockBySidRecursive((SimulinkBlock)model, (String)sidInModel.replace(":", "::"));
            }
            if (block != null) {
                QualifiedNameLocation location = new QualifiedNameLocation(block.buildQualifiedName(), uniformPath);
                locations.put(xEntry.getKey(), location);
                continue;
            }
            LOGGER.warn("Could not map PLCcoder trace location {} to a block in a simulink model.", (Object)xEntry.getValue());
        }
        return locations;
    }
}

