/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoSpecItems;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.parser.IssueCsvReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SpecItemCsvReportParser
extends IssueCsvReportParserBase {
    private static final List<String> HEADER_FORMAT = Arrays.asList("id", "subject", "assignee", "author", "description", "created", "updated", "status", "closed", "url", "additional_assignees", "linkRoles", "linkedRequirements", "type", "typeAbbreviation");
    public static final String CODE_PATH_KEY = "-csv-spec-items-";
    private List<SpecItem> specItems = new ArrayList<SpecItem>();

    @Override
    protected void resetState() {
        super.resetState();
        this.specItems = new ArrayList<SpecItem>();
    }

    @Override
    protected List<String> getHeaderFormat() {
        return HEADER_FORMAT;
    }

    @Override
    protected ExternalAnalysisImportInfos convertToImportInfos() {
        return new ExternalAnalysisImportInfos(new ExternalAnalysisImportInfoSpecItems(CODE_PATH_KEY, this.specItems, this.connectorId));
    }

    @Override
    protected void addItem(List<String> row, List<String> header) throws ReportParserException {
        this.specItems.add(this.parseSpecItem(row, header));
    }

    private SpecItem parseSpecItem(List<String> row, List<String> header) throws ReportParserException {
        TeamscaleIssue issue = this.parseIssue(row, header);
        ArrayList additionalTypes = CollectionUtils.repeat(index -> "String", (int)issue.getAdditionalFieldNames().size());
        List parentIds = issue.getParentId().map(TeamscaleIssueId::getExternalId).map(List::of).orElseGet(Collections::emptyList);
        SpecItem.SpecItemBuilder specItemBuilder = new SpecItem.SpecItemBuilder(issue.getId(), issue.getCreated(), (List)issue.getAdditionalFieldNames(), (List)issue.getAdditionalFieldValues(), (List)additionalTypes, issue.getUrl(), parentIds);
        specItemBuilder = specItemBuilder.assignee(issue.getAssignee()).author(issue.getAuthor()).description(issue.getDescription()).status(issue.getStatus()).subject(issue.getSubject()).updated(issue.getUpdated());
        String additionalAssignees = row.get(10);
        List parsedAdditionalAssignees = StringUtils.splitToList((String)additionalAssignees, (String)";");
        specItemBuilder.additionalAssignees(parsedAdditionalAssignees);
        String linkRoles = row.get(11);
        List parsedLinkRoles = StringUtils.splitToList((String)linkRoles, (String)";");
        String linkedSpecItems = row.get(12);
        List parsedLinkedSpecItems = StringUtils.splitToList((String)linkedSpecItems, (String)";").stream().map(items -> StringUtils.splitToList((String)items, (String)",")).collect(Collectors.toList());
        String type = row.get(13);
        String typeAbbreviation = row.get(14);
        specItemBuilder.linkedSpecItems(parsedLinkRoles, parsedLinkedSpecItems).typeInfo(new TeamscaleIssueTypeInfo(type, typeAbbreviation));
        return specItemBuilder.build();
    }
}

